---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：14-Graphviz DIコンテナダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/DependencyInjection/Dumper/GraphvizDumper.php` 行1-249
- E-02: `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` 行1-27
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行15（帳票No.14定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GraphvizDumperはDumper基底クラスを継承 | E-01（行31） | ○ |
| C-02 | DOT形式のdigraph scグラフを出力 | E-01（行201） | ○ |
| C-03 | デフォルトオプションが6カテゴリ | E-01（行36-43） | ○ |
| C-04 | node.instance.fillcolorは#9999ff | E-01（行40） | ○ |
| C-05 | node.missing.fillcolorは#ff9999 | E-01（行42） | ○ |
| C-06 | dotize()で非英数字をアンダースコア変換 | E-01（行234-236） | ○ |
| C-07 | findNodes()でDefinitionとインスタンスを区別 | E-01（行149-182） | ○ |
| C-08 | findEdges()が再帰的にReference等を探索 | E-01（行112-147） | ○ |
| C-09 | cloneContainer()でコンテナクローンを作成 | E-01（行184-197） | ○ |
| C-10 | 共有サービスはfilled、非共有はdotted | E-01（行167） | ○ |
| C-11 | 遅延ロードの依存は青色 | E-01（行102） | ○ |
| C-12 | ParameterNotFoundExceptionはキャッチ無視 | E-01（行162-165） | ○ |
| C-13 | 環境変数プレースホルダ解決 | E-01（行82） | ○ |
| C-14 | パフォーマンス要件として1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推測値
  - 候補：ベンチマーク計測

## 5) リスクフラグ（レビュー観点）
- 0: GraphvizDumperの処理フロー -- 低リスク
- 0: DOT出力構造 -- 低リスク
- 1: パフォーマンス要件 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトオプションの値がソースコードと一致しているか
- [ ] findEdges()の再帰探索が全てのケースを網羅しているか
- [ ] ノードの色分けルールが正確か
