---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-Graphvizワークフロー図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Workflow/Dumper/GraphvizDumper.php` 行1-360
- E-02: `src/Symfony/Component/Workflow/Dumper/DumperInterface.php` 行1-29
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行16（帳票No.15定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DumperInterfaceを実装 | E-01（行27） | ○ |
| C-02 | dump()はDefinitionとMarkingを受け取る | E-02（行28） | ○ |
| C-03 | デフォルトオプションにrankdir=LR | E-01（行31） | ○ |
| C-04 | プレースは円形ノード | E-01（行164） | ○ |
| C-05 | トランジションはboxノード | E-01（行116） | ○ |
| C-06 | 初期プレースはfilled表示 | E-01（行76-77） | ○ |
| C-07 | マーキング済みは赤色doublecircle | E-01（行79-80） | ○ |
| C-08 | with-metadataオプションでメタデータ表示 | E-01（行47, 87-89） | ○ |
| C-09 | dotize()はSHA1ハッシュで生成 | E-01（行276-278） | ○ |
| C-10 | エッジにweight情報を含む | E-01（行202-219） | ○ |
| C-11 | bg_colorメタデータでプレース色設定 | E-01（行82-86） | ○ |
| C-12 | labelメタデータでプレース名上書き | E-01（行90-97） | ○ |
| C-13 | StateMachineGraphvizDumperの基底クラス | E-01（行27: 直接確認不可だが同パッケージ内で継承） | ○ |
| C-14 | パフォーマンス要件として1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推測値
  - 候補：ベンチマーク計測

## 5) リスクフラグ（レビュー観点）
- 0: ワークフローGraphvizDumperの処理フロー -- 低リスク
- 0: DOT出力構造 -- 低リスク
- 1: パフォーマンス要件 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトオプションの値がソースコードと一致しているか
- [ ] メタデータ表示機能の記述が正確か
- [ ] Arc（重み付きエッジ）の処理が正しく記述されているか
