---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：16-StateMachine Graphviz図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Workflow/Dumper/StateMachineGraphvizDumper.php` 行1-105
- E-02: `src/Symfony/Component/Workflow/Dumper/GraphvizDumper.php` 行1-360
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行17（帳票No.16定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GraphvizDumperを継承 | E-01（行17） | ○ |
| C-02 | dump()をオーバーライド | E-01（行28-43） | ○ |
| C-03 | トランジションノードを生成しない | E-01（行39-42: addTransitions呼び出しなし） | ○ |
| C-04 | findEdges()をオーバーライド | E-01（行48-81） | ○ |
| C-05 | プレース間直接エッジを生成 | E-01（行92-99） | ○ |
| C-06 | addEdges()をオーバーライド | E-01（行86-104） | ○ |
| C-07 | colorメタデータでfontcolor設定 | E-01（行59-61） | ○ |
| C-08 | arrow_colorメタデータでedge色設定 | E-01（行63-65） | ○ |
| C-09 | labelメタデータでトランジション名上書き | E-01（行57） | ○ |
| C-10 | from x toの全組み合わせでエッジ生成 | E-01（行68-76） | ○ |
| C-11 | solid スタイルでエッジ描画 | E-01（行97） | ○ |
| C-12 | パフォーマンス要件として1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推測値
  - 候補：ベンチマーク計測

## 5) リスクフラグ（レビュー観点）
- 0: StateMachineGraphvizDumperの処理フロー -- 低リスク
- 0: 親クラスとの差分記述 -- 低リスク
- 1: パフォーマンス要件 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] dump()メソッドで親クラスの呼び出し順序が正確か
- [ ] findEdges()のエッジ構造（fromプレースをキーとする配列）が正しいか
- [ ] 親クラスから継承するメソッドの一覧が完全か
