---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-Mermaidワークフロー図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Workflow/Dumper/MermaidDumper.php` 行1-264
- E-02: `src/Symfony/Component/Workflow/Dumper/DumperInterface.php` 行1-29
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行18（帳票No.17定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DumperInterfaceを実装 | E-01（行19） | ○ |
| C-02 | 5方向の定数定義（TB,TD,BT,RL,LR） | E-01（行21-25） | ○ |
| C-03 | statemachineとworkflowの2タイプ | E-01（行35-36） | ○ |
| C-04 | デフォルト方向はLR | E-01（行51） | ○ |
| C-05 | 初期プレースはスタジアム型 | E-01（行140） | ○ |
| C-06 | 通常プレースは二重丸型 | E-01（行138） | ○ |
| C-07 | ダブルクォートは#quot;にエスケープ | E-01（行180-181） | ○ |
| C-08 | bg_colorメタデータでfill設定 | E-01（行156-159） | ○ |
| C-09 | マーキング済みはstroke-width:4px | E-01（行163-165） | ○ |
| C-10 | statemachineではplace間直接接続 | E-01（行199-211） | ○ |
| C-11 | workflowではトランジションノード経由 | E-01（行213-254） | ○ |
| C-12 | linkStyleでエッジ色設定 | E-01（行256-263） | ○ |
| C-13 | 重複エッジはスキップ | E-01（行108-115） | ○ |
| C-14 | InvalidArgumentExceptionでdirectionバリデーション | E-01（行186-189） | ○ |
| C-15 | InvalidArgumentExceptionでtransitionTypeバリデーション | E-01（行192-196） | ○ |
| C-16 | パフォーマンス要件として1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推測値
  - 候補：ベンチマーク計測

## 5) リスクフラグ（レビュー観点）
- 0: MermaidDumperの処理フロー -- 低リスク
- 0: Mermaid記法の構造 -- 低リスク
- 1: パフォーマンス要件 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] statemachineモードとworkflowモードの出力差異が正確か
- [ ] プレース形状のMermaid記法が正しいか
- [ ] linkCountの管理ロジックが正確に説明されているか
