---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-PlantUMLワークフロー図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` 行1-253
- E-02: `src/Symfony/Component/Workflow/Dumper/DumperInterface.php` 行1-29
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行19（帳票No.18定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DumperInterfaceを実装 | E-01（行28） | ○ |
| C-02 | arrowとsquareの2トランジションタイプ | E-01（行33-35） | ○ |
| C-03 | DEFAULT_OPTIONSにskinparams設定 | E-01（行36-52） | ○ |
| C-04 | @startuml/@endumlで囲む | E-01（行126-133） | ○ |
| C-05 | allow_mixingが有効 | E-01（行128） | ○ |
| C-06 | 初期プレースに<<initial>>付加 | E-01（行196） | ○ |
| C-07 | マーキング済みに<<marked>>付加 | E-01（行197） | ○ |
| C-08 | bg_colorでBackgroundColorステレオタイプ生成 | E-01（行155-161） | ○ |
| C-09 | workflowモードでagent要素を使用 | E-01（行73-78） | ○ |
| C-10 | arrowモードでプレース間直接矢印 | E-01（行111-112） | ○ |
| C-11 | squareモードでagent経由の矢印 | E-01（行95-110） | ○ |
| C-12 | 重複行の追加防止 | E-01（行107-109） | ○ |
| C-13 | ダブルクォートは除去される | E-01（行186） | ○ |
| C-14 | arrow_colorで矢印色設定 | E-01（行88-93） | ○ |
| C-15 | colorメタデータでfontcolor設定 | E-01（行221-233） | ○ |
| C-16 | パフォーマンス要件として1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推測値
  - 候補：ベンチマーク計測

## 5) リスクフラグ（レビュー観点）
- 0: PlantUmlDumperの処理フロー -- 低リスク
- 0: PlantUML記法の構造 -- 低リスク
- 1: パフォーマンス要件 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] arrowモードとsquareモードの出力差異が正確か
- [ ] DEFAULT_OPTIONSの値がソースコードと一致しているか
- [ ] skinparams生成ロジックが正確に記述されているか
