---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-Mermaidロール階層図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Security/Core/Dumper/MermaidDumper.php` 行1-88
- E-02: `src/Symfony/Component/Security/Core/Dumper/MermaidDirection.php` 行1-21
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行20（帳票No.19定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dump()はRoleHierarchyInterfaceとMermaidDirectionを受け取る | E-01（行30） | ○ |
| C-02 | デフォルト方向はTOP_TO_BOTTOM | E-01（行30）, E-02（行16） | ○ |
| C-03 | extractHierarchy()でReflectionアクセス | E-01（行54-65） | ○ |
| C-04 | RoleHierarchy以外は空配列 | E-01（行56-58） | ○ |
| C-05 | 空階層時はデフォルトスタイルのみ返却 | E-01（行34-36） | ○ |
| C-06 | デフォルトスタイルはfill:#e1f5fe | E-01（行35） | ○ |
| C-07 | getAllRoles()で重複排除 | E-01（行67-79） | ○ |
| C-08 | normalizeRoleName()で非英数字をアンダースコア変換 | E-01（行84-87） | ○ |
| C-09 | 親→子のエッジを --> で表現 | E-01（行47） | ○ |
| C-10 | MermaidDirection enumで5方向サポート | E-02（行14-21） | ○ |
| C-11 | 各ロールをインデント付きで出力 | E-01（行42） | ○ |
| C-12 | 出力は改行で結合 | E-01（行51） | ○ |
| C-13 | array_filter()で空行を除去 | E-01（行51） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: MermaidDumperの処理フロー -- 低リスク
- 0: ロール名の正規化 -- 低リスク
- 1: Reflectionアクセスの将来的な互換性 -- 中リスク（RoleHierarchyの内部構造変更時に影響あり）

## 6) レビュアーチェックリスト（最小）
- [ ] extractHierarchy()のReflectionアクセスが最新のRoleHierarchyクラスと整合するか
- [ ] normalizeRoleName()の正規表現が適切か
- [ ] 空階層時の出力形式が正しいか
