---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-XML設定リファレンス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **CLIコマンド連携の詳細**: config:dump-referenceコマンドとの統合部分は推定
  2. **パフォーマンス要件**: 100ms以内という目標出力時間は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php` 全体（292行）
- E-02: `src/Symfony/Component/Config/Definition/ConfigurationInterface.php`
- E-03: `src/Symfony/Component/Config/Definition/NodeInterface.php`
- E-04: `src/Symfony/Component/Config/Definition/ArrayNode.php`
- E-05: `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php`
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 21行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XmlReferenceDumperはConfigurationInterfaceからXML設定リファレンスを生成する | E-01 (34-37行目), E-06 | ○ |
| C-02 | dump()メソッドとdumpNode()メソッドの2つの公開APIがある | E-01 (34行目, 39行目) | ○ |
| C-03 | ノード名のアンダースコアがハイフンに変換される | E-01 (63行目: `str_replace('_', '-', $rootName)`) | ○ |
| C-04 | デフォルトネームスペースは `http://example.org/schema/dic/{nodeName}` | E-01 (52行目) | ○ |
| C-05 | XML Remappingが処理される | E-01 (55-62行目: `getXmlRemappings()`) | ○ |
| C-06 | ArrayNodeの子はスカラーノード=属性、ArrayNode=子要素に分類される | E-01 (118-124行目, 127-165行目) | ○ |
| C-07 | コメントにinfo, example, required, deprecated, enum情報が含まれる | E-01 (134-155行目) | ○ |
| C-08 | PrototypedArrayNodeはプロトタイプパターンで処理される | E-01 (83-115行目) | ○ |
| C-09 | writeValue()でbool/null/array等をXML文字列に変換する | E-01 (260-291行目) | ○ |
| C-10 | インデントは深さ*4スペースで計算される | E-01 (249-255行目: writeLine) | ○ |
| C-11 | 複数属性時は改行して各属性を別行に出力する | E-01 (211-229行目) | ○ |
| C-12 | 自己閉じタグ（`/>`）は子要素がない場合に使用される | E-01 (197行目, 204行目) | ○ |
| C-13 | 文字コードはUTF-8でPHP_EOLに依存する改行コード | E-01 (254行目: `\PHP_EOL`) | ○ |
| C-14 | EnumNodeのpermissibleValuesはセミコロン区切りで出力 | E-01 (151行目: `getPermissibleValues('; ')`) | ○ |
| C-15 | config:dump-referenceコマンドから利用される | **根拠なし** | △ |
| C-16 | パフォーマンス目標は100ms以内 | **根拠なし** | △ |
| C-17 | writeNode()は再帰的に呼ばれる | E-01 (234行目: `$this->writeNode($child, $depth + 4)`) | ○ |
| C-18 | referenceフィールドに出力が蓄積され最終的に文字列として返却される | E-01 (41-46行目, 254行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-15: config:dump-referenceコマンドとの統合部分はFrameworkBundleのコマンドクラスに定義されているが、本プロジェクト範囲外の可能性がある
  - 候補：`ConfigDumpReferenceCommand.php` / Symfonyドキュメント
- C-16: パフォーマンス要件はコード上に定義されておらず、一般的な推定値を記載した
  - 候補：ベンチマークテスト / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに忠実な記述が大半
- 1: 中リスク - CLIコマンド連携は推定であり、実際の統合コードを確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] writeNode()の再帰処理記述がソースコードと整合しているか
- [ ] XML Remappingの説明が正確か
- [ ] config:dump-referenceコマンドとの連携が実際のコードと合致するか
- [ ] PrototypedArrayNodeの処理フロー記述に漏れがないか
