---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：22-HTML変数ダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス目標値**: 50ms以内という数値は推定
  2. **WebProfiler統合の詳細**: WebProfiler側の実装は本ファイル範囲外

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php`（979行）
- E-02: `src/Symfony/Component/VarDumper/Dumper/CliDumper.php`（667行）
- E-03: `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php`（232行）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 22行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HtmlDumperはCliDumperを継承する | E-01 (22行目: `class HtmlDumper extends CliDumper`) | ○ |
| C-02 | darkテーマとlightテーマの2種類を標準提供 | E-01 (27-62行目: `$themes` 配列) | ○ |
| C-03 | デフォルト出力先はphp://output | E-01 (25行目: `$defaultOutput = 'php://output'`) | ○ |
| C-04 | dumpIdは `sf-dump-` + mt_rand() で生成 | E-01 (82行目) | ○ |
| C-05 | displayOptionsにmaxDepth(1), maxStringLength(160), fileLinkFormatがある | E-01 (72-76行目) | ○ |
| C-06 | getDumpHeader()でJavaScriptとCSSを含むヘッダーを生成 | E-01 (142-768行目) | ○ |
| C-07 | dumpPrefix/dumpSuffixでpreタグとSfdumpスクリプトを出力 | E-01 (65-66行目) | ○ |
| C-08 | style()メソッドでHTMLのspanタグによるスタイリングを行う | E-01 (822-934行目) | ○ |
| C-09 | 画像データのBase64インライン表示に対応 | E-01 (770-783行目: `dumpString()` で `img-data` 属性処理) | ○ |
| C-10 | enterHash()で`<samp>`タグによるネスト構造を出力 | E-01 (785-811行目) | ○ |
| C-11 | dumpLine()でmb_encode_numericentityによるHTML数値エンティティ変換 | E-01 (955行目) | ○ |
| C-12 | setTheme()で存在しないテーマ指定時にInvalidArgumentException | E-01 (94-97行目) | ○ |
| C-13 | 省略表示（ellipsis）にはsf-dump-ellipsisクラスが使用される | E-01 (862-878行目) | ○ |
| C-14 | 参照リンクはhrefでアンカー遷移する | E-01 (830-837行目) | ○ |
| C-15 | Unicode制御文字は`\u{XXXX}`形式で可視化される | E-01 (910行目) | ○ |
| C-16 | htmlspecialcharsでXSSエスケープ済み | E-01 (975-978行目: `esc()` 関数) | ○ |
| C-17 | 検索機能はXPathを使用して実装 | E-01 (544行目: `doc.evaluate`) | ○ |
| C-18 | fileLinkFormatでソースコードリンクを生成 | E-01 (963-972行目: `getSourceLink()`) | ○ |
| C-19 | パフォーマンス目標は50ms以内 | **根拠なし** | △ |
| C-20 | WebProfilerからdump()関数経由で呼ばれる | **根拠なし**（WebProfiler側の実装） | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: パフォーマンス目標値はコード上に定義されておらず、デバッグツールとしての一般的な推定値
  - 候補：パフォーマンステスト / 非機能要件定義書
- C-20: WebProfilerとの統合はSymfony WebProfilerBundle側の実装であり、本コンポーネント外
  - 候補：`WebProfilerBundle` / `DumpDataCollector.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HtmlDumper.phpのソースコードに基づく記述が大半
- 1: 中リスク - JavaScriptの動作に関する記述はコードリーディングのみで確認

## 6) レビュアーチェックリスト（最小）
- [ ] テーマ定義（dark/light）のCSSプロパティがソースコードと一致するか
- [ ] style()メソッドのHTMLエスケープ処理記述が正確か
- [ ] JavaScript機能（検索・折りたたみ）の動作説明に誤りがないか
- [ ] 画像Base64インライン表示の条件記述が正確か
