---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-CLI変数ダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス目標値**: 30ms以内という数値は推定

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/VarDumper/Dumper/CliDumper.php`（667行）
- E-02: `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php`（232行）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 23行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CliDumperはAbstractDumperを継承する | E-01 (23行目) | ○ |
| C-02 | デフォルト出力先はphp://stdout | E-01 (27行目) | ○ |
| C-03 | ANSIカラーコードのスタイル定義が14種類 | E-01 (31-46行目) | ○ |
| C-04 | 制御文字マップ（\t,\n,\v,\f,\r,\e） | E-01 (49-56行目) | ○ |
| C-05 | Unicode不可視文字の正規表現パターン | E-01 (57行目) | ○ |
| C-06 | Windows環境で基本16色にフォールバック | E-01 (72-85行目) | ○ |
| C-07 | NO_COLOR/FORCE_COLOR環境変数に対応 | E-01 (596-604行目) | ○ |
| C-08 | supportsColors()で多段カラーサポート検出 | E-01 (520-557行目) | ○ |
| C-09 | dumpScalar()で型別にスタイルを割り当て | E-01 (126-185行目) | ○ |
| C-10 | dumpString()で複数行文字列を三連クォート表示 | E-01 (222-227行目) | ○ |
| C-11 | enterHash()でオブジェクト/配列/リソースの開始出力 | E-01 (276-311行目) | ○ |
| C-12 | dumpKey()でpublic(+)/protected(#)/private(-)接頭辞 | E-01 (377-378行目, 396行目, 401行目) | ○ |
| C-13 | style()でANSIエスケープシーケンス付加 | E-01 (480-491行目) | ○ |
| C-14 | OSCハイパーリンク対応 | E-01 (494-508行目) | ○ |
| C-15 | JetBrains-JediTermとKonsole旧版ではhref非対応 | E-01 (438-440行目) | ○ |
| C-16 | DUMP_TRAILING_COMMA/DUMP_COMMA_SEPARATORフラグ | E-01 (573-579行目: `endValue()`) | ○ |
| C-17 | isWindowsTrueColor()でWindows 10.0.15063以降を検出 | E-01 (639-657行目) | ○ |
| C-18 | パフォーマンス目標は30ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: パフォーマンス目標値はコード上に定義されておらず、CLI実行の一般的な推定値
  - 候補：ベンチマークテスト / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく記述がほぼ全体

## 6) レビュアーチェックリスト（最小）
- [ ] ANSIカラーコード定義がソースと一致するか
- [ ] supportsColors()の判定ロジック記述が正確か
- [ ] dumpKey()のアクセス修飾子接頭辞記述が正確か
- [ ] 制御文字・Unicode可視化の記述に漏れがないか
