---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：24-HTMLエラーページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **テンプレートファイルの詳細内容**: PHPテンプレートの詳細構造は未読
  2. **パフォーマンス要件**: 200msという目標値は推定

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php`（350行）
- E-02: `src/Symfony/Component/ErrorHandler/ErrorRenderer/ErrorRendererInterface.php`（37行）
- E-03: `src/Symfony/Component/ErrorHandler/ErrorRenderer/FileLinkFormatter.php`（103行）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 24行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ErrorRendererInterfaceを実装 | E-01 (25行目) | ○ |
| C-02 | デバッグモードと本番モードで異なるテンプレートを使用 | E-01 (125-148行目) | ○ |
| C-03 | Content-Typeはtext/html + charset | E-01 (64行目) | ○ |
| C-04 | デバッグ時にX-Debug-Exception/X-Debug-Exception-Fileヘッダーを出力 | E-01 (65-68行目) | ○ |
| C-05 | 例外メッセージは先頭2000文字をURLエンコード | E-01 (66行目: `substr(..., 0, 2000)`) | ○ |
| C-06 | FlattenException::createWithDataRepresentation()で例外をフラット化 | E-01 (70行目) | ○ |
| C-07 | debugモードではexception_full.html.php、本番ではerror.html.phpを使用 | E-01 (132-136行目, 140行目) | ○ |
| C-08 | setTemplate()でカスタムテンプレート設定可能 | E-01 (345-348行目) | ○ |
| C-09 | 特別日ゴーストアドオン: 02-14(ハート), 02-29(+), 10-18(ギフト) | E-01 (27-35行目) | ○ |
| C-10 | fileExcerpt()でhighlight_file()を使用 | E-01 (257行目) | ○ |
| C-11 | ソースコード抜粋は前後3行 | E-01 (252行目: `$srcContext = 3`) | ○ |
| C-12 | HtmlDumper(lightテーマ)を内部使用 | E-01 (152-153行目) | ○ |
| C-13 | htmlspecialchars()でエスケープ | E-01 (189-192行目: `escape()`) | ○ |
| C-14 | isDebug()でRequestStackから動的デバッグ判定 | E-01 (96-104行目) | ○ |
| C-15 | getAndCleanOutputBuffer()でOBレベル管理 | E-01 (106-123行目) | ○ |
| C-16 | FileLinkFormatterでファイルリンク生成 | E-01 (240行目), E-03 | ○ |
| C-17 | formatArgs()で引数をHTML整形 | E-01 (158-182行目) | ○ |
| C-18 | テンプレートファイルの詳細HTML構造 | **根拠なし**（テンプレート未読） | △ |
| C-19 | パフォーマンス目標200ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: テンプレートファイル（error.html.php, exception_full.html.php）の実際のHTML構造は読み込んでいない
  - 候補：`src/Symfony/Component/ErrorHandler/Resources/views/` 配下のファイル
- C-19: パフォーマンス目標値は推定値
  - 候補：ベンチマーク / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - テンプレートファイルの詳細内容を読み込んでいないため、レイアウト記述が推定を含む
- 0: 低リスク - PHPコード部分はソースに基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレートファイルの実際の構造がレイアウト記述と一致するか
- [ ] デバッグモード判定ロジックの記述が正確か
- [ ] セキュリティ考慮事項の記述が網羅的か
- [ ] 特別日アドオンの日付が正しいか
