---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-ストリーミングJSONレスポンス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全Claimに根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/HttpFoundation/StreamedJsonResponse.php`（162行）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 28行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamedResponseを継承 | E-01 (45行目) | ○ |
| C-02 | PLACEHOLDERは`__symfony_json__` | E-01 (47行目) | ○ |
| C-03 | Content-Typeはapplication/json | E-01 (63-65行目) | ○ |
| C-04 | JSON_THROW_ON_ERRORを常に付加 | E-01 (70行目) | ○ |
| C-05 | キーエンコードオプションでJSON_NUMERIC_CHECKを除外 | E-01 (71行目) | ○ |
| C-06 | streamData()でデータ型を3分岐 | E-01 (76-91行目) | ○ |
| C-07 | JsonSerializableはjson_encode直接 | E-01 (84行目, 90行目) | ○ |
| C-08 | streamArray()でarray_walk_recursiveによるプレースホルダー置換 | E-01 (97-113行目) | ○ |
| C-09 | explodeでJSONパーツに分割 | E-01 (115行目) | ○ |
| C-10 | streamIterable()で最初のキーによるリスト/マップ判定 | E-01 (133-141行目) | ○ |
| C-11 | 空Generatorでは`[]`を出力 | E-01 (156-157行目) | ○ |
| C-12 | マップ形式ではキーをJSON文字列として出力 | E-01 (149-151行目) | ○ |
| C-13 | カンマ区切りで要素を接続 | E-01 (146行目) | ○ |
| C-14 | streamData()は再帰的に呼ばれる | E-01 (121行目, 153行目) | ○ |
| C-15 | encodingOptionsはJsonResponse::DEFAULT_ENCODING_OPTIONSがデフォルト | E-01 (59行目) | ○ |
| C-16 | $this->stream(...)をコールバックとして親に渡す | E-01 (61行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全Claimに根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなクラス（162行）であり全体を精読済み

## 6) レビュアーチェックリスト（最小）
- [ ] プレースホルダー置換の仕組みが正しく記述されているか
- [ ] リスト/マップ判定ロジックが正確か
- [ ] 再帰的streamData()呼び出しの記述に矛盾がないか
