---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：29-コンパイル済みURLマッチャーダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **出力ファイルパスの詳細**: キャッシュディレクトリ内のファイル名はフレームワーク側の設定に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherDumper.php`（502行）
- E-02: `src/Symfony/Component/Routing/Matcher/Dumper/MatcherDumper.php`（32行）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 29行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MatcherDumperを継承 | E-01 (27行目), E-02 | ○ |
| C-02 | dump()でPHP配列ファイルを生成 | E-01 (37-51行目) | ○ |
| C-03 | 5要素の配列構造（matchHost, staticRoutes, regexpList, dynamicRoutes, checkCondition） | E-01 (131行目) | ○ |
| C-04 | groupStaticRoutes()で静的/動的ルートを分離 | E-01 (83行目, 164-202行目) | ○ |
| C-05 | パス変数なしのルートが静的に分類される | E-01 (180行目: `!getPathVariables()`) | ○ |
| C-06 | ホストマッチング判定 | E-01 (64-68行目) | ○ |
| C-07 | ホスト正規表現の逆順変換 | E-01 (69行目: `strtr(strrev($host), ...`) | ○ |
| C-08 | 動的ルートの正規表現はツリー構造 | E-01 (252-368行目, 376-416行目) | ○ |
| C-09 | チャンクサイズ自動調整（正規表現サイズ超過時） | E-01 (89-102行目) | ○ |
| C-10 | compileRoute()で7要素配列生成 | E-01 (437-446行目) | ○ |
| C-11 | ExpressionLanguage未インストール時のエラー | E-01 (451-453行目) | ○ |
| C-12 | export()メソッドがpublic staticで他クラスからも使用可能 | E-01 (468行目) | ○ |
| C-13 | 名前付きサブパターン(*:mark)でマッチルート特定 | E-01 (407行目) | ○ |
| C-14 | set_error_handlerで正規表現サイズ超過を検出 | E-01 (354行目) | ○ |
| C-15 | trailing slash判定 | E-01 (174-178行目) | ○ |
| C-16 | 条件式のコンパイル（ExpressionLanguage） | E-01 (430-435行目) | ○ |
| C-17 | StaticPrefixCollectionで接頭辞グループ化 | E-01 (65行目, 328行目) | ○ |
| C-18 | Unicode/非Unicodeの修飾子別チャンク分割 | E-01 (282-290行目) | ○ |
| C-19 | 自動生成コメント付きPHPファイル | E-01 (39-50行目) | ○ |
| C-20 | 出力ファイルパスはvar/cache/{env}/... | **根拠なし**（フレームワーク側の設定） | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: 出力ファイルパスはSymfony FrameworkBundleのRouter設定に依存し、本クラスでは文字列を返すのみ
  - 候補：`Symfony\Bundle\FrameworkBundle\Routing\Router.php`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 動的ルートの正規表現生成ロジックは複雑であり、詳細記述の正確性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 5要素配列構造の説明が正確か
- [ ] 正規表現ツリー生成の記述に矛盾がないか
- [ ] チャンクサイズ自動調整ロジックが正しく説明されているか
- [ ] ExpressionLanguage条件式コンパイルの記述が正確か
