---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：30-コンパイル済みURLジェネレーターダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **出力ファイルパスの詳細**: キャッシュディレクトリ内のファイル名はフレームワーク側の設定に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php`（121行）
- E-02: `src/Symfony/Component/Routing/Generator/Dumper/GeneratorDumper.php`（32行）
- E-03: `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherDumper.php`（export()メソッド）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 30行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GeneratorDumperを継承 | E-01 (25行目), E-02 | ○ |
| C-02 | getCompiledRoutes()で全ルートをコンパイル | E-01 (27-45行目) | ○ |
| C-03 | 7要素配列（variables, defaults, requirements, tokens, hostTokens, schemes, deprecations） | E-01 (33-41行目) | ○ |
| C-04 | getCompiledAliases()でエイリアスを解決 | E-01 (47-89行目) | ○ |
| C-05 | 循環参照検出でRouteCircularReferenceException | E-01 (56-59行目) | ○ |
| C-06 | ターゲット不存在でRouteNotFoundException | E-01 (72行目) | ○ |
| C-07 | エイリアスチェーン中のdeprecationを全て収集 | E-01 (62-64行目) | ○ |
| C-08 | trigger_deprecation()がダンプ時に発行される | E-01 (64行目) | ○ |
| C-09 | CompiledUrlMatcherDumper::export()を再利用 | E-01 (112行目, 116行目), E-03 | ○ |
| C-10 | dump()でPHPファイルテンプレートを生成 | E-01 (91-102行目) | ○ |
| C-11 | 自動生成コメント付きPHPファイル | E-01 (93-96行目) | ○ |
| C-12 | visitedリストで循環参照を検出 | E-01 (54-59行目) | ○ |
| C-13 | ルート定義順にコンパイル結果を出力 | E-01 (30行目: `foreach all()`) | ○ |
| C-14 | エイリアスはルートの後に追加 | E-01 (108-117行目: getCompiledRoutes → getCompiledAliases) | ○ |
| C-15 | クラスは121行のコンパクトな実装 | E-01 全体 | ○ |
| C-16 | 出力ファイルパスはvar/cache/{env}/... | **根拠なし**（フレームワーク側の設定） | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: 出力ファイルパスはSymfony FrameworkBundleのRouter設定に依存し、本クラスでは文字列を返すのみ
  - 候補：`Symfony\Bundle\FrameworkBundle\Routing\Router.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなクラス（121行）であり全体を精読済み

## 6) レビュアーチェックリスト（最小）
- [ ] 7要素配列の構造がソースコードと一致するか
- [ ] エイリアス循環参照検出ロジックが正しく記述されているか
- [ ] trigger_deprecation()の呼び出しタイミング記述が正確か
- [ ] CompiledUrlMatcherDumper::export()の再利用記述が正確か
