---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-JSON国際化バンドル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数（約1500ファイル）**：具体的な数値の根拠が不十分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Intl/Data/Bundle/Writer/JsonBundleWriter.php`（行21-39）
- E-02: `src/Symfony/Component/Intl/Data/Bundle/Writer/BundleWriterInterface.php`（行21-24）
- E-03: `src/Symfony/Component/Intl/Data/Generator/AbstractDataGenerator.php`（行28-104）
- E-04: `src/Symfony/Component/Intl/Data/Generator/GeneratorConfig.php`（行23-70）
- E-05: `src/Symfony/Component/Intl/Data/Bundle/Reader/JsonBundleReader.php`
- E-06: `src/Symfony/Component/Intl/Data/Generator/CurrencyDataGenerator.php`
- E-07: `src/Symfony/Component/Intl/Data/Generator/LanguageDataGenerator.php`
- E-08: `src/Symfony/Component/Intl/Data/Generator/RegionDataGenerator.php`
- E-09: `src/Symfony/Component/Intl/Data/Generator/ScriptDataGenerator.php`
- E-10: `src/Symfony/Component/Intl/Data/Generator/TimezoneDataGenerator.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonBundleWriterはBundleWriterInterfaceを実装している | E-01 (行21) | ○ |
| C-02 | writeメソッドは3引数（path, locale, data）を受け取る | E-02 (行23) | ○ |
| C-03 | Traversableオブジェクトはiterator_to_arrayで配列に変換される | E-01 (行25-27) | ○ |
| C-04 | array_walk_recursiveで再帰的にTraversableを変換する | E-01 (行29-33) | ○ |
| C-05 | JSON_PRETTY_PRINTオプションが使用される | E-01 (行35) | ○ |
| C-06 | JSON_UNESCAPED_UNICODEオプションが使用される | E-01 (行35) | ○ |
| C-07 | ファイル末尾に改行文字が付加される | E-01 (行35: `."\\n"`) | ○ |
| C-08 | ファイル名は{locale}.json形式 | E-01 (行37: `$path.'/'.$locale.'.json'`) | ○ |
| C-09 | file_put_contentsでファイル出力される | E-01 (行37) | ○ |
| C-10 | AbstractDataGeneratorがWriterの呼び出し元である | E-03 (行64-65) | ○ |
| C-11 | GeneratorConfigでBundleWriterが登録・管理される | E-04 (行39, 49) | ○ |
| C-12 | ロケールごとのループでデータ生成とWriter呼び出しが行われる | E-03 (行60-68) | ○ |
| C-13 | rootデータとmetaデータも別途生成される | E-03 (行70-84) | ○ |
| C-14 | 一時ディレクトリが処理後に削除される | E-03 (行87) | ○ |
| C-15 | @internalアノテーションによりSymfony内部利用のみ | E-01 (行19), E-02 (行19) | ○ |
| C-16 | 対応するJsonBundleReaderが存在する | E-05 | ○ |
| C-17 | 5種類のDataGenerator（通貨/言語/地域/スクリプト/タイムゾーン）が存在する | E-06, E-07, E-08, E-09, E-10 | ○ |
| C-18 | 想定データ件数は約300ロケール x 5種別 = 約1500ファイル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18の想定データ件数（約300ロケール）は概算であり、実際のICUデータに含まれるロケール数はバージョンによって異なる
  - 候補：ICU公式ドキュメント / Symfony Intlコンポーネントのロケールデータ / 実際のビルド出力ログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの行番号レベルで根拠が確認できる主張がほとんどである
- 1: 中リスク - パフォーマンス要件の具体的な数値は推定値であり、実測データに基づいていない

## 6) レビュアーチェックリスト（最小）
- [ ] JsonBundleWriter.phpのwrite()メソッドの処理フロー記載が実コードと一致するか
- [ ] AbstractDataGenerator.phpの呼び出し順序が正しく記載されているか
- [ ] JSON出力オプション（PRETTY_PRINT, UNESCAPED_UNICODE）の記載が正確か
- [ ] 関連ファイル一覧に漏れがないか
