---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-PHP国際化バンドル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **OPCacheバイトコードキャッシュの恩恵の記述**：一般的知識に基づく推定であり、直接的なコード根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Intl/Data/Bundle/Writer/PhpBundleWriter.php`（行23-46）
- E-02: `src/Symfony/Component/Intl/Data/Bundle/Writer/BundleWriterInterface.php`（行21-24）
- E-03: `src/Symfony/Component/Intl/Data/Generator/AbstractDataGenerator.php`（行28-104）
- E-04: `src/Symfony/Component/Intl/Data/Generator/GeneratorConfig.php`（行23-70）
- E-05: `src/Symfony/Component/VarExporter/VarExporter.php`
- E-06: `src/Symfony/Component/Intl/Data/Bundle/Reader/PhpBundleReader.php`
- E-07: `src/Symfony/Component/Intl/Data/Generator/CurrencyDataGenerator.php`
- E-08: `src/Symfony/Component/Intl/Data/Generator/LanguageDataGenerator.php`
- E-09: `src/Symfony/Component/Intl/Data/Generator/RegionDataGenerator.php`
- E-10: `src/Symfony/Component/Intl/Data/Generator/ScriptDataGenerator.php`
- E-11: `src/Symfony/Component/Intl/Data/Generator/TimezoneDataGenerator.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PhpBundleWriterはBundleWriterInterfaceを実装している | E-01 (行23) | ○ |
| C-02 | writeメソッドは3引数（path, locale, data）を受け取る | E-02 (行23) | ○ |
| C-03 | ヒアドキュメントでPHPテンプレートを定義（`<?php`と`return %s;`） | E-01 (行27-32) | ○ |
| C-04 | Traversableオブジェクトはiterator_to_arrayで配列に変換される | E-01 (行34-36) | ○ |
| C-05 | array_walk_recursiveで再帰的にTraversableを変換する | E-01 (行38-42) | ○ |
| C-06 | VarExporter::export()で配列をPHP文字列に変換する | E-01 (行44), E-05 | ○ |
| C-07 | sprintfでテンプレートに埋め込む | E-01 (行44: `\sprintf($template, ...)`) | ○ |
| C-08 | ファイル名は{locale}.php形式 | E-01 (行44: `$path.'/'.$locale.'.php'`) | ○ |
| C-09 | file_put_contentsでファイル出力される | E-01 (行44) | ○ |
| C-10 | AbstractDataGeneratorがWriterの呼び出し元である | E-03 (行64-65) | ○ |
| C-11 | GeneratorConfigでBundleWriterが登録・管理される | E-04 (行39, 49) | ○ |
| C-12 | ロケールごとのループでデータ生成とWriter呼び出しが行われる | E-03 (行60-68) | ○ |
| C-13 | rootデータとmetaデータも別途生成される | E-03 (行70-84) | ○ |
| C-14 | @internalアノテーションによりSymfony内部利用のみ | E-01 (行19) | ○ |
| C-15 | 対応するPhpBundleReaderが存在する | E-06 | ○ |
| C-16 | 5種類のDataGenerator（通貨/言語/地域/スクリプト/タイムゾーン）が存在する | E-07, E-08, E-09, E-10, E-11 | ○ |
| C-17 | VarExporterはvar_export()の改良版である | E-05 | ○ |
| C-18 | VarExporterを使用しているのでuse宣言がある | E-01 (行14: `use Symfony\Component\VarExporter\VarExporter`) | ○ |
| C-19 | PHPテンプレートにはインデントが含まれる | E-01 (行27-32: HEREDOCテンプレート) | ○ |
| C-20 | OPCacheバイトコードキャッシュの恩恵を受けられる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20のOPCacheに関する記述は、PHPの一般的な動作原理に基づく推定であり、Symfony Intlコンポーネントのコード内には直接的な言及がない
  - 候補：PHP公式ドキュメント（OPCacheセクション） / Symfonyパフォーマンスドキュメント / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの行番号レベルで根拠が確認できる主張がほとんどである
- 0: 低リスク - OPCacheの記述は広く知られたPHPの一般的な動作であり、技術的に正確

## 6) レビュアーチェックリスト（最小）
- [ ] PhpBundleWriter.phpのwrite()メソッドの処理フロー記載が実コードと一致するか
- [ ] ヒアドキュメントテンプレートの記載が正確か
- [ ] VarExporter::export()の使用方法の記載が正確か
- [ ] AbstractDataGenerator.phpの呼び出し順序が正しく記載されているか
- [ ] 関連ファイル一覧に漏れがないか
