---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：33-テキスト国際化バンドル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数（約1500ファイル）**：具体的な数値の根拠が不十分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Intl/Data/Bundle/Writer/TextBundleWriter.php`（行27-205）
- E-02: `src/Symfony/Component/Intl/Data/Bundle/Writer/BundleWriterInterface.php`（行21-24）
- E-03: `src/Symfony/Component/Intl/Data/Generator/AbstractDataGenerator.php`（行28-104）
- E-04: `src/Symfony/Component/Intl/Data/Generator/GeneratorConfig.php`（行23-70）
- E-05: `src/Symfony/Component/Intl/Data/Bundle/Compiler/GenrbCompiler.php`（行23-58）
- E-06: `src/Symfony/Component/Intl/Data/Bundle/Compiler/BundleCompilerInterface.php`
- E-07: ICU BNF仕様（TextBundleWriter.phpのDocBlockコメント行23に記載のURL）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextBundleWriterはBundleWriterInterfaceを実装している | E-01 (行27) | ○ |
| C-02 | writeメソッドに独自の$fallbackパラメータがある（デフォルトtrue） | E-01 (行29) | ○ |
| C-03 | fopen/fwrite/fcloseでストリーム書き込みを行う | E-01 (行31, 35) | ○ |
| C-04 | writeResourceBundleでバンドル名を出力してwriteTableを呼ぶ | E-01 (行46-53) | ○ |
| C-05 | writeResourceで型判定による分岐を行う | E-01 (行63-103) | ○ |
| C-06 | 整数型はwriteIntegerで`:int{N}`形式出力 | E-01 (行65-68, 112-115) | ○ |
| C-07 | Traversableはiterator_to_arrayで配列変換される | E-01 (行71-73) | ○ |
| C-08 | 全要素が整数かつ連番キーの場合writeIntVectorで`:intvector{}`出力 | E-01 (行76-85, 124-133) | ○ |
| C-09 | 連番キーの配列はwriteArrayで配列形式出力 | E-01 (行87-88, 160-173) | ○ |
| C-10 | 連想配列はwriteTableで再帰的にテーブル形式出力 | E-01 (行93, 180-204) | ○ |
| C-11 | ブール値は文字列"true"/"false"に変換される | E-01 (行98-100) | ○ |
| C-12 | 文字列はwriteStringで`{"text"}`または`"text"`形式出力 | E-01 (行102, 142-151) | ○ |
| C-13 | writeStringのrequireBracesパラメータで括弧有無を制御 | E-01 (行142-151) | ○ |
| C-14 | インデントはスペース4文字でネストレベルに応じて増加 | E-01 (行129, 132, 165, 172, 189, 203) | ○ |
| C-15 | コロンまたはスペースを含むキーはダブルクォートで囲む | E-01 (行192-194) | ○ |
| C-16 | nofallback制御は`table(nofallback)`属性で行う | E-01 (行182-184) | ○ |
| C-17 | writeTableのfallbackパラメータはルートテーブルのみに適用 | E-01 (行46: `$fallback`引数が`writeResourceBundle`で渡される, 行93: 再帰呼び出しではfallbackなし) | ○ |
| C-18 | ファイル名は{locale}.txt形式 | E-01 (行31: `$path.'/'.$locale.'.txt'`) | ○ |
| C-19 | ファイル末尾に改行が出力される | E-01 (行52: `fwrite($file, "\\n")`) | ○ |
| C-20 | AbstractDataGeneratorがWriterの呼び出し元である | E-03 (行64-65) | ○ |
| C-21 | ICU BNF記法に準拠している | E-07 (行23のDocBlockコメント) | ○ |
| C-22 | GenrbCompilerで.txtを.resにコンパイル可能 | E-05 (行46-57) | ○ |
| C-23 | GenrbCompilerはgenrbコマンドのラッパーである | E-05 (行35-43) | ○ |
| C-24 | @internalアノテーションによりSymfony内部利用のみ | E-01 (行25) | ○ |
| C-25 | 想定データ件数は約300ロケール x 5種別 = 約1500ファイル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25の想定データ件数（約300ロケール）は概算であり、実際のICUデータに含まれるロケール数はバージョンによって異なる
  - 候補：ICU公式ドキュメント / Symfony Intlコンポーネントのロケールデータ / 実際のビルド出力ログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの行番号レベルで根拠が確認できる主張がほとんどである
- 0: 低リスク - ICU BNF記法の仕様はDocBlockコメントのURLで参照可能

## 6) レビュアーチェックリスト（最小）
- [ ] TextBundleWriter.phpの各writeXxxメソッドの出力形式記載が実コードと一致するか
- [ ] 型判定の分岐条件（整数配列判定、連番キー判定等）が正確に記載されているか
- [ ] nofallback制御の記載が実コードと一致するか
- [ ] キーのエスケープ処理（コロン、スペース）の記載が正確か
- [ ] 関連ファイル一覧に漏れがないか
