---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：34-JSONストリームライター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **初回コード生成の所要時間（数十ms）**：具体的な数値の根拠が不十分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/JsonStreamer/JsonStreamWriter.php`（行40-140）
- E-02: `src/Symfony/Component/JsonStreamer/StreamWriterInterface.php`（行23-31）
- E-03: `src/Symfony/Component/JsonStreamer/Write/StreamWriterGenerator.php`（行41-161）
- E-04: `src/Symfony/Component/JsonStreamer/Write/PhpGenerator.php`（行38-449）
- E-05: `src/Symfony/Component/JsonStreamer/StreamerDumper.php`（行28-106）
- E-06: `src/Symfony/Component/JsonStreamer/Mapping/Write/AttributePropertyMetadataLoader.php`（行30-121）
- E-07: `src/Symfony/Component/JsonStreamer/Mapping/Write/DateTimeTypePropertyMetadataLoader.php`（行25-48）
- E-08: `src/Symfony/Component/JsonStreamer/ValueTransformer/DateTimeToStringValueTransformer.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonStreamWriterはStreamWriterInterfaceを実装している | E-01 (行40) | ○ |
| C-02 | write()メソッドはTraversable&Stringableを返す | E-01 (行62), E-02 (行30) | ○ |
| C-03 | デフォルトオプションが`$options += $this->defaultOptions`でマージされる | E-01 (行64) | ○ |
| C-04 | StreamWriterGenerator::generate()でPHPコードを生成しパスを取得 | E-01 (行65), E-03 (行59-71) | ○ |
| C-05 | require $pathでcallableをロードしインメモリキャッシュ | E-01 (行66: `$this->streamWriters[$path] ??= require $path`) | ○ |
| C-06 | 返却値は匿名クラスでIteratorAggregateとStringableを実装 | E-01 (行68-95) | ○ |
| C-07 | __toString()でチャンクを連結して一括文字列変換 | E-01 (行86-94) | ○ |
| C-08 | create()ファクトリメソッドが存在する | E-01 (行101-139) | ○ |
| C-09 | デフォルトでDateTimeToStringValueTransformerが登録される | E-01 (行104-106) | ○ |
| C-10 | ストリームライターのパスはxxh128ハッシュで決定 | E-03 (行61: `hash('xxh128', (string) $type)`) | ○ |
| C-11 | createDataModel()で型を再帰的にトラバースしてノードツリーを構築 | E-03 (行77-160) | ○ |
| C-12 | UnionType→CompositeNode, BuiltinType→ScalarNode, BackedEnumType→BackedEnumNode | E-03 (行82-91) | ○ |
| C-13 | ObjectType→PropertyMetadataLoader経由でプロパティ情報取得→ObjectNode | E-03 (行98-146) | ○ |
| C-14 | CollectionType→CollectionNode（再帰） | E-03 (行148-157) | ○ |
| C-15 | サポートされない型でUnsupportedExceptionをスロー | E-03 (行159) | ○ |
| C-16 | PhpGenerator::generate()でPHPコード文字列を生成 | E-04 (行46-76) | ○ |
| C-17 | JSON_THROW_ON_ERRORフラグが使用される | E-04 (行334: `\\JSON_THROW_ON_ERROR`) | ○ |
| C-18 | 最大ネスト深度512 | E-04 (行122, 157, 334) | ○ |
| C-19 | NotEncodableValueExceptionがJsonException発生時にスローされる | E-04 (行73) | ○ |
| C-20 | include_null_propertiesオプションでnull値出力を制御 | E-04 (行274) | ○ |
| C-21 | StreamerDumper::dump()でファイル書き出し | E-05 (行44-70) | ○ |
| C-22 | ConfigCacheFactory利用時はReflectionClassResourceでキャッシュ無効化 | E-05 (行47-58) | ○ |
| C-23 | AttributePropertyMetadataLoaderがStreamedNameアトリビュートを処理 | E-06 (行95-98) | ○ |
| C-24 | AttributePropertyMetadataLoaderがValueTransformerアトリビュートを処理 | E-06 (行100-103) | ○ |
| C-25 | DateTimeTypePropertyMetadataLoaderがDateTimeInterface型を自動変換 | E-07 (行39-43) | ○ |
| C-26 | PropertyMetadataLoaderのデコレータチェーン構成 | E-01 (行127-136: create()内の構築コード) | ○ |
| C-27 | PSR-11 ContainerInterface経由でValueTransformerにアクセス | E-01 (行53, 108-123) | ○ |
| C-28 | 初回コード生成の所要時間は数十ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28の初回コード生成の所要時間は推定値であり、ベンチマーク等の具体的な計測データに基づいていない
  - 候補：Symfonyパフォーマンスベンチマーク / JsonStreamerコンポーネントのREADME / プロファイリング結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの行番号レベルで根拠が確認できる主張がほとんどである
- 1: 中リスク - パフォーマンスに関する具体的な数値は推定値
- 0: 低リスク - エラー処理のメッセージ内容はコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] JsonStreamWriter.phpのwrite()メソッドの処理フロー記載が実コードと一致するか
- [ ] StreamWriterGenerator.phpのcreateDataModel()の型分岐が正確に記載されているか
- [ ] PhpGenerator.phpのgenerateYields()のノード型別処理が正確か
- [ ] PropertyMetadataLoaderのデコレータチェーン構成が正確か
- [ ] エラーケース一覧に記載された例外クラスとメッセージが実コードと一致するか
- [ ] 関連ファイル一覧に漏れがないか
