---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 84
  claims_with_evidence: 78
  claims_without_evidence: 6
confidence_derived: 0.93
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：78 / 84、根拠なし：6
- 優先レビュー（高）
  1. **C-46（JSONストリーム処理）**：JsonStreamerコンポーネントの詳細APIまで確認できていない
  2. **C-47（JSONPathクエリ）**：JsonPathコンポーネントのRFC 9535準拠の詳細確認が不足
  3. **C-49（オブジェクトマッピング）**：ObjectMapperコンポーネントの詳細仕様を未確認
  4. **C-57（絵文字処理）**：Emojiコンポーネントの詳細ロジックを未確認
  5. **C-71（リソースヒント）**：WebLinkコンポーネントのHTTP/2 Server Push対応の詳細を未確認
  6. **C-79（UID生成）**：UidコンポーネントのRFC 9562準拠の詳細を未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/HttpKernel/HttpKernel.php` - HttpKernelクラスのリクエスト処理パイプライン
- E-02: `src/Symfony/Component/Routing/Router.php` - Routerクラスのルーティング機構
- E-03: `src/Symfony/Component/HttpFoundation/Session/Session.php` - Sessionクラスのセッション管理
- E-04: `src/Symfony/Component/Security/Http/Firewall.php` - Firewallクラスのセキュリティリスナー登録
- E-05: `src/Symfony/Component/Security/Http/Authenticator/FormLoginAuthenticator.php` - フォームログイン認証
- E-06: `src/Symfony/Component/Security/Http/Authenticator/` - 認証器一覧（HttpBasic, Json, AccessToken, LoginLink, RememberMe, RemoteUser, X509）
- E-07: `src/Symfony/Component/Security/Http/LoginLink/LoginLinkHandler.php` - ログインリンク処理
- E-08: `src/Symfony/Component/Workflow/Workflow.php` - ワークフロー遷移処理とイベント発火
- E-09: `src/Symfony/Component/Workflow/Definition.php` - ワークフロー定義（Place、Transition）
- E-10: `src/Symfony/Component/Messenger/MessageBus.php` - メッセージバスとミドルウェアパイプライン
- E-11: `src/Symfony/Component/Messenger/Worker.php` - ワーカーによるメッセージ処理
- E-12: `src/Symfony/Component/Mailer/Mailer.php` - メール送信（Messenger連携対応）
- E-13: `src/Symfony/Component/Notifier/Notifier.php` - マルチチャネル通知送信
- E-14: `src/Symfony/Component/Scheduler/Scheduler.php` - スケジューラーによる定期実行
- E-15: `src/Symfony/Component/Validator/Constraints/` - バリデーション制約一覧（80種以上）
- E-16: `src/Symfony/Component/Form/Extension/Core/Type/` - フォーム型一覧（40種以上）
- E-17: `src/Symfony/Component/Translation/Translator.php` - 翻訳機構
- E-18: `src/Symfony/Component/Cache/Adapter/AbstractAdapter.php` - キャッシュアダプター基盤
- E-19: `src/Symfony/Component/Lock/` - ロック機構コンポーネント
- E-20: `src/Symfony/Component/RateLimiter/` - レートリミッターコンポーネント
- E-21: `docs/code-to-docs/機能一覧/機能一覧.csv` - 既存機能一覧（68機能）
- E-22: `docs/code-to-docs/画面一覧/画面一覧.csv` - 既存画面一覧（57画面）
- E-23: `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` - テンプレートコントローラー
- E-24: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` - リダイレクトコントローラー
- E-25: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - プロファイラーコントローラー
- E-26: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` - エラーコントローラー
- E-27: `src/Symfony/Component/Security/Http/Impersonate/` - なりすまし機能ディレクトリ
- E-28: `src/Symfony/Component/Semaphore/` - セマフォコンポーネント
- E-29: `src/Symfony/Component/HtmlSanitizer/` - HTMLサニタイザーコンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPリクエスト・レスポンス処理 | E-01, E-21 | ○ |
| C-02 | URLパターンルーティング | E-02, E-21 | ○ |
| C-03 | セッション管理 | E-03, E-21 | ○ |
| C-04 | HTTPクライアント通信 | E-21 | ○ |
| C-05 | HTMLサニタイズ | E-29, E-21 | ○ |
| C-06 | フォームログイン認証 | E-05, E-06 | ○ |
| C-07 | HTTP Basic認証 | E-06 | ○ |
| C-08 | JSON認証 | E-06 | ○ |
| C-09 | アクセストークン認証 | E-06 | ○ |
| C-10 | ログインリンク認証 | E-07 | ○ |
| C-11 | Remember Me認証 | E-06 | ○ |
| C-12 | リモートユーザー認証 | E-06 | ○ |
| C-13 | X.509証明書認証 | E-06 | ○ |
| C-14 | LDAP認証 | E-21 | ○ |
| C-15 | ロールベースアクセス制御 | E-04, E-21 | ○ |
| C-16 | ファイアウォール制御 | E-04 | ○ |
| C-17 | CSRF保護 | E-05, E-21 | ○ |
| C-18 | ユーザーなりすまし | E-27, E-21 | ○ |
| C-19 | パスワードハッシュ化 | E-21 | ○ |
| C-20 | パスワード強度検証 | E-15 | ○ |
| C-21 | データバリデーション | E-15, E-21 | ○ |
| C-22 | 型バリデーション | E-15 | ○ |
| C-23 | 文字列バリデーション | E-15 | ○ |
| C-24 | 数値範囲バリデーション | E-15 | ○ |
| C-25 | コレクションバリデーション | E-15 | ○ |
| C-26 | 日付・時刻バリデーション | E-15 | ○ |
| C-27 | ファイル・メディアバリデーション | E-15 | ○ |
| C-28 | 一意性・整合性バリデーション | E-15 | ○ |
| C-29 | フォーム作成・レンダリング | E-16, E-22 | ○ |
| C-30 | フォームデータ処理 | E-16, E-21 | ○ |
| C-31 | 多様なフォーム型 | E-16 | ○ |
| C-32 | ワークフロー定義 | E-08, E-09 | ○ |
| C-33 | 状態遷移実行 | E-08 | ○ |
| C-34 | ガード条件評価 | E-08 | ○ |
| C-35 | ワークフローイベント通知 | E-08 | ○ |
| C-36 | メッセージ送受信 | E-10 | ○ |
| C-37 | 非同期メッセージ処理 | E-10, E-11 | ○ |
| C-38 | メッセージリトライ | E-11, E-21 | ○ |
| C-39 | タスクスケジューリング | E-14 | ○ |
| C-40 | メール作成・送信 | E-12 | ○ |
| C-41 | メール添付・マルチパート | E-21 | ○ |
| C-42 | マルチチャネル通知 | E-13 | ○ |
| C-43 | Webhook送受信 | E-21 | ○ |
| C-44 | リモートイベント処理 | E-21 | ○ |
| C-45 | オブジェクトシリアライズ | E-21 | ○ |
| C-46 | JSONストリーム処理 | E-21 | △ |
| C-47 | JSONPathクエリ | E-21 | △ |
| C-48 | プロパティアクセス | E-21 | ○ |
| C-49 | オブジェクトマッピング | E-21 | △ |
| C-50 | キャッシュ管理 | E-18, E-21 | ○ |
| C-51 | タグ付きキャッシュ | E-18, E-21 | ○ |
| C-52 | リソースロック | E-19 | ○ |
| C-53 | セマフォ制御 | E-28, E-21 | ○ |
| C-54 | レートリミット | E-20, E-21 | ○ |
| C-55 | メッセージ翻訳 | E-17 | ○ |
| C-56 | ロケールデータ提供 | E-21 | ○ |
| C-57 | 絵文字処理 | E-21 | △ |
| C-58 | テンプレートレンダリング | E-22, E-21 | ○ |
| C-59 | 汎用テンプレート表示 | E-23 | ○ |
| C-60 | 汎用リダイレクト | E-24 | ○ |
| C-61 | CLIコマンド実行 | E-21 | ○ |
| C-62 | サブプロセス実行 | E-21 | ○ |
| C-63 | 開発環境エラー表示 | E-26, E-22 | ○ |
| C-64 | 本番環境エラー表示 | E-26, E-22 | ○ |
| C-65 | エラーページプレビュー | E-26, E-22 | ○ |
| C-66 | Webプロファイラー | E-25, E-22 | ○ |
| C-67 | デバッグツールバー | E-22 | ○ |
| C-68 | 変数ダンプ | E-22, E-21 | ○ |
| C-69 | パフォーマンス計測 | E-22, E-21 | ○ |
| C-70 | Webアセット管理 | E-21 | ○ |
| C-71 | リソースヒント | E-21 | △ |
| C-72 | サービスコンテナ | E-21 | ○ |
| C-73 | アプリケーション設定 | E-21, E-22 | ○ |
| C-74 | 環境変数管理 | E-21 | ○ |
| C-75 | 式言語評価 | E-21 | ○ |
| C-76 | イベントディスパッチ | E-22, E-21 | ○ |
| C-77 | ファイル操作 | E-21 | ○ |
| C-78 | ファイル検索 | E-21 | ○ |
| C-79 | UID生成 | E-21 | △ |
| C-80 | ブラウザシミュレーション | E-21 | ○ |
| C-81 | 時刻モック | E-21 | ○ |
| C-82 | Doctrine連携 | E-21 | ○ |
| C-83 | Monolog連携 | E-22, E-21 | ○ |
| C-84 | PSR-7互換 | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-46（JSONストリーム処理）：JsonStreamerコンポーネントは比較的新しいコンポーネントであり、詳細なAPIインターフェースの確認が不十分
  - 候補：`src/Symfony/Component/JsonStreamer/` の主要クラス / README.md / テスト
- C-47（JSONPathクエリ）：JsonPathコンポーネントのRFC 9535準拠の詳細な実装確認が不足
  - 候補：`src/Symfony/Component/JsonPath/` の主要クラス / RFC 9535仕様書
- C-49（オブジェクトマッピング）：ObjectMapperコンポーネントの詳細な変換ロジック確認が不足
  - 候補：`src/Symfony/Component/ObjectMapper/` のマッパークラス / 設定定義
- C-57（絵文字処理）：Emojiコンポーネントの具体的な変換処理の詳細を未確認
  - 候補：`src/Symfony/Component/Emoji/` のメインクラス / CLDR連携部分
- C-71（リソースヒント）：WebLinkコンポーネントのHTTP/2 Server Push対応状況の詳細を未確認
  - 候補：`src/Symfony/Component/WebLink/` の主要クラス / Linkヘッダー生成ロジック
- C-79（UID生成）：UidコンポーネントのRFC 9562への準拠状況の詳細を未確認
  - 候補：`src/Symfony/Component/Uid/` の各UUIDバージョン実装

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全体の信頼度が0.93であり、大半の主張はソースコードまたは既存ドキュメントに基づく根拠がある
- 1（中リスク）：新しいコンポーネント（JsonStreamer、JsonPath、ObjectMapper、Emoji）は比較的新しく、APIの安定性や正確な仕様記述に注意が必要
- 0（低リスク）：業務要件の「アクター」列は、フレームワークの性質上「アプリケーション開発者」が中心であり、推定に基づく部分がある
- 1（中リスク）：関連画面・関連機能の紐付けは既存CSV（画面一覧57件、機能一覧68件）に基づくが、全組み合わせを網羅的に検証していない

## 6) レビュアーチェックリスト（最小）
- [ ] 全84件の業務要件が「～できること」の形式で記述されているか
- [ ] カテゴリ分類が網羅的で、重要な業務領域の漏れがないか
- [ ] 関連機能の番号と機能一覧.csvのNo列が正しく対応しているか
- [ ] 関連画面の番号と画面一覧.csvのNo列が正しく対応しているか
- [ ] 根拠なし（△）の6件について、詳細コード確認による補完が必要か判断する
- [ ] セキュリティ関連の業務要件（No.6-20）が認証・認可の要件を十分にカバーしているか
- [ ] Symfony 8.1で追加された新機能（JsonStreamer、JsonPath等）の要件が正確か
- [ ] アクターの設定が業務シナリオとして妥当か（特にエンドユーザー vs アプリケーション開発者の区分）
