---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 68
  claims_with_evidence: 67
  claims_without_evidence: 1
confidence_derived: 0.99
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：67 / 68、根拠なし：1
- 優先レビュー（高）
  1. **C-17 Runtime**：composer.jsonのreplace対象に含まれないため、コンポーネントの説明が間接的な根拠に基づく
  2. **カテゴリ分類の妥当性**：カテゴリ分類はソースコード構造から推定したものであり、公式分類が存在しない
  3. **備考欄の詳細情報**：各コンポーネントの備考欄はcomposer.jsonの依存関係とソースコード構造から推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json`（ルート） - replaceセクションによる全コンポーネント一覧
- E-02: `src/Symfony/Component/*/composer.json` - 各コンポーネントのdescription
- E-03: `src/Symfony/Bundle/*/composer.json` - 各バンドルのdescription
- E-04: `src/Symfony/Bridge/*/composer.json` - 各ブリッジのdescription
- E-05: `src/Symfony/Component/Security/*/composer.json` - Securityサブコンポーネントのdescription
- E-06: `src/Symfony/Component/` ディレクトリ構造 - コンポーネント存在確認
- E-07: `src/Symfony/Bundle/` ディレクトリ構造 - バンドル存在確認
- E-08: `src/Symfony/Bridge/` ディレクトリ構造 - ブリッジ存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpFoundation - HTTP仕様に基づくリクエスト・レスポンスのオブジェクト指向レイヤー | E-02 | ○ |
| C-02 | HttpKernel - RequestからResponseへの変換を構造的に処理するカーネル | E-02 | ○ |
| C-03 | Routing - HTTPリクエストを設定変数のセットにマッピング | E-02 | ○ |
| C-04 | HttpClient - HTTPリソースを同期・非同期で取得 | E-02 | ○ |
| C-05 | BrowserKit - Webブラウザの動作をシミュレート | E-02 | ○ |
| C-06 | DomCrawler - HTMLおよびXMLドキュメントのDOM操作 | E-02 | ○ |
| C-07 | CssSelector - CSSセレクタをXPath式に変換 | E-02 | ○ |
| C-08 | HtmlSanitizer - 信頼できないHTML入力を安全にサニタイズ | E-02 | ○ |
| C-09 | FrameworkBundle - Symfonyコンポーネントとフルスタックフレームワークの統合基盤 | E-03 | ○ |
| C-10 | DependencyInjection - オブジェクト構築方法を標準化・集約するDIコンテナ | E-02 | ○ |
| C-11 | Config - 設定値の検索、読み込み、結合、自動補完、バリデーション | E-02 | ○ |
| C-12 | EventDispatcher - イベントのディスパッチとリスニングによるコンポーネント間通信 | E-02 | ○ |
| C-13 | ErrorHandler - PHPコードのエラー管理とデバッグ | E-02 | ○ |
| C-14 | Dotenv - .envファイルから環境変数を登録 | E-02 | ○ |
| C-15 | OptionsResolver - array_replace関数の改良版 | E-02 | ○ |
| C-16 | ExpressionLanguage - 式のコンパイルと評価が可能なエンジン | E-02 | ○ |
| C-17 | Runtime - アプリケーションランタイムの抽象化 | E-01 | △ |
| C-18 | Console - コマンドラインインターフェースの作成 | E-02 | ○ |
| C-19 | Process - サブプロセスでコマンドを実行 | E-02 | ○ |
| C-20 | Security Core - 認証・認可の中核ライブラリ | E-05 | ○ |
| C-21 | Security HTTP - セキュリティコンポーネントのHTTP統合 | E-05 | ○ |
| C-22 | Security CSRF - CSRF保護ライブラリ | E-05 | ○ |
| C-23 | SecurityBundle - Securityコンポーネントとフレームワークの統合 | E-03 | ○ |
| C-24 | PasswordHasher - パスワードハッシュ化ユーティリティ | E-02 | ○ |
| C-25 | Serializer - データ構造のシリアライズ・デシリアライズ | E-02 | ○ |
| C-26 | JsonStreamer - JSONストリームからのデータ構造の読み書き | E-02 | ○ |
| C-27 | JsonPath - RFC 9535準拠のJSONPath構文によるJSON操作 | E-02 | ○ |
| C-28 | PropertyAccess - 文字列記法によるオブジェクト・配列の読み書き | E-02 | ○ |
| C-29 | PropertyInfo - PHPクラスのプロパティ情報を抽出 | E-02 | ○ |
| C-30 | TypeInfo - PHPの型情報を抽出 | E-02 | ○ |
| C-31 | ObjectMapper - オブジェクトを別のオブジェクトにマッピング | E-02 | ○ |
| C-32 | Yaml - YAMLファイルの読み込みとダンプ | E-02 | ○ |
| C-33 | Validator - 値の検証ツール | E-02 | ○ |
| C-34 | Form - HTMLフォームの作成、処理、再利用 | E-02 | ○ |
| C-35 | TwigBundle - Twigテンプレートエンジンとフレームワークの統合 | E-03 | ○ |
| C-36 | Twig Bridge - Twigと各種Symfonyコンポーネントの統合 | E-04 | ○ |
| C-37 | Messenger - メッセージキュー経由でのメッセージ送受信 | E-02 | ○ |
| C-38 | Scheduler - Symfony Messengerを活用したタスクスケジューリング | E-02 | ○ |
| C-39 | Workflow - ワークフローまたは有限状態マシンの管理 | E-02 | ○ |
| C-40 | Mailer - メール送信 | E-02 | ○ |
| C-41 | Notifier - 複数チャネルを通じた通知送信 | E-02 | ○ |
| C-42 | Mime - MIMEメッセージの操作 | E-02 | ○ |
| C-43 | Webhook - Webhookの送受信 | E-02 | ○ |
| C-44 | RemoteEvent - リモートイベントの処理 | E-02 | ○ |
| C-45 | Cache - PSR-6およびPSR-16のキャッシュ実装 | E-02 | ○ |
| C-46 | Stopwatch - コードのプロファイリング | E-02 | ○ |
| C-47 | VarExporter - PHPデータ構造をプレーンPHPコードにエクスポート | E-02 | ○ |
| C-48 | Lock - 共有リソースへの排他的アクセスを提供するロック機構 | E-02 | ○ |
| C-49 | Semaphore - セマフォによる並行制御 | E-02 | ○ |
| C-50 | RateLimiter - トークンバケットアルゴリズムによるレートリミット | E-02 | ○ |
| C-51 | Translation - アプリケーションの国際化ツール | E-02 | ○ |
| C-52 | Intl - ICUライブラリのローカライゼーションデータへのアクセス | E-02 | ○ |
| C-53 | Emoji - Unicode CLDRの絵文字データへのアクセス | E-02 | ○ |
| C-54 | String - 文字列操作のオブジェクト指向API | E-02 | ○ |
| C-55 | Uid - UIDの生成・操作のオブジェクト指向API | E-02 | ○ |
| C-56 | Filesystem - ファイルシステムの基本ユーティリティ | E-02 | ○ |
| C-57 | Finder - フルーエントインターフェースでファイル・ディレクトリを検索 | E-02 | ○ |
| C-58 | Asset - WebアセットのURL生成・バージョニング管理 | E-02 | ○ |
| C-59 | AssetMapper - ディレクトリ内アセットのマッピングとバージョン付き公開 | E-02 | ○ |
| C-60 | WebLink - リソース間のリンク管理 | E-02 | ○ |
| C-61 | VarDumper - 任意のPHP変数を走査・ダンプ | E-02 | ○ |
| C-62 | DebugBundle - VarDumperとMonologBridgeのフレームワーク統合 | E-03 | ○ |
| C-63 | WebProfilerBundle - リクエスト実行の詳細情報を表示する開発ツール | E-03 | ○ |
| C-64 | Ldap - PHP ldap拡張上でLDAPクライアント機能 | E-02 | ○ |
| C-65 | Doctrine Bridge - DoctrineとSymfonyコンポーネントの統合 | E-04 | ○ |
| C-66 | Monolog Bridge - MonologとSymfonyコンポーネントの統合 | E-04 | ○ |
| C-67 | PsrHttpMessage Bridge - PSR-7 HTTPメッセージとHttpFoundationの相互変換 | E-04 | ○ |
| C-68 | Clock - アプリケーションをシステムクロックから分離 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17（Runtime）：`src/Symfony/Component/Runtime`ディレクトリにcomposer.jsonが独立パッケージとして存在するが、ルートcomposer.jsonのreplaceセクションには含まれていない。repositoriesセクションにpathリポジトリとして定義されている。説明文は一般的なランタイム抽象化の説明として記載しており、composer.jsonのdescriptionを直接取得できなかったため根拠不足とした。
  - 候補：`src/Symfony/Component/Runtime/composer.json` / `src/Symfony/Component/Runtime/README.md`
- カテゴリ分類：Symfony公式のコンポーネントカテゴリ分類は明示的に定義されていないため、ソースコード構造と機能的類似性に基づいて分類した。
  - 候補：Symfony公式ドキュメント / README.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各コンポーネントの存在確認と説明文の整合性（composer.jsonのdescriptionと一致）
- 0: 低リスク - 全68コンポーネントの網羅性（composer.jsonのreplaceセクションおよびディレクトリ構造と照合済み）
- 1: 中リスク - カテゴリ分類の妥当性（公式分類が存在しないため、レビュアーの判断が必要）
- 0: 低リスク - 備考欄の内容（主要な特徴を補足しているが、網羅性は保証しない）

## 6) レビュアーチェックリスト（最小）
- [ ] 68件のコンポーネント/バンドル/ブリッジが全て網羅されているか確認
- [ ] カテゴリ分類がプロジェクトの利用実態に合っているか確認
- [ ] Runtime（C-17）の説明が正確か、実際のソースコードと照合
- [ ] 備考欄の技術的詳細が各コンポーネントの実装と整合しているか確認
- [ ] Securityサブコンポーネント（Core、HTTP、CSRF）の分割粒度が適切か確認
