# 機能設計書 17-Runtime

## 概要

本ドキュメントは、Symfony Runtimeコンポーネントの機能設計を記述する。Runtimeは、アプリケーションランタイムの抽象化を提供し、PHP-FPM、CLI、Swoole等の異なるランタイム環境に対応する。

### 本機能の処理概要

**業務上の目的・背景**：PHPアプリケーションは、PHP-FPM、CLI、Swoole/RoadRunnerなどの非同期サーバー等、様々なランタイム環境で実行される。Runtimeコンポーネントは、アプリケーションコードとランタイム環境の間に抽象化層を設け、同一のアプリケーションコードを異なるランタイム環境で変更なく実行可能にする。

**機能の利用シーン**：アプリケーションのエントリーポイント（index.php等）でRuntimeを使用してアプリケーションを起動する場面、Swoole/RoadRunner等の長寿命サーバーでの実行、CLIコマンドの実行に利用される。

**主要な処理内容**：
1. ランタイム環境の自動検出と選択
2. アプリケーションの解決（Kernelインスタンスの生成等）
3. リクエスト/入力の解決
4. ランナーの実行（リクエストの処理とレスポンスの送信）
5. Composerオートローダーとの統合（autoload_runtime.php）

**関連システム・外部連携**：FrameworkBundle（HttpKernelの起動）、Consoleコンポーネント（CLIアプリケーション起動）、Composerオートローダーと連携する。

**権限による制御**：本コンポーネントは権限制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （直接的な関連画面なし） | - | アプリケーション起動の基盤としてすべての画面に間接的に関連 |

## 機能種別

ランタイム抽象化 / アプリケーション起動

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| app | callable | Yes | アプリケーション生成クロージャ（通常はKernel生成） | callableであること |
| options | array | No | ランタイムオプション（env、debug等） | ランタイム固有 |

### 入力データソース

エントリーポイントファイル（public/index.php等）、Composerオートローダー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| exitCode | int | アプリケーション実行の終了コード |
| response | void | HTTPレスポンスの送信（PHP-FPM環境） |

### 出力先

標準出力（HTTPレスポンス、CLI出力）

## 処理フロー

### 処理シーケンス

```
1. autoload_runtime.phpの読み込み（Composerオートローダー経由）
   └─ ランタイム環境の検出とRuntimeインスタンスの生成
2. アプリケーション解決（RuntimeInterface::getResolver）
   └─ クロージャからアプリケーションインスタンスを解決
3. ランナー解決（RuntimeInterface::getRunner）
   └─ アプリケーション種別に応じたRunnerの取得
4. ランナー実行（RunnerInterface::run）
   └─ リクエストの処理とレスポンスの送信
```

### フローチャート

```mermaid
flowchart TD
    A[autoload_runtime.php] --> B[Runtime検出・生成]
    B --> C[getResolver]
    C --> D[アプリケーション解決]
    D --> E[getRunner]
    E --> F{環境種別}
    F -->|PHP-FPM| G[HttpKernelRunner]
    F -->|CLI| H[ConsoleApplicationRunner]
    F -->|Swoole等| I[カスタムRunner]
    G --> J[run]
    H --> J
    I --> J
    J --> K[終了コード返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | ランタイム自動検出 | 環境変数やSAPI情報からランタイム種別を自動判定 | autoload_runtime.php |
| BR-17-02 | アプリケーション型推論 | クロージャの戻り値型からアプリケーション種別を推論し適切なRunnerを選択 | getRunner |
| BR-17-03 | Composer統合 | autoload_runtime.phpはComposerのオートローダーextrasセクションで設定 | composer.json |

### 計算ロジック

特記すべき計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

本コンポーネントはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LogicException | 対応するランナーが見つからない | アプリケーション型の確認とランタイム設定の見直し |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は行わない。

## パフォーマンス要件

- Runtimeの初期化はアプリケーション起動時に1回のみ実行
- 長寿命サーバー環境ではリクエストごとのオーバーヘッドを最小限に抑える設計

## セキュリティ考慮事項

- debug環境変数に基づくモード切替により、本番環境での情報漏洩を防止
- 環境変数の検証を通じた安全なランタイム初期化

## 備考

- Runtimeコンポーネントのソースコードは本プロジェクトのソースツリーには含まれていない。composer.jsonの依存関係として参照される
- GenericRuntimeが標準実装として提供され、SymfonyRuntime（FrameworkBundle）が拡張実装を提供する
- composer.jsonの"extra"セクションでランタイム設定をカスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Runtimeコンポーネントのソースコードは本プロジェクトのソースツリーには直接含まれていないため、インターフェースと参照ポイントを示す。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | composer.json | `composer.json` | symfony/runtimeへの依存関係定義 |

**読解のコツ**: Runtimeコンポーネントは`symfony/runtime`パッケージとして提供される。RuntimeInterface（getResolver、getRunner）とRunnerInterface（run）の2つのインターフェースが中核。アプリケーションのエントリーポイントでautoload_runtime.phpを読み込むことで透過的に動作する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.php | `public/index.php`（存在する場合） | アプリケーションのエントリーポイント。Runtime連携の起点 |

### プログラム呼び出し階層図

```
autoload_runtime.php（Composerオートローダー統合）
    │
    ├─ RuntimeInterface::getResolver()
    │      └─ ResolverInterface::resolve()
    │             └─ Application/Kernel インスタンス生成
    │
    └─ RuntimeInterface::getRunner()
           └─ RunnerInterface::run()
                  ├─ HttpKernelRunner（PHP-FPM）
                  └─ ConsoleApplicationRunner（CLI）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

エントリーポイント   ───▶ Runtime::getResolver()       ───▶ Application
(index.php)                │
                           ▼
                    Runtime::getRunner()               ───▶ Runner
                           │
                           ▼
                    Runner::run()                      ───▶ Response / ExitCode
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| composer.json | `composer.json` | 設定 | symfony/runtime依存定義 |
