# 機能設計書 18-Console

## 概要

本ドキュメントは、Symfony Consoleコンポーネントの機能設計を記述する。Consoleは、美しくテスト可能なコマンドラインインターフェースの作成を容易にする機能を提供し、コマンド定義、入出力処理、プログレスバー、テーブル表示等を含む。

### 本機能の処理概要

**業務上の目的・背景**：Webアプリケーションにおいて、バッチ処理、データマイグレーション、キャッシュクリア、デバッグ支援等のCLIタスクは不可欠である。Consoleコンポーネントは、コマンドの定義から入出力処理、エラーハンドリング、シグナル制御まで、CLIアプリケーション開発に必要な機能を包括的に提供する。

**機能の利用シーン**：bin/consoleによるSymfonyコンソールコマンドの実行、カスタムコマンドの定義と実行、バッチ処理の実装、開発ツールの提供に利用される。

**主要な処理内容**：
1. コマンドの定義と登録（Command、AsCommandアトリビュート）
2. 入力解析（InputDefinition、ArgvInput、InputArgument、InputOption）
3. 出力制御（ConsoleOutput、OutputInterface、SymfonyStyle）
4. アプリケーション実行ループ（Application::run、doRun）
5. イベントディスパッチ（ConsoleEvents：COMMAND、TERMINATE、ERROR、SIGNAL）
6. シグナル処理（SignalRegistry、SIGINT/SIGTERM等）
7. コマンド補完（Completion、シェル補完スクリプト生成）
8. コマンドの遅延ロード（CommandLoaderInterface、LazyCommand）
9. ヘルパー機能（QuestionHelper、ProgressBar、Table等）

**関連システム・外部連携**：EventDispatcher（コンソールイベント）、DependencyInjection（サービスとしてのコマンド登録）、FrameworkBundle（コンソールアプリケーション統合）、ErrorHandler（エラーハンドリング統合）と連携する。

**権限による制御**：コマンド自体に権限制御は組み込まれていないが、アプリケーションレベルでイベントリスナーを通じた制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | コマンドパネル | 主機能 | Consoleコンポーネントで実行されたコマンドの入出力・実行結果の表示 |

## 機能種別

CLIアプリケーション基盤 / コマンド実行 / 入出力処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | InputInterface | No | コマンドライン入力（デフォルト: ArgvInput） | InputDefinitionに基づく検証 |
| output | OutputInterface | No | 出力先（デフォルト: ConsoleOutput） | - |
| command name | string | Yes | 実行するコマンド名 | 登録済みコマンドであること |
| arguments | array | No | コマンド引数 | InputDefinitionで定義された引数 |
| options | array | No | コマンドオプション | InputDefinitionで定義されたオプション |

### 入力データソース

コマンドライン引数（$_SERVER['argv']）、標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| exitCode | int | 終了コード（0=成功、1=失敗、2=不正入力） |
| stdout | string | 標準出力への出力内容 |
| stderr | string | 標準エラー出力への出力内容 |

### 出力先

標準出力（stdout）、標準エラー出力（stderr）

## 処理フロー

### 処理シーケンス

```
1. Application::run() 呼び出し
   └─ InputInterface/OutputInterfaceの生成（未指定時）
2. コマンド名解決
   └─ 入力からコマンド名を抽出、コマンド検索
3. コマンド入力定義のマージ
   └─ アプリケーション定義 + コマンド定義のマージ
4. ConsoleEvents::COMMAND ディスパッチ
   └─ コマンド実行前イベント（キャンセル可能）
5. コマンド実行（Command::execute / InvokableCommand）
   └─ コマンドロジックの実行
6. ConsoleEvents::TERMINATE ディスパッチ
   └─ コマンド実行後イベント（終了コード変更可能）
7. 終了コード返却
   └─ autoExit有効時はexit()を呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[Application::run] --> B[Input/Output生成]
    B --> C[コマンド名解決]
    C --> D{コマンド存在?}
    D -->|No| E[CommandNotFoundException]
    D -->|Yes| F[入力定義マージ・検証]
    F --> G[COMMAND イベント]
    G --> H{キャンセル?}
    H -->|Yes| I[TERMINATE イベント]
    H -->|No| J{catchExceptions?}
    J --> K[Command::execute]
    K --> L{例外発生?}
    L -->|Yes| M[ERROR イベント]
    M --> N[エラー出力]
    L -->|No| I
    I --> O{autoExit?}
    O -->|Yes| P[exit(code)]
    O -->|No| Q[終了コード返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | 終了コード | SUCCESS=0、FAILURE=1、INVALID=2の3つの標準終了コード | Command実行時 |
| BR-18-02 | イベント駆動 | COMMAND/TERMINATE/ERROR/SIGNALの4種のコンソールイベントをディスパッチ | EventDispatcher設定時 |
| BR-18-03 | 遅延ロード | CommandLoaderInterfaceによりコマンドの遅延インスタンス化が可能 | サービスコンテナ統合時 |
| BR-18-04 | シグナル処理 | SIGINT/SIGTERM等のPOSIXシグナルをSignalRegistryで管理 | pcntl拡張有効時 |
| BR-18-05 | 自動終了 | autoExit=trueの場合、run()完了後にexit()を呼び出す | Application::run |

### 計算ロジック

コマンド名の曖昧検索: コマンド名の部分一致で候補を検索し、一意に特定できない場合はCommandNotFoundExceptionで候補リストを提示する。

## データベース操作仕様

### 操作別データベース影響一覧

本コンポーネント自体はデータベース操作を行わない。個別のコマンド実装がデータベースを操作する場合がある。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CommandNotFoundException | 指定コマンド名が未登録 | コマンド名の確認、list コマンドで一覧表示 |
| - | RuntimeException | 入力引数/オプションの検証エラー | InputDefinitionに従った入力に修正 |
| - | LogicException | コマンド名未設定 | コマンドクラスにname設定またはAsCommandアトリビュート付与 |
| 1 | FAILURE | コマンド実行中のエラー | コマンド実装のデバッグ |
| 2 | INVALID | 不正な入力 | 入力パラメータの修正 |

### リトライ仕様

リトライは行わない。ConsoleEvents::ERRORイベントリスナーでエラー処理をカスタマイズ可能。

## トランザクション仕様

本コンポーネント自体はトランザクション管理を行わない。

## パフォーマンス要件

- CommandLoaderInterfaceによる遅延ロードで、未使用コマンドのインスタンス化を回避
- LazyCommandラッパーにより、コマンドの説明取得時にフル初期化を遅延

## セキュリティ考慮事項

- コマンドライン引数は信頼された入力として扱われるが、外部入力を受ける場合はバリデーションが必要
- プロセスの環境変数にアクセス可能なため、機密情報の出力に注意

## 備考

- SingleCommandApplicationクラスにより、単一コマンドアプリケーションを簡潔に構築可能
- SymfonyStyleクラスにより、統一されたCLI出力スタイルを適用可能
- DataCollectorにより、WebProfilerBundleでのコマンド実行情報の収集が可能
- Messenger名前空間にConsumeMessagesCommandやFailedMessagesCommandが含まれる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InputDefinition.php | `src/Symfony/Component/Console/Input/InputDefinition.php` | コマンドの入力定義（引数とオプションの集合） |
| 1-2 | InputArgument.php | `src/Symfony/Component/Console/Input/InputArgument.php` | コマンド引数の定義（名前、モード、デフォルト値） |
| 1-3 | InputOption.php | `src/Symfony/Component/Console/Input/InputOption.php` | コマンドオプションの定義（名前、ショートカット、モード） |
| 1-4 | ConsoleEvents.php | `src/Symfony/Component/Console/ConsoleEvents.php` | コンソールイベント定数（COMMAND、TERMINATE、ERROR、SIGNAL） |

**読解のコツ**: Consoleコンポーネントは、Application（コマンドコンテナ）→ Command（個別コマンド）→ Input/Output（入出力）の3層構造。InputDefinitionがコマンドの引数/オプション仕様を定義し、InputInterfaceが実際の値を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Application.php | `src/Symfony/Component/Console/Application.php` | CLIアプリケーションのメインクラス。run()がエントリーポイント |

**主要処理フロー**:
1. **74-100行目**: コンストラクタ。Terminal初期化、デフォルトコマンド設定
2. Application::run(): Input/Output生成、configureIO、doRun呼び出し、autoExit処理
3. Application::doRun(): コマンド名解決、find()でコマンド検索、doRunCommand()呼び出し
4. Application::doRunCommand(): イベントディスパッチ、Command::run()呼び出し

#### Step 3: コマンド定義と実行

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Command.php | `src/Symfony/Component/Console/Command/Command.php` | コマンド基底クラス。configure、execute、run メソッド |
| 3-2 | AsCommand.php | `src/Symfony/Component/Console/Attribute/AsCommand.php` | コマンド定義アトリビュート |

**主要処理フロー**:
- **36-55行目（Command）**: 定数（SUCCESS/FAILURE/INVALID）、プロパティ定義
- **62-80行目（Command）**: コンストラクタ。AsCommandアトリビュートからの名前・エイリアス解決

#### Step 4: 入出力処理

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ArgvInput.php | `src/Symfony/Component/Console/Input/ArgvInput.php` | コマンドライン引数のパーサー |
| 4-2 | ConsoleOutput.php | `src/Symfony/Component/Console/Output/ConsoleOutput.php` | stdout/stderr出力管理 |
| 4-3 | SymfonyStyle.php | `src/Symfony/Component/Console/Style/SymfonyStyle.php` | 統一スタイル出力ヘルパー |

### プログラム呼び出し階層図

```
Application::run()
    │
    ├─ new ArgvInput() / new ConsoleOutput()
    ├─ configureIO()
    │
    └─ doRun()
           ├─ find()（コマンド名解決）
           │      └─ CommandLoaderInterface::get()（遅延ロード）
           │
           └─ doRunCommand()
                  ├─ dispatch(ConsoleEvents::COMMAND)
                  ├─ Command::run()
                  │      ├─ initialize()
                  │      ├─ interact()
                  │      └─ execute()
                  ├─ dispatch(ConsoleEvents::ERROR)（例外時）
                  └─ dispatch(ConsoleEvents::TERMINATE)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数   ───▶ ArgvInput（引数パース）      ───▶ InputInterface
$_SERVER['argv']           │
                           ▼
                    Application::run()
                           │
                           ├─ コマンド検索・解決
                           ├─ イベントディスパッチ
                           └─ Command::execute()       ───▶ ConsoleOutput
                                                              │
                                                              ├─ stdout
                                                              └─ stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Application.php | `src/Symfony/Component/Console/Application.php` | ソース | CLIアプリケーション本体 |
| Command.php | `src/Symfony/Component/Console/Command/Command.php` | ソース | コマンド基底クラス |
| AsCommand.php | `src/Symfony/Component/Console/Attribute/AsCommand.php` | ソース | コマンドアトリビュート |
| InputDefinition.php | `src/Symfony/Component/Console/Input/InputDefinition.php` | ソース | 入力定義 |
| ArgvInput.php | `src/Symfony/Component/Console/Input/ArgvInput.php` | ソース | コマンドライン引数パーサー |
| ConsoleOutput.php | `src/Symfony/Component/Console/Output/ConsoleOutput.php` | ソース | 標準出力管理 |
| SymfonyStyle.php | `src/Symfony/Component/Console/Style/SymfonyStyle.php` | ソース | 統一スタイル出力 |
| ConsoleEvents.php | `src/Symfony/Component/Console/ConsoleEvents.php` | ソース | イベント定数 |
| SignalRegistry/ | `src/Symfony/Component/Console/SignalRegistry/` | ソース | シグナルレジストリ |
| Completion/ | `src/Symfony/Component/Console/Completion/` | ソース | シェル補完 |
| Helper/ | `src/Symfony/Component/Console/Helper/` | ソース | ヘルパー（ProgressBar、Table等） |
| Tester/ | `src/Symfony/Component/Console/Tester/` | ソース | テスト用ユーティリティ |
| Terminal.php | `src/Symfony/Component/Console/Terminal.php` | ソース | ターミナルサイズ取得 |
