# 機能設計書 2-HttpKernel

## 概要

本ドキュメントは、Symfony HttpKernelコンポーネントの機能設計を記述する。HttpKernelはRequestオブジェクトからResponseオブジェクトへの変換を構造的に処理するカーネルを提供し、イベント駆動のリクエスト処理パイプラインを実現する。

### 本機能の処理概要

HttpKernelコンポーネントは、Symfonyフレームワークのリクエスト処理パイプラインの中核を担う。HTTPリクエストを受け取り、イベントディスパッチャーを通じた各種リスナーの介入ポイントを提供しながら、コントローラーの解決・実行・レスポンス生成までの一連の処理を統合的に管理する。

**業務上の目的・背景**：Webアプリケーションにおいてリクエストからレスポンスへの変換は最も基本的な処理であるが、認証、ルーティング、エラーハンドリング、プロファイリングなど多数の横断的関心事が介在する。HttpKernelはイベント駆動アーキテクチャにより、これらの関心事を疎結合に統合し、拡張性の高いリクエスト処理パイプラインを実現する。

**機能の利用シーン**：すべてのHTTPリクエスト処理で利用される。アプリケーションのブートストラップから始まり、リクエストの受信、ルーティング、コントローラー実行、レスポンス生成、レスポンス後処理（terminate）までの全ライフサイクルを管理する。

**主要な処理内容**：
1. リクエスト処理パイプライン（kernel.request -> controller解決 -> kernel.controller -> kernel.controller_arguments -> コントローラー実行 -> kernel.view -> kernel.response -> kernel.finish_request）
2. コントローラー解決（ControllerResolverInterface）
3. 引数解決（ArgumentResolverInterface）
4. 例外処理（kernel.exceptionイベント）
5. リクエスト後処理（kernel.terminateイベント）
6. サブリクエスト処理（MAIN_REQUEST / SUB_REQUEST）
7. プロファイリングとデータ収集
8. キャッシュ管理（HttpCache）
9. バンドルシステム管理（Kernel基底クラス）

**関連システム・外部連携**：EventDispatcher（イベント駆動）、HttpFoundation（Request/Response）、Routing（コントローラー解決）、DependencyInjection（サービスコンテナ）、ErrorHandler（例外処理）

**権限による制御**：HttpKernel自体には権限制御はないが、kernel.requestイベントリスナーとしてSecurityコンポーネントのファイアウォールが動作し、認証・認可を実行する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プロファイラーパネル | 主機能 | Profilerサービスによるプロファイルデータの読み込みとDataCollectorの取得 |
| 3 | プロファイラー検索 | 補助機能 | Profilerサービスによる検索条件に合致するプロファイルトークンの検索 |
| 5 | プロファイラー検索結果 | 主機能 | Profilerサービスによるプロファイルデータの検索・読み込み |
| 12 | Webデバッグツールバー | 主機能 | Profilerサービスによるプロファイルデータの読み込みとDataCollector情報の取得 |
| 14 | リクエスト情報パネル | 主機能 | RequestDataCollectorによるHTTPリクエスト/レスポンス情報の収集・表示 |
| 15 | 例外情報パネル | 補助機能 | ExceptionDataCollectorによる例外情報の収集 |
| 16 | パフォーマンス（時間）パネル | 補助機能 | TimeDataCollectorによるパフォーマンスデータの収集 |
| 17 | メモリ使用量パネル | 補助機能 | MemoryDataCollectorによるメモリ使用量データの収集 |
| 18 | ログパネル | 補助機能 | LoggerDataCollectorによるログデータの収集 |
| 19 | イベントパネル | 補助機能 | EventDataCollectorによるイベントデータの収集 |
| 21 | ルーター詳細パネル | 補助機能 | Profilerサービスによるプロファイルデータの読み込み |
| 38 | 例外詳細画面（開発環境） | 補助機能 | ErrorControllerおよびErrorListenerによるエラー処理パイプライン |
| 39 | エラー画面（本番環境） | 補助機能 | ErrorControllerおよびErrorListenerによるエラー処理パイプライン |
| 40 | エラープレビュー | 主機能 | ErrorController::previewによるサブリクエストを使用したエラーページプレビュー |

## 機能種別

フレームワーク基盤 / リクエスト処理パイプライン / イベント駆動アーキテクチャ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| request | Request | Yes | HttpFoundation Requestオブジェクト | RequestExceptionInterfaceでのバリデーション |
| type | int | No | リクエスト種別（MAIN_REQUEST=1 / SUB_REQUEST=2） | 定数値のみ |
| catch | bool | No | 例外をキャッチするか（デフォルト: true） | - |

### 入力データソース

- HttpFoundation Requestオブジェクト（Request::createFromGlobals()等で生成）
- サービスコンテナから注入されるControllerResolver、ArgumentResolver、EventDispatcher

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| response | Response | HTTPレスポンスオブジェクト |

### 出力先

- HttpFoundation Responseオブジェクトとして返却
- Response::send()によるクライアントへの出力はHttpKernelの管轄外

## 処理フロー

### 処理シーケンス

```
1. handle()メソッド呼び出し
   └─ RequestStackにリクエストをプッシュ
2. handleRaw()でリクエスト処理開始
   └─ kernel.requestイベントをディスパッチ
3. コントローラー解決
   └─ ControllerResolver::getController()でコントローラーを特定
4. kernel.controllerイベントをディスパッチ
   └─ コントローラーの変更機会を提供
5. 引数解決
   └─ ArgumentResolver::getArguments()でコントローラー引数を解決
6. kernel.controller_argumentsイベントをディスパッチ
   └─ 引数の変更機会を提供
7. コントローラー実行
   └─ $controller(...$arguments)
8. レスポンスの確認
   └─ Responseでない場合はkernel.viewイベントをディスパッチ
9. kernel.responseイベントをディスパッチ
   └─ レスポンスの後処理
10. kernel.finish_requestイベントをディスパッチ
    └─ グローバル状態のリセット
11. RequestStackからリクエストをポップ
```

### フローチャート

```mermaid
flowchart TD
    A[handle] --> B[RequestStackにpush]
    B --> C[kernel.request]
    C --> D{レスポンスあり?}
    D -->|Yes| K[filterResponse]
    D -->|No| E[ControllerResolver]
    E --> F[kernel.controller]
    F --> G[ArgumentResolver]
    G --> H[kernel.controller_arguments]
    H --> I[コントローラー実行]
    I --> J{Response?}
    J -->|Yes| K
    J -->|No| L[kernel.view]
    L --> K
    K --> M[kernel.response]
    M --> N[kernel.finish_request]
    N --> O[RequestStackからpop]
    O --> P[Response返却]

    C -->|例外発生| Q[handleThrowable]
    E -->|例外発生| Q
    I -->|例外発生| Q
    Q --> R[kernel.exception]
    R --> S{レスポンスあり?}
    S -->|Yes| K
    S -->|No| T[例外を再スロー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | イベント順序保証 | カーネルイベントは必ずREQUEST -> CONTROLLER -> CONTROLLER_ARGUMENTS -> (VIEW) -> RESPONSE -> FINISH_REQUESTの順序で発行される | 正常フロー時 |
| BR-02 | 早期レスポンス | kernel.requestリスナーがレスポンスを設定した場合、コントローラーは実行されない | RequestEventでsetResponse()が呼ばれた場合 |
| BR-03 | 例外フォールバック | kernel.exceptionリスナーがレスポンスを生成できない場合、例外が再スローされる | catch=true時 |
| BR-04 | サブリクエスト分離 | サブリクエスト（SUB_REQUEST）はメインリクエストと独立したイベントサイクルを持つ | type=SUB_REQUEST時 |
| BR-05 | StreamedResponse遅延実行 | StreamedResponseのコールバックはRequestStack復元後に実行される | StreamedResponse返却時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

HttpKernelコンポーネント自体はデータベース操作を行わない。Profilerがプロファイルデータを保存する際にファイルシステムまたはDB（設定次第）にアクセスするが、これはProfiler内部の責務である。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFoundHttpException | コントローラーが見つからない | ルーティング設定の見直し |
| 400 | BadRequestHttpException | RequestExceptionInterfaceの例外をラップ | リクエスト形式の確認 |
| - | ControllerDoesNotReturnResponseException | コントローラーがResponseを返さずkernel.viewリスナーも処理しない | コントローラーの戻り値確認 |
| - | \Error | handleAllThrowables=falseの場合、Errorは再スローされる | handleAllThrowablesの設定確認 |

### リトライ仕様

HttpKernelはリトライ機能を持たない。

## トランザクション仕様

HttpKernelはトランザクション管理を行わない。

## パフォーマンス要件

- イベントディスパッチのオーバーヘッドは最小限に設計されている
- RequestStackによるリクエスト管理はスタック構造で高速
- Profilerが有効な場合、DataCollectorによるデータ収集が追加オーバーヘッドとなる

## セキュリティ考慮事項

- kernel.requestイベントにおいてSecurityコンポーネントのファイアウォールが認証・認可を実行
- handleAllThrowablesオプションにより、\Errorレベルの例外もキャッチ可能（デフォルトはfalse）
- サブリクエスト実行時も適切なセキュリティコンテキストが維持される

## 備考

- Symfony 8.1-DEV、バージョンID: 80100
- Kernel基底クラスはバンドルシステム、DIコンテナのビルド・ブートを統合管理する
- END_OF_MAINTENANCE: 01/2027、END_OF_LIFE: 01/2027

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カーネルイベントの種類と構造を理解することが出発点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | KernelEvents.php | `src/Symfony/Component/HttpKernel/KernelEvents.php` | 全カーネルイベント定数（REQUEST, CONTROLLER, VIEW, RESPONSE等）の定義 |
| 1-2 | HttpKernelInterface.php | `src/Symfony/Component/HttpKernel/HttpKernelInterface.php` | handle()メソッドのインターフェース、MAIN_REQUEST/SUB_REQUEST定数 |

**読解のコツ**: KernelEventsクラスの定数名がそのままイベント名（'kernel.request'等）に対応している。ALIASESプロパティ（行118-127）でイベントクラスからイベント名への逆引きが可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HttpKernel.php | `src/Symfony/Component/HttpKernel/HttpKernel.php` | リクエスト処理パイプラインの中核 |

**主要処理フロー**:
1. **61-69行目**: コンストラクタ。EventDispatcher、ControllerResolver、RequestStack、ArgumentResolverの注入
2. **72-110行目**: handle()メソッド。RequestStackへのpush/pop、handleRaw()呼び出し、例外キャッチ
3. **158-199行目**: handleRaw()メソッド。kernel.request -> コントローラー解決 -> kernel.controller -> 引数解決 -> kernel.controller_arguments -> コントローラー実行 -> kernel.view

#### Step 3: カーネル基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Kernel.php | `src/Symfony/Component/HttpKernel/Kernel.php` | バンドルシステム、DIコンテナのビルド・ブートを統合管理 |

**主要処理フロー**:
- **75-83行目**: バージョン定数（VERSION='8.1.0-DEV'）とEOL/EOM情報
- **85-92行目**: コンストラクタ。environment/debug設定の注入

### プログラム呼び出し階層図

```
HttpKernel::handle(Request, type, catch)
    |
    +-- RequestStack::push(Request)
    |
    +-- HttpKernel::handleRaw(Request, type)
    |       |
    |       +-- EventDispatcher::dispatch(RequestEvent, 'kernel.request')
    |       |
    |       +-- ControllerResolver::getController(Request)
    |       |
    |       +-- EventDispatcher::dispatch(ControllerEvent, 'kernel.controller')
    |       |
    |       +-- ArgumentResolver::getArguments(Request, controller)
    |       |
    |       +-- EventDispatcher::dispatch(ControllerArgumentsEvent, 'kernel.controller_arguments')
    |       |
    |       +-- $controller(...$arguments)
    |       |
    |       +-- [Response以外の場合] EventDispatcher::dispatch(ViewEvent, 'kernel.view')
    |       |
    |       +-- HttpKernel::filterResponse(Response, Request, type)
    |               |
    |               +-- EventDispatcher::dispatch(ResponseEvent, 'kernel.response')
    |               +-- EventDispatcher::dispatch(FinishRequestEvent, 'kernel.finish_request')
    |
    +-- [例外発生時] HttpKernel::handleThrowable(exception, Request, type)
    |       |
    |       +-- EventDispatcher::dispatch(ExceptionEvent, 'kernel.exception')
    |
    +-- RequestStack::pop()

HttpKernel::terminate(Request, Response)
    |
    +-- EventDispatcher::dispatch(TerminateEvent, 'kernel.terminate')
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Request オブジェクト  ----->  kernel.request                ----> (早期レスポンス可能)
                              |
                              v
                     ControllerResolver           ----> Controller callable
                              |
                              v
                     ArgumentResolver             ----> Controller arguments
                              |
                              v
                     Controller実行               ----> Response/mixed
                              |
                              v
                     [mixedの場合] kernel.view     ----> Response
                              |
                              v
                     kernel.response              ----> 最終Response
                              |
                              v
                     kernel.finish_request         ----> (状態リセット)
                              |
                              v
                     kernel.terminate              ----> (後処理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HttpKernel.php | `src/Symfony/Component/HttpKernel/HttpKernel.php` | ソース | リクエスト処理パイプラインの中核 |
| HttpKernelInterface.php | `src/Symfony/Component/HttpKernel/HttpKernelInterface.php` | ソース | カーネルインターフェース定義 |
| Kernel.php | `src/Symfony/Component/HttpKernel/Kernel.php` | ソース | バンドル管理・コンテナビルドの基底クラス |
| KernelInterface.php | `src/Symfony/Component/HttpKernel/KernelInterface.php` | ソース | Kernelインターフェース定義 |
| KernelEvents.php | `src/Symfony/Component/HttpKernel/KernelEvents.php` | ソース | カーネルイベント定数定義 |
| TerminableInterface.php | `src/Symfony/Component/HttpKernel/TerminableInterface.php` | ソース | terminate()メソッドインターフェース |
| HttpKernelBrowser.php | `src/Symfony/Component/HttpKernel/HttpKernelBrowser.php` | ソース | テスト用ブラウザクライアント |
| HttpClientKernel.php | `src/Symfony/Component/HttpKernel/HttpClientKernel.php` | ソース | HttpClientをKernelとして利用するアダプター |
| Controller/ | `src/Symfony/Component/HttpKernel/Controller/` | ソース | コントローラー解決・引数解決 |
| Event/ | `src/Symfony/Component/HttpKernel/Event/` | ソース | カーネルイベントクラス群 |
| EventListener/ | `src/Symfony/Component/HttpKernel/EventListener/` | ソース | 標準イベントリスナー群 |
| Exception/ | `src/Symfony/Component/HttpKernel/Exception/` | ソース | HTTP例外クラス群 |
| Fragment/ | `src/Symfony/Component/HttpKernel/Fragment/` | ソース | フラグメントレンダリング |
| Profiler/ | `src/Symfony/Component/HttpKernel/Profiler/` | ソース | プロファイリング機能 |
| DataCollector/ | `src/Symfony/Component/HttpKernel/DataCollector/` | ソース | データコレクター群 |
| HttpCache/ | `src/Symfony/Component/HttpKernel/HttpCache/` | ソース | HTTPキャッシュプロキシ |
| DependencyInjection/ | `src/Symfony/Component/HttpKernel/DependencyInjection/` | ソース | DI統合コンパイラパス |
| Debug/ | `src/Symfony/Component/HttpKernel/Debug/` | ソース | デバッグ用ユーティリティ |
| CacheClearer/ | `src/Symfony/Component/HttpKernel/CacheClearer/` | ソース | キャッシュクリア |
| CacheWarmer/ | `src/Symfony/Component/HttpKernel/CacheWarmer/` | ソース | キャッシュウォームアップ |
