# 機能設計書 35-TwigBundle

## 概要

本ドキュメントは、Symfony TwigBundleの機能設計を記述する。TwigBundleは、TwigテンプレートエンジンとSymfonyフルスタックフレームワークの統合を提供するバンドルである。

### 本機能の処理概要

TwigBundleは、Twigテンプレートエンジンをサービスコンテナに登録し、テンプレートの読み込みパス設定、キャッシュ管理、拡張機能の自動登録、コンパイラパスによるサービス統合など、TwigをSymfonyアプリケーション内で利用するための全ての設定と統合を行う。

**業務上の目的・背景**：SymfonyアプリケーションでHTMLレスポンスを生成する際、Twigテンプレートエンジンはデファクトスタンダードのテンプレートソリューションである。TwigBundleは、Twig環境の初期化、テンプレートパスの解決、フォーム/アセット/ルーティング等の拡張機能統合を自動化し、開発者がテンプレート記述に集中できる環境を提供する。

**機能の利用シーン**：コントローラーからのテンプレートレンダリング、メールテンプレートの生成、PDFテンプレートの生成、エラーページのカスタマイズ、フォームテーマのカスタマイズなど、Twigテンプレートを使用する全ての場面で使用される。

**主要な処理内容**：
1. Twig Environmentサービスの登録と設定（debug, charset, strict_variables, autoescape, cache, auto_reload等）
2. テンプレートファイルシステムローダーの設定（パス、名前空間）
3. バンドルテンプレートパスの自動解決（Resources/views, templates）
4. フォームテーマの設定（form_themes設定パラメータ）
5. コンパイラパスによるTwig拡張の自動登録（ExtensionPass, TwigEnvironmentPass等）
6. テンプレートキャッシュの管理（ウォームアップ含む）
7. Twig拡張・ランタイム・ローダーの自動タグ付け（autoconfigure）
8. PHP 8アトリビュートによるTwigフィルター/関数/テストの登録（AsTwigFilter, AsTwigFunction, AsTwigTest）
9. テンプレートリント機能（twig:lint コマンド）
10. グローバル変数の登録

**関連システム・外部連携**：Twig Bridge（Symfonyコンポーネント連携拡張）、Formコンポーネント（フォームテーマ）、Mailerコンポーネント（メールテンプレート）、AssetMapperコンポーネント（importmap統合）、Translationコンポーネント（翻訳メッセージ抽出）、Validatorコンポーネント（バリデーション統合）と連携する。

**権限による制御**：テンプレートの表示制御は、Twigのセキュリティ拡張（`is_granted()`等）を通じて行う。TwigBundle自体には権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プロファイラーパネル | 補助機能 | Twig Environmentによるレイアウトおよびパネルテンプレートのレンダリング |
| 4 | プロファイラー検索バー | 補助機能 | search.html.twigテンプレートのレンダリング |
| 5 | プロファイラー検索結果 | 補助機能 | results.html.twigテンプレートのレンダリング |
| 6 | プロファイラー情報 | 補助機能 | info.html.twigテンプレートのレンダリング |
| 7 | ソースファイル表示 | 補助機能 | open.html.twigテンプレートのレンダリング |
| 10 | プロファイラー設定 | 補助機能 | settings.html.twigテンプレートのレンダリング |
| 11 | リダイレクトインターセプト | 補助機能 | toolbar_redirect.html.twigのレンダリング |
| 12 | Webデバッグツールバー | 補助機能 | toolbar.html.twigテンプレートのレンダリング |
| 13 | ツールバースタイルシート | 補助機能 | toolbar.css.twigテンプレートのレンダリング |
| 28 | Twigパネル | 補助機能 | TwigBundleで登録されたTwig設定情報の表示 |
| 41 | テンプレート表示 | 主機能 | Twig Environmentによるテンプレートのレンダリング処理 |

## 機能種別

フレームワーク統合（テンプレートエンジン統合）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| debug | bool | No | デバッグモードの有効/無効 | - |
| charset | string | No | 文字エンコーディング（デフォルト: UTF-8） | - |
| strict_variables | bool | No | 未定義変数アクセス時の厳密チェック | - |
| cache | bool\|string | No | テンプレートキャッシュの設定 | - |
| auto_reload | bool | No | テンプレート変更時の自動リロード | - |
| form_themes | string[] | No | フォームテーマテンプレートのリスト | - |
| default_path | string | No | デフォルトテンプレートパス | - |
| paths | array | No | 追加テンプレートパスと名前空間の定義 | - |
| globals | array | No | Twigグローバル変数の定義 | - |

### 入力データソース

- twig.yaml設定ファイル
- バンドルのResources/viewsまたはtemplatesディレクトリ
- FrameworkBundle/Kernelからの環境パラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| twig | Twig\Environment | 設定済みのTwig Environmentサービス |
| twig.loader.native_filesystem | Twig\Loader\FilesystemLoader | テンプレートファイルシステムローダー |

### 出力先

Symfonyサービスコンテナ（DIコンテナ内のサービスとして登録）

## 処理フロー

### 処理シーケンス

```
1. TwigExtension::load() による設定ロード
   ├─ twig.phpの読み込み（基本サービス定義）
   ├─ form.phpの読み込み（Formコンポーネント連携、条件付き）
   ├─ console.phpの読み込み（Consoleコンポーネント連携、条件付き）
   ├─ mailer.phpの読み込み（Mailerコンポーネント連携、条件付き）
   ├─ validator.phpの読み込み（Validatorコンポーネント連携、条件付き）
   └─ importmap.phpの読み込み（AssetMapper連携、条件付き）
2. 設定の処理
   ├─ Twig Environmentの設定（debug, charset等）
   ├─ テンプレートパスの設定
   ├─ バンドルテンプレートパスの解決
   ├─ フォームテーマの設定
   ├─ グローバル変数の登録
   └─ キャッシュ設定
3. コンパイラパスの実行
   ├─ ExtensionPass: 拡張サービスの統合
   ├─ AttributeExtensionPass: PHP 8アトリビュートによる拡張登録
   ├─ TwigEnvironmentPass: Environment設定の最終化
   ├─ TwigLoaderPass: テンプレートローダーの設定
   └─ RuntimeLoaderPass: ランタイム拡張のローダー設定
```

### フローチャート

```mermaid
flowchart TD
    A[TwigBundle::build] --> B[コンパイラパス登録]
    B --> C[TwigExtension::load]
    C --> D{Form利用可能?}
    D -->|Yes| E[form.php読み込み]
    D -->|No| F{Console利用可能?}
    E --> F
    F -->|Yes| G[console.php読み込み]
    F -->|No| H[設定処理]
    G --> H
    H --> I[Twig Environment設定]
    I --> J[テンプレートパス設定]
    J --> K[バンドルパス解決]
    K --> L[フォームテーマ設定]
    L --> M[グローバル変数登録]
    M --> N[キャッシュ設定]
    N --> O[autoconfigure設定]
    O --> P[コンパイラパス実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | 条件付きサービスロード | 各コンポーネント（Form, Console, Mailer等）の利用可能性に応じてサービスを読み込む | コンポーネントがインストールされている場合 |
| BR-35-02 | バンドルテンプレートパス | 各バンドルのtemplatesまたはResources/viewsディレクトリを自動的にテンプレートパスに登録する | バンドルが登録されている場合 |
| BR-35-03 | テンプレートオーバーライド | templates/bundles/{BundleName}/に配置されたテンプレートがバンドルのデフォルトテンプレートを上書きする | オーバーライドテンプレートが存在する場合 |
| BR-35-04 | キャッシュ管理 | auto_reload有効またはキャッシュディレクトリ=ビルドディレクトリの場合、kernel.cache_dir/twigにキャッシュ | cache=true設定時 |
| BR-35-05 | 自動タグ付け | ExtensionInterface, LoaderInterface, RuntimeExtensionInterfaceを実装するサービスに自動的にタグを付与 | 常時 |
| BR-35-06 | アトリビュート拡張登録 | AsTwigFilter, AsTwigFunction, AsTwigTestアトリビュートでTwig拡張を登録 | PHP 8アトリビュート使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベース操作を行わない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Twig\Error\LoaderError | テンプレートファイルが見つからない | テンプレートパスとファイル名を確認する |
| - | Twig\Error\SyntaxError | Twigテンプレートの構文エラー | テンプレートの構文を修正する |
| - | Twig\Error\RuntimeError | テンプレート実行時エラー | テンプレートのロジックを確認する |

### リトライ仕様

リトライは不要。

## トランザクション仕様

トランザクション管理は行わない。

## パフォーマンス要件

- テンプレートキャッシュにより、テンプレートのコンパイルを一度だけ行い、以降はキャッシュを使用する
- CacheWarmerによるプリコンパイルでコールドスタートを高速化する

## セキュリティ考慮事項

- autoescape設定がデフォルトで有効であり、出力時のXSS対策が自動適用される
- テンプレート内で`raw`フィルターを使用する場合は、出力内容が安全であることを確認する

## 備考

- TwigBundleはSymfonyフルスタックフレームワークの標準テンプレートバンドルである
- Twig自体はSymfonyとは独立したプロジェクトであり、TwigBundleはSymfony固有の統合レイヤーを提供する
- テンプレート名前空間はバンドル名から`Bundle`サフィックスを除いた形（例：`@Twig`）で利用できる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バンドルの設定スキーマを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Configuration.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Configuration.php` | バンドル設定のスキーマ定義 |

**読解のコツ**: Symfonyバンドルの設定スキーマはTreeBuilderパターンで定義される。各ノードの型と制約を確認する。

#### Step 2: エントリーポイントを理解する

バンドルクラスとDI拡張を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TwigBundle.php | `src/Symfony/Bundle/TwigBundle/TwigBundle.php` | バンドルクラス。コンパイラパスの登録 |
| 2-2 | TwigExtension.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/TwigExtension.php` | DI拡張。サービス登録と設定処理の中心 |

**主要処理フロー**:
1. **31-41行目** (TwigBundle.php): `build()` - 5つのコンパイラパスを登録
2. **43-205行目** (TwigExtension.php): `load()` - 設定読み込み、サービス登録、パス設定、キャッシュ設定
3. **48-62行目** (TwigExtension.php): 条件付きサービスロード（Form, Console, Mailer, Validator, AssetMapper）
4. **97-98行目** (TwigExtension.php): フォームテーマとデフォルトパスのパラメータ設定
5. **188-204行目** (TwigExtension.php): autoconfigure設定とアトリビュート拡張登録

#### Step 3: コンパイラパスを理解する

コンパイラパスによるサービス統合を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExtensionPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/ExtensionPass.php` | 拡張サービスの統合 |
| 3-2 | TwigEnvironmentPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigEnvironmentPass.php` | Twig Environment設定の最終化 |
| 3-3 | TwigLoaderPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigLoaderPass.php` | テンプレートローダーの設定 |
| 3-4 | RuntimeLoaderPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/RuntimeLoaderPass.php` | ランタイム拡張のローダー設定 |
| 3-5 | AttributeExtensionPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/AttributeExtensionPass.php` | アトリビュートベースの拡張登録 |

### プログラム呼び出し階層図

```
TwigBundle::build()
    |
    +-- ContainerBuilder::addCompilerPass() x5
            |
            +-- ExtensionPass
            +-- AttributeExtensionPass
            +-- TwigEnvironmentPass
            +-- TwigLoaderPass
            +-- RuntimeLoaderPass

TwigExtension::load()
    |
    +-- PhpFileLoader::load('twig.php')
    +-- PhpFileLoader::load('form.php') [条件付き]
    +-- PhpFileLoader::load('console.php') [条件付き]
    +-- PhpFileLoader::load('mailer.php') [条件付き]
    +-- PhpFileLoader::load('validator.php') [条件付き]
    +-- PhpFileLoader::load('importmap.php') [条件付き]
    |
    +-- Configuration処理
    +-- テンプレートパス設定
    +-- バンドルパス解決
    +-- キャッシュ設定
    +-- autoconfigure設定
```

### データフロー図

```
[入力]                        [処理]                           [出力]

twig.yaml設定 ──────> TwigExtension::load()
                           |
バンドルメタデータ ────> バンドルパス解決
                           |
                           v
                      サービスコンテナ登録
                           |
                           v
コンパイラパス ────────> サービス最終化 ──────> Twig Environment
                                                (サービスとして登録)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TwigBundle.php | `src/Symfony/Bundle/TwigBundle/TwigBundle.php` | ソース | バンドルクラス |
| TwigExtension.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/TwigExtension.php` | ソース | DI拡張 |
| Configuration.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Configuration.php` | ソース | 設定スキーマ |
| ExtensionPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/ExtensionPass.php` | ソース | 拡張統合コンパイラパス |
| AttributeExtensionPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/AttributeExtensionPass.php` | ソース | アトリビュート拡張コンパイラパス |
| TwigEnvironmentPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigEnvironmentPass.php` | ソース | Environment設定コンパイラパス |
| TwigLoaderPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigLoaderPass.php` | ソース | ローダー設定コンパイラパス |
| RuntimeLoaderPass.php | `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/RuntimeLoaderPass.php` | ソース | ランタイムローダーコンパイラパス |
| TemplateIterator.php | `src/Symfony/Bundle/TwigBundle/TemplateIterator.php` | ソース | テンプレートイテレータ |
| Resources/config/twig.php | `src/Symfony/Bundle/TwigBundle/Resources/config/twig.php` | 設定 | 基本サービス定義 |
