# 機能設計書 36-Twig Bridge

## 概要

本ドキュメントは、Symfony Twig Bridgeの機能設計を記述する。Twig Bridgeは、Twigテンプレートエンジンと各種Symfonyコンポーネントの統合機能を提供するブリッジである。

### 本機能の処理概要

Twig Bridgeは、Form、Routing、Security、Translation、Validator、HttpFoundation、HttpKernel等のSymfonyコンポーネントのTwig拡張（フィルター、関数、テスト、テンプレート）を提供する。これにより、Twigテンプレート内でSymfonyの各機能を直感的に利用できる。

**業務上の目的・背景**：Twigテンプレートエンジンは汎用的なテンプレートエンジンであり、Symfony固有の機能への直接アクセスは提供しない。Twig Bridgeは、フォームレンダリング（form_row, form_widget等）、URLジェネレーション（path, url関数）、セキュリティチェック（is_granted関数）、翻訳（transフィルター）など、Symfony開発に不可欠なTwig拡張を提供する。

**機能の利用シーン**：Twigテンプレート内でのフォーム表示、ルートURLの生成、セキュリティ権限チェック、翻訳テキストの出力、デバッグ情報のダンプ、アセットURL生成、ワークフロー状態の確認など、テンプレートからSymfonyの機能を利用する全ての場面で使用される。

**主要な処理内容**：
1. フォーム拡張（FormExtension）: form_start, form_end, form_row, form_widget, form_label, form_errors等のTwig関数
2. ルーティング拡張（RoutingExtension）: path(), url()等のTwig関数
3. セキュリティ拡張（SecurityExtension）: is_granted(), csrf_token()等のTwig関数
4. 翻訳拡張（TranslationExtension）: trans, trans_default_domainフィルター
5. HTTP関連拡張（HttpFoundationExtension, HttpKernelExtension）: absolute_url, relative_path, render, render_esi等
6. アセット拡張（AssetExtension）: asset(), asset_version()
7. ダンプ拡張（DumpExtension）: dump()関数
8. ワークフロー拡張（WorkflowExtension）: workflow_can, workflow_transitions等
9. YAML拡張（YamlExtension）: yaml_dump, yaml_encodeフィルター
10. CSRF拡張（CsrfExtension）: csrf_token()関数
11. AppVariable: テンプレート内のapp変数（request, session, user, environment, debug, flashes等）
12. メール通知テンプレート: デフォルト/Zurb 2形式のメール通知テンプレート
13. フォームテーマテンプレート: Bootstrap, Foundation, Tailwind等のフォームレイアウトテーマ

**関連システム・外部連携**：Formコンポーネント、Routingコンポーネント、Securityコンポーネント、Translationコンポーネント、HttpFoundationコンポーネント、HttpKernelコンポーネント、Assetコンポーネント、VarDumperコンポーネント、Workflowコンポーネント、Yamlコンポーネント、CSRFコンポーネント、Mimeコンポーネント、Notifierコンポーネントと連携する。

**権限による制御**：SecurityExtensionのis_granted()関数を通じて、テンプレート内での権限チェックが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | Twigパネル | 主機能 | Twig BridgeおよびTwigテンプレートエンジンのレンダリング統計の表示 |
| 43 | フォームレイアウト（div） | 主機能 | Twig Bridgeのフォームレンダリング拡張によるフォームブロック定義 |
| 44-53 | フォームレイアウト各種 | 主機能 | Twig Bridgeのフォームレンダリング拡張による各フレームワーク対応ブロック定義 |
| 54-57 | メール通知テンプレート | 主機能 | Twig Bridgeのメール通知テンプレートによるレンダリング |

## 機能種別

テンプレートエンジン拡張（Twig Extension群）

## 入力仕様

### 入力パラメータ

各Twig関数・フィルターごとに異なる。代表例を以下に示す。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| form (form_widget等) | FormView | Yes | レンダリング対象のフォームビュー | FormViewインスタンスであること |
| route (path関数) | string | Yes | ルート名 | 登録済みルート名であること |
| parameters (path関数) | array | No | ルートパラメータ | - |
| attribute (is_granted) | mixed | Yes | チェック対象の権限属性 | - |
| id (trans) | string | Yes | 翻訳メッセージID | - |

### 入力データソース

- テンプレート内の変数・リテラル値
- Symfonyコンテナのサービス（Runtime経由で遅延ロード）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML出力 | string | フォームHTML、URL文字列、翻訳テキスト等 |
| bool出力 | bool | is_granted等のテスト結果 |

### 出力先

Twigテンプレートのレンダリング結果（HTML応答の一部として出力）

## 処理フロー

### 処理シーケンス

```
1. TwigBundleによるTwig拡張の登録
   └─ 各ExtensionクラスがTwig Environmentに登録される
2. テンプレートレンダリング時
   ├─ Twig Environmentがテンプレートをコンパイル
   ├─ テンプレート内のTwig関数/フィルター呼び出し
   ├─ 対応するExtensionメソッドの実行
   │   ├─ FormExtension -> FormRenderer -> フォームテーマテンプレート
   │   ├─ RoutingExtension -> UrlGenerator
   │   ├─ SecurityExtension -> AuthorizationChecker
   │   ├─ TranslationExtension -> Translator
   │   └─ 他の各Extension -> 対応するSymfonyサービス
   └─ 結果の出力
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレートレンダリング] --> B{Twig関数/フィルター呼び出し}
    B --> C[FormExtension]
    B --> D[RoutingExtension]
    B --> E[SecurityExtension]
    B --> F[TranslationExtension]
    B --> G[その他Extension]
    C --> H[FormRenderer]
    H --> I[フォームテーマテンプレート]
    D --> J[UrlGenerator]
    E --> K[AuthorizationChecker]
    F --> L[Translator]
    I --> M[HTMLレスポンス]
    J --> M
    K --> M
    L --> M
    G --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | フォームテーマ継承 | フォームテーマは親テーマを継承でき、特定ブロックのみオーバーライドできる | フォームレンダリング時 |
| BR-36-02 | ランタイムローディング | Extension内のメソッドはRuntimeクラスに委譲され、サービスコンテナから遅延ロードされる | Runtime対応Extension使用時 |
| BR-36-03 | AppVariable提供 | テンプレート内のapp変数でrequest, session, user, environment, debug, flashes, locale等にアクセスできる | 常時 |
| BR-36-04 | 翻訳ドメイン | trans_default_domainタグでテンプレート内のデフォルト翻訳ドメインを設定できる | TranslationExtension使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベース操作を行わない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Twig\Error\RuntimeError | 存在しないルート名を指定 | ルート名を確認する |
| - | Twig\Error\RuntimeError | フォームレンダリング中のエラー | フォームテーマの設定を確認する |

### リトライ仕様

リトライは不要。

## トランザクション仕様

トランザクション管理は行わない。

## パフォーマンス要件

- ランタイムローディングパターンにより、使用されないExtensionのサービスは読み込まれない
- フォームテーマのテンプレートブロックはTwigキャッシュにより再利用される

## セキュリティ考慮事項

- is_granted()はサーバーサイドの権限チェックであり、テンプレートでの表示制御と併せてコントローラーでのアクセス制御も必須
- csrf_token()で生成されたトークンは適切にフォームに埋め込む

## 備考

- Twig BridgeはTwigBundle（バンドル統合）とは異なり、コンポーネント間の低レベルな統合レイヤーを提供する
- 豊富なフォームテーマテンプレート（Bootstrap 3/4/5, Foundation 5/6, Tailwind 2）が同梱されている
- AppVariableはSymfonyアプリケーションのコンテキスト情報をテンプレートに公開する重要なクラスである

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートに公開されるデータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppVariable.php | `src/Symfony/Bridge/Twig/AppVariable.php` | app変数のデータクラス。request, session, user, environment, debug等のプロパティ |

**読解のコツ**: AppVariableはTwigグローバル変数`app`として登録される。テンプレートで`{{ app.user }}`のようにアクセスできる。

#### Step 2: エントリーポイントを理解する

主要なTwig拡張クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | フォーム関連のTwig関数定義 |
| 2-2 | RoutingExtension.php | `src/Symfony/Bridge/Twig/Extension/RoutingExtension.php` | path(), url()のTwig関数定義 |
| 2-3 | SecurityExtension.php | `src/Symfony/Bridge/Twig/Extension/SecurityExtension.php` | is_granted()のTwig関数定義 |
| 2-4 | TranslationExtension.php | `src/Symfony/Bridge/Twig/Extension/TranslationExtension.php` | transフィルターのTwig定義 |

**主要処理フロー**:
- **37-60行目** (AppVariable.php): setter群（TokenStorage, RequestStack, Environment, Debug等）

#### Step 3: フォームレンダリングを理解する

フォームのTwigレンダリング機構を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form/ | `src/Symfony/Bridge/Twig/Form/` | フォームレンダリング関連クラス |
| 3-2 | Resources/views/Form/ | `src/Symfony/Bridge/Twig/Resources/views/Form/` | フォームテーマテンプレート群 |

#### Step 4: メール通知テンプレートを理解する

メール通知のTwigテンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Mime/ | `src/Symfony/Bridge/Twig/Mime/` | Mime統合クラス |
| 4-2 | Resources/views/Email/ | `src/Symfony/Bridge/Twig/Resources/views/Email/` | メール通知テンプレート |

### プログラム呼び出し階層図

```
Twig Environment
    |
    +-- FormExtension (form_widget, form_row等)
    |       +-- FormRenderer
    |       |       +-- TwigRendererEngine
    |       |               +-- フォームテーマテンプレート
    |       +-- FormRuntime (form_start, form_end等)
    |
    +-- RoutingExtension (path, url)
    |       +-- UrlGeneratorInterface
    |
    +-- SecurityExtension (is_granted)
    |       +-- AuthorizationCheckerInterface
    |
    +-- TranslationExtension (trans)
    |       +-- TranslatorInterface
    |
    +-- HttpKernelExtension (render, render_esi)
    |       +-- HttpKernelRuntime
    |               +-- FragmentHandler
    |
    +-- AssetExtension (asset, asset_version)
    |       +-- Packages
    |
    +-- DumpExtension (dump)
    |       +-- HtmlDumper / CliDumper
    |
    +-- WorkflowExtension (workflow_can等)
            +-- WorkflowInterface
```

### データフロー図

```
[入力]                        [処理]                              [出力]

テンプレート変数 ──────> Twig Extension関数
                              |
Symfonyサービス ──────> Runtimeクラス（遅延ロード）
(Router, Security等)          |
                              v
                        各Extensionのメソッド実行
                              |
                              v
                        レンダリング結果 ──────> HTMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppVariable.php | `src/Symfony/Bridge/Twig/AppVariable.php` | ソース | app変数データクラス |
| FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | ソース | フォーム拡張 |
| RoutingExtension.php | `src/Symfony/Bridge/Twig/Extension/RoutingExtension.php` | ソース | ルーティング拡張 |
| SecurityExtension.php | `src/Symfony/Bridge/Twig/Extension/SecurityExtension.php` | ソース | セキュリティ拡張 |
| TranslationExtension.php | `src/Symfony/Bridge/Twig/Extension/TranslationExtension.php` | ソース | 翻訳拡張 |
| HttpFoundationExtension.php | `src/Symfony/Bridge/Twig/Extension/HttpFoundationExtension.php` | ソース | HTTP Foundation拡張 |
| HttpKernelExtension.php | `src/Symfony/Bridge/Twig/Extension/HttpKernelExtension.php` | ソース | HTTP Kernel拡張 |
| AssetExtension.php | `src/Symfony/Bridge/Twig/Extension/AssetExtension.php` | ソース | アセット拡張 |
| DumpExtension.php | `src/Symfony/Bridge/Twig/Extension/DumpExtension.php` | ソース | ダンプ拡張 |
| WorkflowExtension.php | `src/Symfony/Bridge/Twig/Extension/WorkflowExtension.php` | ソース | ワークフロー拡張 |
| CsrfExtension.php | `src/Symfony/Bridge/Twig/Extension/CsrfExtension.php` | ソース | CSRF拡張 |
| YamlExtension.php | `src/Symfony/Bridge/Twig/Extension/YamlExtension.php` | ソース | YAML拡張 |
| Resources/views/Form/ | `src/Symfony/Bridge/Twig/Resources/views/Form/` | テンプレート | フォームテーマ群 |
| Resources/views/Email/ | `src/Symfony/Bridge/Twig/Resources/views/Email/` | テンプレート | メール通知テンプレート群 |
