# 機能設計書 57-Finder

## 概要

本ドキュメントは、Symfony Finderコンポーネントの機能設計を記述する。Finderコンポーネントは直感的なフルーエントインターフェースでファイル・ディレクトリを検索する機能を提供し、パターンマッチ、サイズフィルタ、日付フィルタ等の豊富なフィルタリング条件をサポートする。

### 本機能の処理概要

Finderコンポーネントは、ファイルシステム上のファイルとディレクトリを柔軟に検索するためのDSL(Domain Specific Language)を提供する。メソッドチェーンによる宣言的な検索条件の構築と、Iterator パターンによる遅延評価を特徴とする。

**業務上の目的・背景**：アプリケーション開発では、特定のパターンに一致するファイルの検索、古いファイルのクリーンアップ、特定サイズ以上のファイルの検出など、多様なファイル検索ニーズがある。Finderコンポーネントは、PHP標準のRecursiveDirectoryIteratorを基盤としつつ、読みやすく保守しやすいフルーエントAPIを提供する。

**機能の利用シーン**：設定ファイルの自動検出、テンプレートファイルの列挙、キャッシュファイルのクリーンアップ対象検索、ログファイルのローテーション対象検索、アセットファイルの収集、コードジェネレーション対象ファイルの検索。

**主要な処理内容**：
1. ファイル名パターンによるフィルタリング(name/notName) - グロブ/正規表現対応
2. ディレクトリ深度制限(depth)
3. ファイルサイズによるフィルタリング(size)
4. ファイル更新日時によるフィルタリング(date)
5. ファイル種別(files/directories)によるフィルタリング
6. ファイル内容によるフィルタリング(contains/notContains)
7. パスパターンによるフィルタリング(path/notPath)
8. ディレクトリの除外(exclude)
9. VCSファイル/dotファイル/gitignoreファイルの無視
10. カスタムソート(sortByName, sortByModifiedTime, sort)
11. カスタムフィルタ(filter) - クロージャによる任意条件

**関連システム・外部連携**：OS のファイルシステム。

**権限による制御**：OSレベルのファイルパーミッションに依存。読み取り不可ディレクトリの扱い(ignoreUnreadableDirs)を設定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面はない。フレームワーク内部のファイル検索基盤として機能 |

## 機能種別

ファイル検索 / フィルタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dirs | string[] | Yes(in()) | 検索対象ディレクトリ | 存在するディレクトリであること |
| pattern | string | Yes(name/notName) | ファイル名パターン(グロブまたは正規表現) | 有効なグロブ/正規表現パターン |
| depth | string | Yes(depth) | 深度条件(例: '== 0', '< 3', '> 2') | 比較演算子+数値の文字列 |
| size | string | Yes(size) | サイズ条件(例: '> 1K', '< 100M') | 比較演算子+数値+単位の文字列 |
| date | string | Yes(date) | 日時条件(例: 'since yesterday', '> 2023-01-01') | strtotime解釈可能な文字列 |

### 入力データソース

ファイルシステム上のファイル・ディレクトリ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iterator | \Iterator<SplFileInfo> | フィルタ条件に一致するファイル情報のイテレータ |
| count | int | 一致するファイル数(\Countable実装) |

### 出力先

呼び出し元のアプリケーションコード。foreachでの反復処理、count()での件数取得。

## 処理フロー

### 処理シーケンス

```
1. Finderインスタンス生成
   └─ デフォルトでVCSファイルとdotファイルを無視
2. 検索条件の設定(フルーエントAPI)
   └─ files(), name(), size(), date(), depth(), in() 等をチェーン
3. イテレーション開始(getIterator)
   └─ 各ディレクトリごとにsearchInDirectory()を呼び出し
4. フィルタイテレータの構築
   └─ RecursiveDirectoryIterator -> ExcludeDirectoryFilter
   └─ -> FileTypeFilter -> FilenameFilter -> SizeFilter
   └─ -> DateFilter -> DepthFilter -> CustomFilter -> SortableIterator
5. 遅延評価で1件ずつ結果を返却
```

### フローチャート

```mermaid
flowchart TD
    A[Finder生成] --> B[検索条件設定]
    B --> C[in: 検索ディレクトリ指定]
    C --> D[getIterator呼び出し]
    D --> E[各ディレクトリで searchInDirectory]
    E --> F[RecursiveDirectoryIterator]
    F --> G[ExcludeDirectoryFilterIterator]
    G --> H[FileTypeFilterIterator]
    H --> I[FilenameFilterIterator]
    I --> J[SizeRangeFilterIterator]
    J --> K[DateRangeFilterIterator]
    K --> L[DepthRangeFilterIterator]
    L --> M[CustomFilterIterator]
    M --> N[SortableIterator]
    N --> O[結果イテレータ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-01 | デフォルト無視 | VCSファイル(.git, .svn等)とdotファイルはデフォルトで無視される | コンストラクタで IGNORE_VCS_FILES \| IGNORE_DOT_FILES を設定 |
| BR-57-02 | 遅延評価 | ファイル検索はイテレーション開始時まで遅延される | LazyIterator使用 |
| BR-57-03 | VCSパターン | .svn, _svn, CVS, _darcs, .arch-params, .monotone, .bzr, .git, .hg がVCSパターンとして定義 | IGNORE_VCS_FILES有効時 |

### 計算ロジック

特になし。

## データベース操作仕様

本コンポーネントはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DirectoryNotFoundException | in()で指定されたディレクトリが存在しない場合 | 有効なディレクトリパスを指定 |
| - | \LogicException | in()を呼ばずにイテレーションを開始した場合 | in()で検索ディレクトリを指定 |

### リトライ仕様

リトライ機構は不要。

## トランザクション仕様

トランザクション管理は対象外。

## パフォーマンス要件

- イテレータベースの遅延評価により、大量のファイルがあっても全てをメモリに保持しない
- DepthRangeFilterIteratorにより不要な深い階層の探索を早期に打ち切り

## セキュリティ考慮事項

- ユーザー入力をin()のディレクトリパスに直接渡す場合はパストラバーサルに注意
- ignoreUnreadableDirs(true)で読み取り不可ディレクトリのエラーを抑制可能

## 備考

Finderは\IteratorAggregateと\Countableを実装しており、foreachとcount()で直接使用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Finder.php | `src/Symfony/Component/Finder/Finder.php` | フルーエントAPI定義、フィルタ条件の蓄積、getIterator()でのイテレータチェーン構築 |
| 1-2 | SplFileInfo.php | `src/Symfony/Component/Finder/SplFileInfo.php` | PHP標準SplFileInfoの拡張、相対パス取得メソッド |

**読解のコツ**: Finderクラスは各フィルタ条件をプロパティ(配列)に蓄積し、getIterator()が呼ばれた時点で初めてイテレータチェーンを構築する。各フィルタメソッドは `$this` を返しチェーン呼び出しを可能にする。

**主要処理フロー**:
- **44-77行目**: 定数・プロパティ定義 - IGNORE定数、フィルタ条件配列
- **72行目**: VCSパターン定義(静的配列)
- **74-77行目**: コンストラクタ - デフォルトのIGNORE設定

#### Step 2: イテレータ群を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FilenameFilterIterator.php | `src/Symfony/Component/Finder/Iterator/FilenameFilterIterator.php` | ファイル名パターンマッチング |
| 2-2 | SizeRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/SizeRangeFilterIterator.php` | サイズ範囲フィルタ |
| 2-3 | DateRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/DateRangeFilterIterator.php` | 日時範囲フィルタ |
| 2-4 | DepthRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/DepthRangeFilterIterator.php` | ディレクトリ深度フィルタ |
| 2-5 | SortableIterator.php | `src/Symfony/Component/Finder/Iterator/SortableIterator.php` | ソートイテレータ |

#### Step 3: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Glob.php | `src/Symfony/Component/Finder/Glob.php` | グロブパターンから正規表現への変換 |
| 3-2 | Gitignore.php | `src/Symfony/Component/Finder/Gitignore.php` | .gitignoreルールの解析 |
| 3-3 | Comparator/ | `src/Symfony/Component/Finder/Comparator/` | 数値・日時の比較器 |

### プログラム呼び出し階層図

```
Finder::getIterator()
    |
    +-- [各ディレクトリに対して searchInDirectory()]
            |
            +-- RecursiveDirectoryIterator
                    |
                    +-- ExcludeDirectoryFilterIterator
                            |
                            +-- FileTypeFilterIterator (files/directories)
                                    |
                                    +-- FilenameFilterIterator (name/notName)
                                            |
                                            +-- SizeRangeFilterIterator
                                                    |
                                                    +-- DateRangeFilterIterator
                                                            |
                                                            +-- DepthRangeFilterIterator
                                                                    |
                                                                    +-- CustomFilterIterator
                                                                            |
                                                                            +-- SortableIterator
```

### データフロー図

```
[入力]                       [処理]                           [出力]

検索ディレクトリ ─────────> RecursiveDirectoryIterator   Iterator<SplFileInfo>
検索条件(name,             +-- フィルタチェーン適用       (条件に一致するファイル)
  size, date等)                 |
                                v
                    各種FilterIterator
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Finder.php | `src/Symfony/Component/Finder/Finder.php` | ソース | ファイル検索のメインクラス |
| SplFileInfo.php | `src/Symfony/Component/Finder/SplFileInfo.php` | ソース | 拡張SplFileInfo |
| Glob.php | `src/Symfony/Component/Finder/Glob.php` | ソース | グロブ->正規表現変換 |
| Gitignore.php | `src/Symfony/Component/Finder/Gitignore.php` | ソース | .gitignoreルール解析 |
| FilenameFilterIterator.php | `src/Symfony/Component/Finder/Iterator/FilenameFilterIterator.php` | ソース | ファイル名フィルタ |
| SizeRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/SizeRangeFilterIterator.php` | ソース | サイズフィルタ |
| DateRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/DateRangeFilterIterator.php` | ソース | 日時フィルタ |
| DepthRangeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/DepthRangeFilterIterator.php` | ソース | 深度フィルタ |
| SortableIterator.php | `src/Symfony/Component/Finder/Iterator/SortableIterator.php` | ソース | ソートイテレータ |
| CustomFilterIterator.php | `src/Symfony/Component/Finder/Iterator/CustomFilterIterator.php` | ソース | カスタムフィルタ |
| ExcludeDirectoryFilterIterator.php | `src/Symfony/Component/Finder/Iterator/ExcludeDirectoryFilterIterator.php` | ソース | ディレクトリ除外フィルタ |
| FileTypeFilterIterator.php | `src/Symfony/Component/Finder/Iterator/FileTypeFilterIterator.php` | ソース | ファイル種別フィルタ |
| LazyIterator.php | `src/Symfony/Component/Finder/Iterator/LazyIterator.php` | ソース | 遅延評価イテレータ |
| VcsIgnoredFilterIterator.php | `src/Symfony/Component/Finder/Iterator/VcsIgnoredFilterIterator.php` | ソース | VCS無視ファイルフィルタ |
