# 機能設計書 61-VarDumper

## 概要

本ドキュメントは、Symfony VarDumperコンポーネントの機能設計書である。VarDumperは任意のPHP変数を走査・ダンプするメカニズムを提供し、開発時のデバッグ作業を大幅に効率化するコンポーネントである。

### 本機能の処理概要

VarDumperは、PHP変数の内容を人間が読みやすい形式で出力するデバッグツールである。`dump()`関数を提供し、変数の型、値、構造（ネスト、参照関係を含む）を視覚的に表現する。

**業務上の目的・背景**：PHPの標準関数`var_dump()`や`print_r()`では、複雑なオブジェクトグラフや大規模な配列のデバッグが困難である。VarDumperは、変数のクローン化、型ごとのキャスト処理、HTML/CLI環境に応じた出力フォーマットを提供することで、開発者のデバッグ効率を向上させる。

**機能の利用シーン**：開発中にコントローラーやサービスクラス内で変数の内容を確認したい場合に`dump($variable)`を呼び出す。Webリクエスト中であればWeb Debug Toolbarに出力が集約され、CLIコマンド実行時にはコンソールにANSI色付きで出力される。リモートサーバーへの送信も可能。

**主要な処理内容**：
1. `dump()`関数による変数ダンプのエントリーポイント提供
2. VarClonerによる変数の安全なクローン化（参照関係の保持、深さ・アイテム数の制限）
3. Casterシステムによるオブジェクト・リソース型ごとの表示カスタマイズ
4. HtmlDumper/CliDumperによる環境に応じた出力フォーマット
5. ServerDumperによるリモートダンプサーバーへの送信
6. DumpServerによるTCPベースのダンプ収集サーバー

**関連システム・外部連携**：DebugBundleと統合してWeb Profiler Toolbarにダンプ出力を表示する。また、ServerDumperを使用してTCPプロトコル経由でリモートサーバーにダンプデータを送信可能。

**権限による制御**：特になし。開発環境での使用を想定しており、権限制御は行われない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | Dumpパネル | 主機能 | VarDumperコンポーネントによるdump()出力データの収集・表示 |

## 機能種別

デバッグ支援ツール / データ表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| var | mixed | Yes | ダンプ対象のPHP変数 | 任意のPHP型を受け付ける |
| label | string/null | No | ダンプに付加するラベル文字列 | null許容 |

### 入力データソース

PHP変数（開発者がdump()関数に渡す任意の値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーマット済みダンプ出力 | string/null | HTML形式またはCLI ANSI形式の変数表現 |
| Data オブジェクト | Data | クローンされた変数データの中間表現 |

### 出力先

- HTML出力（Webブラウザ、php://output）
- CLI出力（php://stdout、ANSI色付き）
- TCPサーバー（ServerDumperを使用したリモート送信）
- Web Debug Toolbar（DebugBundle経由）

## 処理フロー

### 処理シーケンス

```
1. dump($var) 呼び出し
   └─ VarDumper::dump() が呼ばれる
2. ハンドラの初期化確認
   └─ handler が null の場合、register() で自動設定
3. 環境判定とDumper選択
   └─ VAR_DUMPER_FORMAT 環境変数またはHTTP_ACCEPTヘッダーに基づく
4. 変数のクローン化
   └─ VarCloner::cloneVar() で安全にクローン作成
5. オブジェクト・リソースのキャスト処理
   └─ AbstractCloner::castObject() / castResource() で型別変換
6. ダンプ出力
   └─ HtmlDumper/CliDumper/ServerDumper でフォーマットして出力
```

### フローチャート

```mermaid
flowchart TD
    A[dump関数呼び出し] --> B{handlerが設定済み?}
    B -->|No| C[register で自動初期化]
    B -->|Yes| D[handler実行]
    C --> E{VAR_DUMPER_FORMAT判定}
    E -->|html| F[HtmlDumper生成]
    E -->|cli| G[CliDumper生成]
    E -->|server/tcp| H[ServerDumper生成]
    E -->|default| I[HTTP_ACCEPT判定]
    I -->|html| F
    I -->|text| G
    F --> J[ContextualizedDumper でラップ]
    G --> J
    H --> D
    J --> D
    D --> K[VarCloner.cloneVar で変数クローン]
    K --> L[Data オブジェクト生成]
    L --> M[Dumper.dump で出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 出力形式自動判定 | VAR_DUMPER_FORMAT環境変数またはHTTP_ACCEPTヘッダーに基づきHTML/CLI出力を自動選択 | ハンドラ未設定時 |
| BR-02 | 最大アイテム数制限 | maxItems（デフォルト2500）を超えるネスト要素はカットされる | 変数クローン時 |
| BR-03 | 最大文字列長制限 | maxString（デフォルト-1=無制限）を超える文字列はカットされる | 文字列クローン時 |
| BR-04 | 最小深度保証 | minDepth（デフォルト1）以内のアイテムはすべてクローンされる | 変数クローン時 |
| BR-05 | ServerDumperフォールバック | TCPサーバーに接続できない場合はwrappedDumperにフォールバック | ServerDumper使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ThrowingCasterException | キャスター実行中に例外が発生 | 警告マーク付きでダンプ出力に含める |
| - | RuntimeException | DumpServerのソケット作成失敗 | エラーメッセージを投げる |
| - | E_RECOVERABLE_ERROR | クローン処理中のリカバラブルエラー | ErrorExceptionとして投げる |

### リトライ仕様

ServerDumperでサーバー接続に失敗した場合、wrappedDumper（CliDumperまたはHtmlDumper）にフォールバックする。リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- クローン処理中はGCを無効化し、パフォーマンスを最適化する（AbstractCloner::cloneVar() 312-320行目）
- maxItems, maxString, minDepth パラメータにより出力量を制御可能

## セキュリティ考慮事項

- DumpServerは受信データをunserializeするため、信頼できるネットワーク内でのみ使用すべき（DumpServer.php 61行目でallowed_classesを制限）
- 本番環境での使用は非推奨。SensitiveParameterアトリビュートが付いたパラメータはReflectionCasterにより自動的に除外可能

## 備考

- VAR_DUMPER_FORMAT環境変数で出力形式を制御可能（html, cli, server, tcp://host:port）
- `dump()`関数はResources/functions/dump.phpで定義され、composer autoloadで自動読み込みされる
- var-dump-serverバイナリ（Resources/bin/var-dump-server）でダンプ収集サーバーを起動可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、VarDumperの中間データ表現であるStubとDataクラスを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Stub.php | `src/Symfony/Component/VarDumper/Cloner/Stub.php` | 変数のメタ情報を保持するスタブ。TYPE_STRING, TYPE_ARRAY, TYPE_OBJECT, TYPE_RESOURCEの型定数を定義 |
| 1-2 | Data.php | `src/Symfony/Component/VarDumper/Cloner/Data.php` | クローン結果を保持する不変データ構造。ArrayAccess, Countable, IteratorAggregateを実装 |
| 1-3 | Cursor.php | `src/Symfony/Component/VarDumper/Cloner/Cursor.php` | ダンプ走査時のカーソル位置情報（深さ、ハッシュ型、参照情報） |

**読解のコツ**: Stubクラスの型定数（TYPE_*）とStub::ARRAY_INDEXED / ARRAY_ASSOC の区別を押さえると、後続のCloner/Dumperの処理が理解しやすい。

#### Step 2: エントリーポイントを理解する

処理の起点となるdump()関数とVarDumperクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dump.php | `src/Symfony/Component/VarDumper/Resources/functions/dump.php` | グローバルdump()関数の定義 |
| 2-2 | VarDumper.php | `src/Symfony/Component/VarDumper/VarDumper.php` | 静的ハンドラの管理とデフォルトDumperの初期化 |

**主要処理フロー**:
1. **40-47行目**: dump()メソッド。handlerがnullならregister()を呼び出し、handlerを実行
2. **63-101行目**: register()。環境に応じたDumperの自動選択とhandlerの設定
3. **68-86行目**: VAR_DUMPER_FORMATによるDumper選択ロジック（html/cli/server/default）
4. **92-100行目**: ハンドラクロージャ。cloneVar → withContext(label) → dump の流れ

#### Step 3: Cloner層を理解する

変数のクローン化処理を担うCloner層を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClonerInterface.php | `src/Symfony/Component/VarDumper/Cloner/ClonerInterface.php` | クローナーのインターフェース定義 |
| 3-2 | AbstractCloner.php | `src/Symfony/Component/VarDumper/Cloner/AbstractCloner.php` | デフォルトキャスターマップ、cloneVar()の実装 |
| 3-3 | VarCloner.php | `src/Symfony/Component/VarDumper/Cloner/VarCloner.php` | doClone()の具体実装。幅優先探索による変数走査 |

**主要処理フロー**:
- **AbstractCloner 24-205行目**: $defaultCastersに100以上のPHP型ごとのキャスターマッピングを定義
- **AbstractCloner 296-324行目**: cloneVar()。GC無効化→doClone→Data生成→GC復帰
- **VarCloner 44-214行目**: doClone()。幅優先キュー$queueを用いた変数構造の再帰的クローン
- **VarCloner 58-75行目**: ReflectionReferenceによるハードリファレンス検出
- **VarCloner 78-174行目**: 型別のクローン処理（null/bool/int/float → string → array → object → resource）

#### Step 4: Dumper層を理解する

出力フォーマットを担うDumper層を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DataDumperInterface.php | `src/Symfony/Component/VarDumper/Dumper/DataDumperInterface.php` | Dumperのインターフェース |
| 4-2 | AbstractDumper.php | `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php` | 出力ストリーム管理の基底クラス |
| 4-3 | CliDumper.php | `src/Symfony/Component/VarDumper/Dumper/CliDumper.php` | ANSI色付きCLI出力 |
| 4-4 | HtmlDumper.php | `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php` | HTML形式出力（折りたたみ可能、検索機能付き） |
| 4-5 | ServerDumper.php | `src/Symfony/Component/VarDumper/Dumper/ServerDumper.php` | TCPサーバーへのシリアライズ送信 |
| 4-6 | ContextualizedDumper.php | `src/Symfony/Component/VarDumper/Dumper/ContextualizedDumper.php` | コンテキスト情報（ソースファイル位置等）の付加 |

**主要処理フロー**:
- **HtmlDumper 27-62行目**: dark/lightテーマのCSS定義
- **HtmlDumper 130-137行目**: dump()。親クラスのdump呼び出し後にdumpIdをリセット
- **HtmlDumper 150-768行目**: getDumpHeader()。大規模なJavaScriptを含むHTMLヘッダー（検索、折りたたみ、ハイライト機能）
- **CliDumper 126-185行目**: dumpScalar()。型ごとのスタイル適用
- **ServerDumper 45-52行目**: dump()。Connection::write()失敗時にwrappedDumperへフォールバック

#### Step 5: Server層を理解する

リモートダンプサーバーの仕組みを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Connection.php | `src/Symfony/Component/VarDumper/Server/Connection.php` | TCPクライアント接続 |
| 5-2 | DumpServer.php | `src/Symfony/Component/VarDumper/Server/DumpServer.php` | TCPサーバー。base64+serializeされたデータを受信 |

**主要処理フロー**:
- **DumpServer 45-49行目**: start()。stream_socket_serverでTCPサーバー起動
- **DumpServer 52-80行目**: listen()。コールバック関数にData+contextを渡す
- **DumpServer 61行目**: unserialize時にallowed_classesをData/Stubに限定（セキュリティ対策）

### プログラム呼び出し階層図

```
dump($var)
    │
    ├─ VarDumper::dump($var, $label)
    │      │
    │      ├─ VarDumper::register()  [初回のみ]
    │      │      ├─ new VarCloner()
    │      │      ├─ HtmlDumper / CliDumper / ServerDumper  [環境による選択]
    │      │      └─ new ContextualizedDumper(dumper, [SourceContextProvider])
    │      │
    │      └─ handler($var, $label)
    │             ├─ VarCloner::cloneVar($var)
    │             │      ├─ VarCloner::doClone($var)  [幅優先探索]
    │             │      │      ├─ AbstractCloner::castObject()
    │             │      │      │      └─ Caster callbacks (e.g., ReflectionCaster, DOMCaster...)
    │             │      │      └─ AbstractCloner::castResource()
    │             │      └─ new Data($queue)
    │             │
    │             ├─ Data::withContext(['label' => $label])
    │             │
    │             └─ Dumper::dump($data)
    │                    ├─ [HtmlDumper] getDumpHeader() → style() → dumpLine()
    │                    ├─ [CliDumper]  dumpScalar/dumpString/enterHash/leaveHash
    │                    └─ [ServerDumper] Connection::write($data) → fallback to wrappedDumper
```

### データフロー図

```
[入力]                    [処理]                           [出力]

PHP変数($var)  ───▶  VarCloner::cloneVar()         ───▶  Data オブジェクト
                     (幅優先探索、Caster適用)
                            │
                            ▼
                     Dumper::dump(Data)
                            │
              ┌─────────────┼──────────────┐
              ▼             ▼              ▼
       HtmlDumper     CliDumper      ServerDumper
       (HTML出力)    (ANSI出力)    (TCP送信→DumpServer)
              │             │              │
              ▼             ▼              ▼
       php://output   php://stdout   tcp://host:port
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VarDumper.php | `src/Symfony/Component/VarDumper/VarDumper.php` | ソース | メインエントリーポイント、ハンドラ管理 |
| dump.php | `src/Symfony/Component/VarDumper/Resources/functions/dump.php` | ソース | グローバルdump()関数定義 |
| AbstractCloner.php | `src/Symfony/Component/VarDumper/Cloner/AbstractCloner.php` | ソース | キャスターマップとクローン基盤 |
| VarCloner.php | `src/Symfony/Component/VarDumper/Cloner/VarCloner.php` | ソース | 幅優先探索による変数クローン実装 |
| Data.php | `src/Symfony/Component/VarDumper/Cloner/Data.php` | ソース | クローン結果の不変データ構造 |
| Stub.php | `src/Symfony/Component/VarDumper/Cloner/Stub.php` | ソース | 変数メタ情報スタブ |
| Cursor.php | `src/Symfony/Component/VarDumper/Cloner/Cursor.php` | ソース | ダンプ走査カーソル |
| HtmlDumper.php | `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php` | ソース | HTML形式出力（テーマ、検索機能） |
| CliDumper.php | `src/Symfony/Component/VarDumper/Dumper/CliDumper.php` | ソース | CLI ANSI色付き出力 |
| ServerDumper.php | `src/Symfony/Component/VarDumper/Dumper/ServerDumper.php` | ソース | リモートサーバーへの送信 |
| ContextualizedDumper.php | `src/Symfony/Component/VarDumper/Dumper/ContextualizedDumper.php` | ソース | コンテキスト情報付加 |
| DumpServer.php | `src/Symfony/Component/VarDumper/Server/DumpServer.php` | ソース | TCPダンプ収集サーバー |
| Connection.php | `src/Symfony/Component/VarDumper/Server/Connection.php` | ソース | TCPクライアント接続 |
| AbstractDumper.php | `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php` | ソース | Dumper基底クラス |
| Caster.php | `src/Symfony/Component/VarDumper/Caster/Caster.php` | ソース | キャストユーティリティ |
| ReflectionCaster.php | `src/Symfony/Component/VarDumper/Caster/ReflectionCaster.php` | ソース | リフレクション型キャスター |
| composer.json | `src/Symfony/Component/VarDumper/composer.json` | 設定 | 依存関係定義 |
