# 機能設計書 62-DebugBundle

## 概要

本ドキュメントは、Symfony DebugBundleの機能設計書である。DebugBundleはVarDumperコンポーネントとMonolog BridgeのServerLogCommandをSymfonyフルスタックフレームワークに統合するバンドルである。

### 本機能の処理概要

DebugBundleは、VarDumperコンポーネントのdump()関数出力をSymfonyのWeb Debug Toolbar（Web Profiler）に統合する。これにより、開発者がdump()で出力したデバッグ情報がブラウザのプロファイラーパネルに集約して表示される。

**業務上の目的・背景**：開発環境において、dump()関数の出力がHTMLレスポンスに直接挿入されるとページレイアウトが崩れる。DebugBundleはdump()出力をDumpDataCollectorにリダイレクトし、Web Debug Toolbarの専用パネルで整理して表示することで、デバッグ体験を改善する。

**機能の利用シーン**：Symfonyアプリケーションのdebugモード有効時に自動的に適用される。開発者がコントローラーやサービス内でdump()を呼び出すと、出力がプロファイラーのDumpパネルに表示される。CLIモードではコンソール出力にフォールバックする。

**主要な処理内容**：
1. VarDumperのハンドラをDumpDataCollector経由に差し替え
2. VarClonerの設定（maxItems, minDepth, maxStringLength）をDI設定から注入
3. HtmlDumperのテーマ設定
4. dump先のルーティング（Web Profiler / ファイル / TCPサーバー）
5. ServerDumpCommandによるダンプ収集サーバーの提供

**関連システム・外部連携**：VarDumperコンポーネント、HttpKernelのDumpDataCollector、WebProfilerBundle、Monolog Bridge

**権限による制御**：kernel.debugパラメータがtrueの場合のみハンドラが設定される（DebugBundle.php 27行目）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | Dumpパネル | 主機能 | dump()で出力されたデバッグ情報を表示するパネル（DebugBundle提供テンプレート） |

## 機能種別

フレームワーク統合 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| max_items | int | No | VarClonerの最大アイテム数 | 正の整数 |
| min_depth | int | No | VarClonerの最小深度 | 0以上の整数 |
| max_string_length | int | No | VarClonerの最大文字列長 | -1以上の整数 |
| theme | string | No | HtmlDumperのテーマ名 | dark（デフォルト）またはlight |
| dump_destination | string/null | No | ダンプ出力先 | null, tcp://host:port, またはファイルパス |

### 入力データソース

Symfonyフレームワーク設定ファイル（config/packages/debug.yaml等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Dumpパネル表示 | HTML | Web Profilerのダンプ情報パネル |
| CLIダンプ出力 | string | コンソールへのANSI色付き出力 |

### 出力先

- Web Debug Toolbar（DumpDataCollector経由）
- ファイル（dump_destinationで指定した場合）
- TCPサーバー（dump_destinationがtcp://の場合）

## 処理フロー

### 処理シーケンス

```
1. DebugBundle::boot()
   └─ kernel.debugがtrueか確認
2. VarDumper::setHandler() でハンドラを差し替え
   └─ data_collector.dump サービスへの遅延初期化ハンドラ設定
3. dump() 呼び出し時
   └─ VarCloner でクローン → DumpDataCollector::dump() に渡す
4. レスポンス完了時
   └─ Web Profiler がDumpDataCollectorからダンプデータを取得して表示
```

### フローチャート

```mermaid
flowchart TD
    A[DebugBundle::boot] --> B{kernel.debug?}
    B -->|No| C[何もしない]
    B -->|Yes| D[VarDumper::setHandler設定]
    D --> E[dump呼び出し]
    E --> F[遅延初期化: data_collector.dump取得]
    F --> G[VarCloner::cloneVar]
    G --> H[DumpDataCollector::dump]
    H --> I{dump_destination設定}
    I -->|null| J[WDTに表示]
    I -->|tcp://| K[ServerConnectionに送信]
    I -->|file| L[ファイルに出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デバッグモード限定 | kernel.debugがtrueの場合のみハンドラ差し替え | バンドルブート時 |
| BR-02 | 遅延初期化 | DumpDataCollectorとVarClonerは初回dump時に取得 | dump()初回呼び出し時 |
| BR-03 | テーマデフォルト | darkテーマがデフォルト。dark以外の場合のみsetTheme呼び出し | DI設定時 |

### 計算ロジック

特になし。

## データベース操作仕様

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | サービス未登録 | data_collector.dumpがコンテナに存在しない | DIコンパイル時に検出 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- VarDumperハンドラは遅延初期化パターンで実装。初回dump呼び出し時にサービスを解決し、2回目以降は直接ハンドラを呼び出す（DebugBundle.php 35-48行目）。

## セキュリティ考慮事項

- debugモード（kernel.debug=true）でのみ動作。本番環境では無効。
- dump_destinationをTCPサーバーに設定する場合、信頼できるネットワーク内での使用を推奨。

## 備考

- DumpDataCollectorPassコンパイラパスにより、CLIモードでのハンドラ差し替え処理が追加される
- MonologのServerLogCommandが利用可能な場合、monolog.command.server_logサービスが登録される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DebugBundleはDIコンテナ設定を通じてVarDumperの各サービスを構成する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Configuration.php | `src/Symfony/Bundle/DebugBundle/DependencyInjection/Configuration.php` | 設定スキーマ定義（max_items, min_depth, max_string_length, theme, dump_destination） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DebugBundle.php | `src/Symfony/Bundle/DebugBundle/DebugBundle.php` | boot()でVarDumper::setHandler呼び出し |

**主要処理フロー**:
1. **27行目**: kernel.debugパラメータのチェック
2. **35-48行目**: 遅延初期化ハンドラの設定。初回dump時にdata_collector.dumpとvar_dumper.clonerを取得
3. **46行目**: VarDumper::setHandler()で直接ハンドラに差し替え（2回目以降高速化）

#### Step 3: DI設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DebugExtension.php | `src/Symfony/Bundle/DebugBundle/DependencyInjection/DebugExtension.php` | 設定値の適用ロジック |

**主要処理フロー**:
- **37-41行目**: VarClonerにmaxItems, minDepth, maxString設定を注入
- **43-46行目**: darkテーマ以外の場合にsetTheme呼び出し
- **48-75行目**: dump_destinationに応じたサービス構成の分岐（null / tcp:// / ファイル）

### プログラム呼び出し階層図

```
DebugBundle::boot()
    │
    ├─ VarDumper::setHandler(遅延初期化ハンドラ)
    │      └─ 初回dump時:
    │             ├─ container->get('data_collector.dump')  [DumpDataCollector]
    │             ├─ container->get('var_dumper.cloner')    [VarCloner]
    │             └─ VarDumper::setHandler(直接ハンドラ)    [2回目以降用]
    │
    └─ DebugBundle::build()
           └─ DumpDataCollectorPass  [CLIモード対応]

DebugExtension::load()
    │
    ├─ services.php ロード
    ├─ var_dumper.cloner 設定（maxItems, minDepth, maxString）
    ├─ var_dumper.html_dumper テーマ設定
    └─ dump_destination による分岐
           ├─ null → WDT出力
           ├─ tcp:// → ServerConnection経由
           └─ file → CliDumperにファイルパス設定
```

### データフロー図

```
[入力]                    [処理]                           [出力]

dump($var)     ───▶  VarDumper::$handler           ───▶  DumpDataCollector
                     (DebugBundleで設定)                       │
                            │                                  ▼
                            ▼                            Web Profiler
                     VarCloner::cloneVar()              Dumpパネル表示
                            │
                            ▼
                     Data オブジェクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DebugBundle.php | `src/Symfony/Bundle/DebugBundle/DebugBundle.php` | ソース | バンドルクラス、boot()でハンドラ設定 |
| DebugExtension.php | `src/Symfony/Bundle/DebugBundle/DependencyInjection/DebugExtension.php` | ソース | DI拡張、設定適用 |
| Configuration.php | `src/Symfony/Bundle/DebugBundle/DependencyInjection/Configuration.php` | ソース | 設定スキーマ定義 |
| DumpDataCollectorPass.php | `src/Symfony/Bundle/DebugBundle/DependencyInjection/Compiler/DumpDataCollectorPass.php` | ソース | CLIモード対応コンパイラパス |
| services.php | `src/Symfony/Bundle/DebugBundle/Resources/config/services.php` | 設定 | サービス定義 |
| ServerDumpPlaceholderCommand.php | `src/Symfony/Bundle/DebugBundle/Command/ServerDumpPlaceholderCommand.php` | ソース | dump_destination未設定時のプレースホルダー |
| composer.json | `src/Symfony/Bundle/DebugBundle/composer.json` | 設定 | 依存関係定義 |
