# 機能設計書 64-Ldap

## 概要

本ドキュメントは、Symfony Ldapコンポーネントの機能設計書である。LDAPディレクトリサービスとのインタラクションを提供する抽象化レイヤーである。

### 本機能の処理概要

Ldapコンポーネントは、LDAPプロトコル（Lightweight Directory Access Protocol）を使用したディレクトリサービスとの通信を抽象化する。バインド（認証）、検索、エントリの追加・更新・削除・名前変更といったLDAP操作を統一的なAPIで提供する。

**業務上の目的・背景**：企業システムにおいてActive DirectoryやOpenLDAPなどのディレクトリサービスは、ユーザー認証・認可の中核を担う。Ldapコンポーネントはこれらのディレクトリとの通信を抽象化し、SymfonyのSecurityコンポーネントと連携してLDAP認証を実現する。

**機能の利用シーン**：
- LDAPサーバーに対するユーザー認証（bind操作）
- SASL認証（saslBind操作）
- LDAPディレクトリからのユーザー/グループ情報の検索（query操作）
- エントリの作成・更新・削除・名前変更（EntryManager操作）

**主要な処理内容**：
1. Ldapファサードクラスによる統一的なAPI提供
2. AdapterInterface抽象化（ext_ldap PHP拡張のラッパー）
3. Connectionによるバインド/アンバインド処理
4. Queryによる検索操作（サブツリー検索、ページネーション対応）
5. EntryManagerによるCRUD操作
6. Entryクラスによるディレクトリエントリのモデル化

**関連システム・外部連携**：LDAPサーバー（Active Directory、OpenLDAP等）、Symfony Securityコンポーネント（LdapBindAuthenticationProvider）

**権限による制御**：LDAP bindによるDN/パスワード認証。SensitiveParameterアトリビュートでパスワードパラメータの保護。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面関連なし（バックエンドコンポーネント） |

## 機能種別

通信・認証 / ディレクトリサービス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| adapter | string | Yes | アダプター名（現在は'ext_ldap'のみ） | 'ext_ldap'のみサポート |
| host | string | No | LDAPサーバーホスト | - |
| port | int | No | LDAPサーバーポート | デフォルト: 389 |
| version | int | No | LDAPプロトコルバージョン | デフォルト: 3 |
| encryption | string | No | 暗号化方式 | none, ssl, tls |
| dn | string | No | Distinguished Name（バインド用） | null許容 |
| password | string | No | バインドパスワード | SensitiveParameter |
| query | string | Yes | LDAP検索フィルタ | LDAP検索フィルタ構文 |

### 入力データソース

LDAPサーバー接続設定（config/packages/ldap.yaml等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Entry | Entry | LDAPディレクトリエントリ（DN + 属性の集合） |
| Collection | CollectionInterface | 検索結果のEntryコレクション |
| whoami結果 | string | 認証済みDN |

### 出力先

呼び出し元のPHPコード（メモリ上のオブジェクト）

## 処理フロー

### 処理シーケンス

```
1. Ldap::create('ext_ldap', $config) でインスタンス生成
   └─ Adapter($config) でアダプターを作成
2. Ldap::bind($dn, $password) で認証
   └─ Connection::bind() → ldap_bind()
3. Ldap::query($dn, $filter) で検索
   └─ Adapter::createQuery() → Query → ldap_search()
4. クエリ結果の取得
   └─ Query::execute() → Collection (iterable<Entry>)
5. エントリ操作（必要に応じて）
   └─ EntryManager::add/update/remove/rename()
```

### フローチャート

```mermaid
flowchart TD
    A[Ldap::create] --> B[Adapter生成]
    B --> C[Connection生成]
    C --> D[Ldap::bind]
    D --> E{認証成功?}
    E -->|No| F[ConnectionException]
    E -->|Yes| G{操作選択}
    G -->|検索| H[Ldap::query]
    G -->|エントリ管理| I[Ldap::getEntryManager]
    H --> J[Query::execute]
    J --> K[Collection<Entry>]
    I --> L{操作種別}
    L -->|追加| M[EntryManager::add]
    L -->|更新| N[EntryManager::update]
    L -->|削除| O[EntryManager::remove]
    L -->|名前変更| P[EntryManager::rename]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | アダプター制限 | 現在はext_ldapアダプターのみサポート | create()呼び出し時 |
| BR-02 | 属性大文字小文字 | getAttribute()はcaseSensitive引数で大文字小文字の区別を制御 | Entry属性アクセス時 |
| BR-03 | SASL認証サポート | saslBind()でSASL認証メカニズムを指定可能 | SASL認証時 |
| BR-04 | エスケープフラグ | escape()でフィルタ用(ESCAPE_FILTER=0x01)とDN用(ESCAPE_DN=0x02)を区別 | 文字列エスケープ時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| bind | LDAPサーバー | 認証 | DN/パスワードによる認証 |
| query | LDAPディレクトリ | 検索 | LDAPフィルタによるエントリ検索 |
| add | LDAPディレクトリ | 追加 | 新規エントリの追加 |
| update | LDAPディレクトリ | 更新 | 既存エントリの属性更新 |
| remove | LDAPディレクトリ | 削除 | エントリの削除 |
| rename | LDAPディレクトリ | 更新 | エントリのDN変更 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DriverNotFoundException | サポートされていないアダプター名指定 | 'ext_ldap'を使用 |
| - | ConnectionException | バインド失敗（認証エラー） | DN/パスワードの確認 |
| - | LdapException | LDAP操作の一般的なエラー | エラーメッセージで原因を確認 |

### リトライ仕様

該当なし。コネクション管理はアプリケーション層の責務。

## トランザクション仕様

LDAPにはトランザクション機能はない。各操作は即座に反映される。

## パフォーマンス要件

- 大量の検索結果に対してページネーション対応（pageSize オプション）

## セキュリティ考慮事項

- パスワードパラメータに`#[\SensitiveParameter]`アトリビュートが付与されている（Ldap.php 30行目、35行目）
- LDAP injection対策としてescape()メソッドを提供（ldap_escape()のラッパー）
- TLS/SSL暗号化オプションをサポート

## 備考

- ext_ldap PHP拡張が必須（Adapterのコンストラクタでチェック）
- 現在のところext_ldapアダプターのみサポートされている（Ldap.php 68行目の条件分岐）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Entry.php | `src/Symfony/Component/Ldap/Entry.php` | LDAPエントリモデル。DN + 属性配列。大文字小文字非依存の属性アクセスにlowerMapを使用 |
| 1-2 | UpdateOperation.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/UpdateOperation.php` | 更新操作の定義（add/delete/replace属性） |

**読解のコツ**: Entry::setAttribute()（98-102行目）で属性を設定すると同時にlowerMap（大文字小文字変換マップ）も更新される点が重要。

#### Step 2: インターフェース層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LdapInterface.php | `src/Symfony/Component/Ldap/LdapInterface.php` | 定数ESCAPE_FILTER/ESCAPE_DN定義、メソッドシグネチャ |
| 2-2 | AdapterInterface.php | `src/Symfony/Component/Ldap/Adapter/AdapterInterface.php` | アダプターの抽象化 |
| 2-3 | ConnectionInterface.php | `src/Symfony/Component/Ldap/Adapter/ConnectionInterface.php` | 接続管理インターフェース |
| 2-4 | QueryInterface.php | `src/Symfony/Component/Ldap/Adapter/QueryInterface.php` | 検索クエリインターフェース |
| 2-5 | EntryManagerInterface.php | `src/Symfony/Component/Ldap/Adapter/EntryManagerInterface.php` | エントリCRUDインターフェース |

#### Step 3: ファサードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Ldap.php | `src/Symfony/Component/Ldap/Ldap.php` | メインファサード。AdapterInterfaceへのデリゲーション |

**主要処理フロー**:
- **30-33行目**: bind() - Adapter::getConnection()::bind()にデリゲート
- **35-38行目**: saslBind() - SASL認証
- **45-48行目**: query() - Adapter::createQuery()にデリゲート
- **66-73行目**: create() - ファクトリメソッド。ext_ldapのみサポート

#### Step 4: ext_ldap実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Adapter.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Adapter.php` | ext_ldapアダプター実装 |
| 4-2 | Connection.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Connection.php` | ldap_connect/ldap_bind呼び出し |
| 4-3 | Query.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Query.php` | ldap_search呼び出し、ページネーション |
| 4-4 | EntryManager.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/EntryManager.php` | ldap_add/modify/delete/rename呼び出し |
| 4-5 | Collection.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Collection.php` | 検索結果のイテレーション |

### プログラム呼び出し階層図

```
Ldap (ファサード)
    │
    ├─ bind($dn, $password)
    │      └─ Adapter::getConnection()
    │             └─ Connection::bind($dn, $password)
    │                    └─ ldap_bind()
    │
    ├─ saslBind($dn, $password, $mech, ...)
    │      └─ Connection::saslBind(...)
    │             └─ ldap_sasl_bind()
    │
    ├─ query($dn, $filter, $options)
    │      └─ Adapter::createQuery($dn, $filter, $options)
    │             └─ new Query($connection, $dn, $filter, $options)
    │                    └─ execute() → ldap_search()
    │                           └─ new Collection($connection, $search)
    │                                  └─ Entry objects
    │
    ├─ getEntryManager()
    │      └─ Adapter::getEntryManager()
    │             └─ new EntryManager($connection)
    │                    ├─ add(Entry)     → ldap_add()
    │                    ├─ update(Entry)  → ldap_modify_batch()
    │                    ├─ remove(Entry)  → ldap_delete()
    │                    └─ rename(Entry)  → ldap_rename()
    │
    └─ escape($subject, $ignore, $flags)
           └─ Adapter::escape()
                  └─ ldap_escape()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

DN + Password   ───▶  Connection::bind()           ───▶  認証済みコネクション
                       └─ ldap_bind()

Base DN +       ───▶  Query::execute()             ───▶  Collection<Entry>
Search Filter          └─ ldap_search()
                       └─ ldap_get_entries()

Entry           ───▶  EntryManager::add/update/    ───▶  LDAPディレクトリ更新
                       remove/rename()
                       └─ ldap_add/modify/delete/rename()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Ldap.php | `src/Symfony/Component/Ldap/Ldap.php` | ソース | メインファサード |
| LdapInterface.php | `src/Symfony/Component/Ldap/LdapInterface.php` | ソース | メインインターフェース |
| Entry.php | `src/Symfony/Component/Ldap/Entry.php` | ソース | エントリモデル |
| AdapterInterface.php | `src/Symfony/Component/Ldap/Adapter/AdapterInterface.php` | ソース | アダプターIF |
| ConnectionInterface.php | `src/Symfony/Component/Ldap/Adapter/ConnectionInterface.php` | ソース | 接続IF |
| QueryInterface.php | `src/Symfony/Component/Ldap/Adapter/QueryInterface.php` | ソース | 検索IF |
| EntryManagerInterface.php | `src/Symfony/Component/Ldap/Adapter/EntryManagerInterface.php` | ソース | エントリ管理IF |
| Adapter.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Adapter.php` | ソース | ext_ldapアダプター |
| Connection.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Connection.php` | ソース | ext_ldap接続実装 |
| Query.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Query.php` | ソース | ext_ldap検索実装 |
| EntryManager.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/EntryManager.php` | ソース | ext_ldapエントリ管理 |
| Collection.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/Collection.php` | ソース | 検索結果コレクション |
| ConnectionOptions.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/ConnectionOptions.php` | ソース | 接続オプション定数 |
| UpdateOperation.php | `src/Symfony/Component/Ldap/Adapter/ExtLdap/UpdateOperation.php` | ソース | 更新操作定義 |
