# 機能設計書 66-MonologBridge

## 概要

本ドキュメントは、Symfony Monolog Bridgeの機能設計書である。Monolog BridgeはMonologロギングライブラリとSymfonyフレームワークを統合するブリッジコンポーネントである。

### 本機能の処理概要

Monolog Bridgeは、Symfony固有のHandler（コンソール出力、メーラー、Notifier、Elasticsearch）とProcessor（リクエスト情報、ルート情報、トークン情報、デバッグ情報）を提供し、MonologをSymfonyアプリケーションに最適化する。

**業務上の目的・背景**：Monologは事実上の標準PHPロギングライブラリであり、PSR-3準拠のログ記録を提供する。Monolog Bridgeは、Symfonyのコンソール出力レベル連動、メール通知、Notifier連携、Web Profiler用のデバッグログ収集などを実現する。

**機能の利用シーン**：
- CLIコマンド実行時に-v/-vv/-vvvオプションに連動したログレベル出力（ConsoleHandler）
- エラー発生時のメール通知（MailerHandler）
- Symfony Notifier経由の通知（NotifierHandler）
- Elasticsearchへのログ送信（ElasticsearchLogstashHandler）
- Web Profilerのログパネルへのデバッグ情報提供（DebugProcessor）
- リクエスト情報のログエンリッチメント（WebProcessor, RouteProcessor）

**主要な処理内容**：
1. Handler群 - ConsoleHandler、MailerHandler、NotifierHandler、ElasticsearchLogstashHandler、ServerLogHandler、ChromePhpHandler、FirePHPHandler
2. Processor群 - DebugProcessor、WebProcessor、RouteProcessor、TokenProcessor、SwitchUserTokenProcessor、ConsoleCommandProcessor
3. Formatter - ConsoleFormatter
4. Command - ServerLogCommand

**関連システム・外部連携**：Monologライブラリ、Symfony Console、Mailer、Notifier、Security、HttpFoundation

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログパネル | 主機能 | DebugProcessorが収集したログ情報の表示 |

## 機能種別

フレームワーク統合 / ロギング

## 入力仕様

### 入力パラメータ（ConsoleHandler）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| output | OutputInterface/null | No | コンソール出力先 | null=イベントで設定 |
| bubble | bool | No | バブリング設定 | デフォルト: true |
| verbosityLevelMap | array | No | 出力レベルマッピング | OutputInterface定数→Monolog Level |
| consoleFormatterOptions | array | No | フォーマッターオプション | - |
| interactiveOnly | bool | No | インタラクティブのみ | デフォルト: false |

### 入力データソース

Monolog LogRecord（ログメッセージ、レベル、コンテキスト、チャンネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーマット済みログ | string | ConsoleFormatter等で整形されたログ文字列 |
| デバッグログ配列 | array | DebugProcessorが蓄積したログ情報 |
| エラーカウント | int | Warning超のログ件数 |

### 出力先

- コンソール出力（ConsoleHandler）
- メール（MailerHandler）
- Notifier通知チャネル（NotifierHandler）
- Elasticsearch（ElasticsearchLogstashHandler）
- TCPサーバー（ServerLogHandler）
- ブラウザコンソール（ChromePhpHandler、FirePHPHandler）
- メモリ（DebugProcessor → Profiler）

## 処理フロー

### 処理シーケンス（ConsoleHandler）

```
1. ConsoleEvents::COMMAND イベント受信
   └─ onCommand(): Input/Output設定
2. ログ記録リクエスト
   └─ isHandling(): 出力レベルと verbosityLevelMap でハンドリング判定
3. ハンドリング判定
   └─ updateLevel(): OutputInterface::getVerbosity() に応じたレベル設定
4. ログ出力
   └─ write(): $output->write() でフォーマット済みログ出力
5. ConsoleEvents::TERMINATE イベント受信
   └─ onTerminate(): close() でoutput/input解除
```

### フローチャート

```mermaid
flowchart TD
    A[ConsoleEvents::COMMAND] --> B[onCommand: Output設定]
    B --> C[ログ記録要求]
    C --> D{updateLevel成功?}
    D -->|No output| E[ハンドリングしない]
    D -->|Yes| F{レベル判定}
    F -->|レベル不足| E
    F -->|OK| G{interactiveOnly?}
    G -->|Yes, not interactive| E
    G -->|OK| H[write: output->write]
    I[ConsoleEvents::TERMINATE] --> J[close: output解除]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | VerbosityLevel連動 | NORMAL→Warning, VERBOSE→Notice, VERY_VERBOSE→Info, DEBUG→Debug | ConsoleHandler |
| BR-02 | QUIET非出力 | VERBOSITY_SILENTの場合はログ出力しない | ConsoleHandler updateLevel() |
| BR-03 | エラー出力先 | ConsoleOutputInterfaceの場合はgetErrorOutput()を使用 | ConsoleHandler onCommand() |
| BR-04 | リクエスト別デバッグ | DebugProcessorはRequestStackのリクエストIDごとにログを分離 | DebugProcessor |
| BR-05 | エラーカウント | Warning超（Error以上）のログ数をカウント | DebugProcessor |
| BR-06 | interactiveOnly | interactiveOnly=trueの場合、非インタラクティブではバブリングをfalseに | ConsoleHandler getBubble() |

### 計算ロジック

特になし。

## データベース操作仕様

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 出力なし | OutputInterface未設定 | ConsoleEvents::COMMANDイベントを待つ |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- DebugProcessorはResetInterfaceを実装し、リクエスト間でログバッファをクリア可能

## セキュリティ考慮事項

- TokenProcessor / SwitchUserTokenProcessorはSymfony Securityのトークン情報をログに追加。機密情報が含まれる可能性があるため注意

## 備考

- ConsoleHandlerはEventSubscriberInterfaceを実装し、ConsoleEvents::COMMANDとTERMINATEイベントを購読
- FingersCrossed配下のNotFoundActivationStrategyは404エラーのみではアクティベートしない（レスポンスは正常であるため）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogRecord | Monologライブラリ | message, level, context, channel, datetimeフィールド |

**読解のコツ**: Monolog v3のLogRecordは不変のreadonlyクラス。Processorは新しいLogRecordを返す。

#### Step 2: Handler群を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConsoleHandler.php | `src/Symfony/Bridge/Monolog/Handler/ConsoleHandler.php` | verbosityLevelMap、EventSubscriber |
| 2-2 | MailerHandler.php | `src/Symfony/Bridge/Monolog/Handler/MailerHandler.php` | Mailer経由のメール通知 |
| 2-3 | NotifierHandler.php | `src/Symfony/Bridge/Monolog/Handler/NotifierHandler.php` | Notifier経由の通知 |
| 2-4 | ElasticsearchLogstashHandler.php | `src/Symfony/Bridge/Monolog/Handler/ElasticsearchLogstashHandler.php` | ES Logstash形式送信 |
| 2-5 | ServerLogHandler.php | `src/Symfony/Bridge/Monolog/Handler/ServerLogHandler.php` | TCPサーバー送信 |

**主要処理フロー（ConsoleHandler）**:
- **48-54行目**: verbosityLevelMap定義（QUIET→Error, NORMAL→Warning, VERBOSE→Notice, VERY_VERBOSE→Info, DEBUG→Debug）
- **79-86行目**: isHandling()。updateLevel() + 親クラスチェック + interactiveOnly判定
- **132-142行目**: onCommand()。Input/Output設定。ConsoleOutputInterface時はerrorOutput使用
- **160-163行目**: write()。outputのverbosityでwrite()呼び出し
- **186-201行目**: updateLevel()。outputのverbosityに応じたMonolog Level設定

#### Step 3: Processor群を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DebugProcessor.php | `src/Symfony/Bridge/Monolog/Processor/DebugProcessor.php` | デバッグログ収集、リクエスト別分離 |
| 3-2 | WebProcessor.php | `src/Symfony/Bridge/Monolog/Processor/WebProcessor.php` | リクエスト情報付加 |
| 3-3 | RouteProcessor.php | `src/Symfony/Bridge/Monolog/Processor/RouteProcessor.php` | ルーティング情報付加 |
| 3-4 | TokenProcessor.php | `src/Symfony/Bridge/Monolog/Processor/TokenProcessor.php` | Securityトークン付加 |
| 3-5 | ConsoleCommandProcessor.php | `src/Symfony/Bridge/Monolog/Processor/ConsoleCommandProcessor.php` | コンソールコマンド情報付加 |

**主要処理フロー（DebugProcessor）**:
- **32-55行目**: __invoke()。LogRecordからタイムスタンプ、メッセージ、レベル等を抽出してrecords配列に蓄積
- **34行目**: RequestStack使用時はspl_object_id($request)でリクエスト別に分離
- **50-52行目**: Warning超のログをerrorCountとしてカウント
- **57-68行目**: getLogs()。リクエスト指定時はそのリクエストのログのみ、未指定時は全ログ

### プログラム呼び出し階層図

```
Monolog Logger
    │
    ├─ Handler群
    │      ├─ ConsoleHandler
    │      │      ├─ onCommand(ConsoleCommandEvent)  [EventSubscriber]
    │      │      ├─ isHandling(LogRecord)
    │      │      │      └─ updateLevel() → verbosityLevelMap参照
    │      │      ├─ write(LogRecord)
    │      │      │      └─ OutputInterface::write()
    │      │      └─ onTerminate(ConsoleTerminateEvent)
    │      │
    │      ├─ MailerHandler
    │      │      └─ MailerInterface::send()
    │      ├─ NotifierHandler
    │      │      └─ NotifierInterface::send()
    │      └─ ElasticsearchLogstashHandler
    │             └─ Elasticsearch Bulk API
    │
    └─ Processor群
           ├─ DebugProcessor::__invoke(LogRecord)
           │      └─ records[]に蓄積 → DebugLoggerInterface::getLogs()
           ├─ WebProcessor::__invoke(LogRecord)
           ├─ RouteProcessor::__invoke(LogRecord)
           ├─ TokenProcessor::__invoke(LogRecord)
           └─ ConsoleCommandProcessor::__invoke(LogRecord)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

LogRecord         ───▶  Processor群                  ───▶  エンリッチされたLogRecord
(message, level)        (DebugProcessor, WebProcessor)

LogRecord         ───▶  Handler群                    ───▶  各種出力先
                        ├─ ConsoleHandler             ───▶  Console Output
                        ├─ MailerHandler              ───▶  メール
                        ├─ NotifierHandler            ───▶  通知チャネル
                        └─ ElasticsearchLogstashHandler ───▶  Elasticsearch
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ConsoleHandler.php | `src/Symfony/Bridge/Monolog/Handler/ConsoleHandler.php` | ソース | コンソール出力ハンドラー |
| MailerHandler.php | `src/Symfony/Bridge/Monolog/Handler/MailerHandler.php` | ソース | メール通知ハンドラー |
| NotifierHandler.php | `src/Symfony/Bridge/Monolog/Handler/NotifierHandler.php` | ソース | Notifier連携ハンドラー |
| ElasticsearchLogstashHandler.php | `src/Symfony/Bridge/Monolog/Handler/ElasticsearchLogstashHandler.php` | ソース | ES送信ハンドラー |
| ServerLogHandler.php | `src/Symfony/Bridge/Monolog/Handler/ServerLogHandler.php` | ソース | TCPサーバーハンドラー |
| ChromePhpHandler.php | `src/Symfony/Bridge/Monolog/Handler/ChromePhpHandler.php` | ソース | ChromePhpハンドラー |
| FirePHPHandler.php | `src/Symfony/Bridge/Monolog/Handler/FirePHPHandler.php` | ソース | FirePHPハンドラー |
| DebugProcessor.php | `src/Symfony/Bridge/Monolog/Processor/DebugProcessor.php` | ソース | デバッグログ収集 |
| WebProcessor.php | `src/Symfony/Bridge/Monolog/Processor/WebProcessor.php` | ソース | リクエスト情報付加 |
| RouteProcessor.php | `src/Symfony/Bridge/Monolog/Processor/RouteProcessor.php` | ソース | ルート情報付加 |
| TokenProcessor.php | `src/Symfony/Bridge/Monolog/Processor/TokenProcessor.php` | ソース | トークン情報付加 |
| SwitchUserTokenProcessor.php | `src/Symfony/Bridge/Monolog/Processor/SwitchUserTokenProcessor.php` | ソース | SwitchUserトークン |
| ConsoleCommandProcessor.php | `src/Symfony/Bridge/Monolog/Processor/ConsoleCommandProcessor.php` | ソース | コマンド情報付加 |
| ConsoleFormatter.php | `src/Symfony/Bridge/Monolog/Formatter/ConsoleFormatter.php` | ソース | コンソール用フォーマッター |
