# 機能設計書 7-CssSelector

## 概要

本ドキュメントは、Symfony CssSelectorコンポーネントの機能設計を記述する。CssSelectorはCSSセレクタをXPath式に変換する機能を提供し、DomCrawlerコンポーネントと連携して使用される。

### 本機能の処理概要

CssSelectorコンポーネントは、CSSセレクタ構文をW3Cで定義されたXPath式に変換するトランスレーターを提供する。CSSセレクタの解析（パーサー）、抽象構文木（AST）の構築、XPath式への変換（トランスレーター）の3段階処理で実現される。

**業務上の目的・背景**：XPath式は強力だが記述が冗長になりがちである。CSSセレクタはWeb開発者にとって馴染み深く、より簡潔に要素を指定できる。CssSelectorはCSS記法でXPath操作を行えるようにするブリッジとして機能する。

**機能の利用シーン**：DomCrawlerコンポーネントでのHTML要素選択、テストコードでのCSSセレクタによるDOM検証、スクレイピング等で利用される。Crawler::filter()メソッドの内部でCssSelectorConverterが呼び出される。

**主要な処理内容**：
1. CSSセレクタ文字列の字句解析（トークナイズ）
2. トークンからのAST（抽象構文木）構築
3. ASTからXPath式への変換
4. HTML拡張（HTML固有の擬似セレクタ対応）
5. ショートカットパーサー（クラス、ID、要素名の高速パース）
6. 変換結果のキャッシュ

**関連システム・外部連携**：DomCrawler（Crawler::filter()メソッドで利用）

**権限による制御**：権限制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|

CssSelectorは画面機能マッピングに直接関連する画面がない。

## 機能種別

構文変換 / パーサー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cssExpr | string | Yes | CSSセレクタ式 | 有効なCSS構文 |
| prefix | string | No | XPath式のプレフィックス（デフォルト: 'descendant-or-self::'） | 有効なXPath軸 |
| html | bool | No | HTMLモードの有効化（デフォルト: true） | - |

### 入力データソース

- CSSセレクタ文字列（開発者が記述）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| xpathExpr | string | 変換されたXPath式 |

### 出力先

- 文字列として返却

## 処理フロー

### 処理シーケンス

```
1. CssSelectorConverter::toXPath()呼び出し
   └─ キャッシュ確認（同一セレクタ+プレフィックスの結果がキャッシュにあるか）
2. Translator::cssToXPath()呼び出し
   └─ CSSセレクタ文字列をパーサーに渡す
3. パーサーによるAST構築
   └─ ショートカットパーサー（Element, Class, Hash, EmptyString）を優先的に試行
   └─ 一般パーサーで完全な構文解析
4. ASTからXPath式への変換
   └─ Translatorがノード種別に応じてXPath式を組み立て
5. キャッシュ保存・結果返却
```

### フローチャート

```mermaid
flowchart TD
    A[CSSセレクタ入力] --> B{キャッシュあり?}
    B -->|Yes| C[キャッシュ返却]
    B -->|No| D[ショートカットパーサー試行]
    D --> E{マッチ?}
    E -->|Yes| F[AST生成]
    E -->|No| G[一般パーサーで解析]
    G --> F
    F --> H[Translatorで変換]
    H --> I[XPath式生成]
    I --> J[キャッシュ保存]
    J --> K[XPath式返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | HTMLモード | HTMLモード有効時はHTML固有の擬似セレクタ（:checked等）がサポートされる | html=true（デフォルト） |
| BR-02 | キャッシュ分離 | HTMLモードとXMLモードでキャッシュが分離されている | 常時 |
| BR-03 | ショートカット優先 | 単純なセレクタ（要素名、クラス、ID、空文字列）はショートカットパーサーで高速処理 | 対応パターン時 |
| BR-04 | デフォルトプレフィックス | プレフィックス未指定時はdescendant-or-self::が使用される | prefix未指定時 |

### 計算ロジック

- CSSセレクタからXPath式への変換規則はW3C CSS Selectors仕様に準拠

## データベース操作仕様

CssSelectorコンポーネントはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SyntaxErrorException | CSSセレクタの構文エラー | セレクタ構文の確認 |
| - | ExpressionErrorException | 式評価時のエラー | 式の妥当性確認 |
| - | InternalErrorException | 内部処理エラー | バグレポート |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- CSSセレクタの変換結果はstaticプロパティでキャッシュされ、同一プロセス内で再利用される
- ショートカットパーサーにより、単純なセレクタは正規表現ベースで高速変換

## セキュリティ考慮事項

- 入力はCSSセレクタ文字列のみであり、セキュリティリスクは低い

## 備考

- CSS Selectors Level 3の主要なセレクタをサポート
- 擬似要素（::before等）は未サポート（XPathで表現不可能なため）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Node/ | `src/Symfony/Component/CssSelector/Node/` | AST（抽象構文木）のノード型定義 |

**読解のコツ**: Nodeディレクトリ内のクラスがCSSセレクタの構文要素（Selector, CombinedSelector, Class, Hash, Pseudo, Attribute等）を表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CssSelectorConverter.php | `src/Symfony/Component/CssSelector/CssSelectorConverter.php` | 公開APIのエントリーポイント |

**主要処理フロー**:
1. **38-55行目**: コンストラクタ。Translatorの初期化、HTML拡張の登録、ショートカットパーサーの登録
2. **63-66行目**: toXPath()メソッド。キャッシュ確認→Translator::cssToXPath()呼び出し
3. **32-33行目**: staticキャッシュ（xmlCache, htmlCache）の定義

#### Step 3: パーサーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Parser/ | `src/Symfony/Component/CssSelector/Parser/` | CSSセレクタのパーサー群 |
| 3-2 | Parser/Shortcut/ | `src/Symfony/Component/CssSelector/Parser/Shortcut/` | ショートカットパーサー群（ClassParser, ElementParser, HashParser, EmptyStringParser） |

#### Step 4: XPath変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | XPath/Translator.php | `src/Symfony/Component/CssSelector/XPath/Translator.php` | ASTからXPath式への変換エンジン |
| 4-2 | XPath/Extension/ | `src/Symfony/Component/CssSelector/XPath/Extension/` | XPath変換拡張（HtmlExtension含む） |

### プログラム呼び出し階層図

```
CssSelectorConverter::toXPath(cssExpr, prefix)
    |
    +-- [キャッシュヒット] return cache[prefix][cssExpr]
    |
    +-- Translator::cssToXPath(cssExpr, prefix)
            |
            +-- [ショートカットパーサー試行]
            |       +-- EmptyStringParser::parse(cssExpr)
            |       +-- ElementParser::parse(cssExpr)
            |       +-- ClassParser::parse(cssExpr)
            |       +-- HashParser::parse(cssExpr)
            |
            +-- [一般パーサー]
            |       +-- Parser::parse(cssExpr)
            |               +-- Tokenizer::tokenize()
            |               +-- Token列からAST構築
            |
            +-- [AST -> XPath変換]
                    +-- Translator::selectorToXPath(selector)
                            +-- Extension/NodeExtension
                            +-- Extension/HtmlExtension (HTMLモード時)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

CSSセレクタ文字列      --->  Parser/Shortcut or Parser    --->  AST (Node群)
 "div.class > p"               |
                              v
                     Translator::selectorToXPath() --->  XPath式文字列
                              |                          "descendant-or-self::div
                              v                           [contains(...)]/p"
                     キャッシュ保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CssSelectorConverter.php | `src/Symfony/Component/CssSelector/CssSelectorConverter.php` | ソース | 公開APIエントリーポイント |
| Node/ | `src/Symfony/Component/CssSelector/Node/` | ソース | ASTノード型定義 |
| Parser/ | `src/Symfony/Component/CssSelector/Parser/` | ソース | CSSパーサー |
| Parser/Shortcut/ | `src/Symfony/Component/CssSelector/Parser/Shortcut/` | ソース | ショートカットパーサー群 |
| XPath/ | `src/Symfony/Component/CssSelector/XPath/` | ソース | XPath変換エンジン |
| XPath/Extension/ | `src/Symfony/Component/CssSelector/XPath/Extension/` | ソース | XPath変換拡張 |
| Exception/ | `src/Symfony/Component/CssSelector/Exception/` | ソース | 例外クラス群 |
