# 機能設計書 9-FrameworkBundle

## 概要

本ドキュメントは、Symfony FrameworkBundleの機能設計を記述する。FrameworkBundleはSymfonyコンポーネントとフルスタックフレームワークの統合基盤を提供し、アプリケーションのブートストラップ、サービス登録、設定管理等を統括する。

### 本機能の処理概要

FrameworkBundleは、Symfonyの各コンポーネント（HttpFoundation、HttpKernel、Routing、DependencyInjection、EventDispatcher等）をフルスタックフレームワークとして統合する中核バンドルである。DIコンテナへのサービス登録、設定の解決、コンパイラパスの追加、コマンドの登録等を通じて、アプリケーション全体の基盤を構築する。

**業務上の目的・背景**：個別のSymfonyコンポーネントを手動で組み立てることは複雑であり、設定の一貫性確保も困難である。FrameworkBundleはこれらのコンポーネントの統合を自動化し、開発者が設定ファイル（YAML/XML/PHP）で宣言的にフレームワークの動作を制御できるようにする。

**機能の利用シーン**：Symfonyフルスタックフレームワークを使用するすべてのアプリケーションで利用される。アプリケーションの起動時にバンドルが読み込まれ、サービスコンテナの構築に関与する。また、TemplateController（テンプレート表示）、RedirectController（リダイレクト）等の標準コントローラーも提供する。

**主要な処理内容**：
1. DIコンテナへのSymfonyサービス群の登録
2. 設定ファイルからの設定値解決とバリデーション
3. コンパイラパスの登録（ProfilerPass、各種コンポーネント統合パス）
4. コンソールコマンドの登録
5. TemplateController / RedirectController等の標準コントローラー提供
6. キャッシュウォーミング
7. テスト用サービスコンテナの構築
8. ルーティング統合
9. シークレット管理

**関連システム・外部連携**：すべてのSymfonyコンポーネント（Cache、Console、EventDispatcher、Form、HttpClient、Messenger、Routing、Security、Serializer、Translation、Validator等）のDI統合を担当する。

**権限による制御**：直接的な権限制御はないが、SecurityBundleとの連携によりセキュリティ設定がDIコンテナを通じて統合される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 設定パネル | 主機能 | FrameworkBundleの設定情報（Symfonyバージョン、PHPバージョン、環境名等）の表示 |
| 41 | テンプレート表示 | 主機能 | TemplateControllerによる任意のTwigテンプレートのレンダリング |
| 42 | リダイレクト | 主機能 | RedirectControllerによるルートまたはURLへのリダイレクト処理 |

## 機能種別

フレームワーク基盤 / DI統合 / サービス登録

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| framework設定 | array | No | framework.yaml等のフレームワーク設定 | Configuration Treeノードによるバリデーション |

### 入力データソース

- 設定ファイル（config/packages/framework.yaml等）
- 環境変数
- バンドル登録（config/bundles.php）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| containerBuilder | ContainerBuilder | 設定済みのDIコンテナビルダー |
| services | array | 登録されたサービス定義群 |

### 出力先

- DIコンテナ（コンパイル済みPHPクラスとしてキャッシュ）

## 処理フロー

### 処理シーケンス

```
1. FrameworkBundle::build()
   └─ コンパイラパスの登録
2. FrameworkExtension::load()
   └─ 設定ファイルの読み込みとサービス定義の登録
3. コンパイラパスの実行
   └─ 各パスによるサービス定義の加工・最適化
4. コンテナのコンパイル
   └─ サービスの解決、パラメータの埋め込み
5. コンテナのダンプ
   └─ PHPクラスとしてキャッシュに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[Kernel::boot] --> B[FrameworkBundle::build]
    B --> C[コンパイラパス登録]
    C --> D[FrameworkExtension::load]
    D --> E[設定ファイル読み込み]
    E --> F[サービス定義登録]
    F --> G[コンパイラパス実行]
    G --> H[コンテナコンパイル]
    H --> I[PHPクラスダンプ]
    I --> J[キャッシュ保存]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | コンパイラパス優先順序 | コンパイラパスはPassConfig::TYPE_BEFORE_OPTIMIZATION等の優先度に従って実行される | コンテナコンパイル時 |
| BR-02 | 環境別設定 | dev/prod/test等の環境に応じて設定が分離される | 環境変数APP_ENV |
| BR-03 | デバッグモード | debug=trueの場合、追加のデバッグサービス（プロファイラー等）が有効化される | Kernel::$debug |
| BR-04 | 自動ワイヤリング | デフォルトでサービスの自動ワイヤリングが有効 | framework.yaml設定 |

### 計算ロジック

特になし。

## データベース操作仕様

FrameworkBundle自体はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidConfigurationException | 設定値が不正 | framework.yaml設定の確認 |
| - | ServiceNotFoundException | 存在しないサービスの参照 | サービス定義の確認 |
| - | LogicException | 必要な拡張が不足 | composer requireで依存追加 |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- コンパイル済みコンテナをPHPクラスとしてキャッシュし、リクエストごとの再ビルドを回避
- キャッシュウォーマーにより、初回リクエスト前にキャッシュを事前構築可能

## セキュリティ考慮事項

- シークレット管理機能（Secrets/）で機密設定値を安全に管理
- テスト用サービスコンテナは本番環境では無効化される
- BinaryFileResponse::trustXSendfileTypeHeader()の信頼設定

## 備考

- 80以上のコンパイラパスを登録し、各Symfonyコンポーネントとの統合を実現
- JsonStreamer、ObjectMapper等の新しいコンポーネントの統合も含む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FrameworkBundle.php | `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php` | バンドルのメインクラス。build()メソッドでコンパイラパスを登録 |

**読解のコツ**: FrameworkBundle.phpのuse文（行14-80）を見ると、このバンドルが統合する全コンポーネントが把握できる。AddConsoleCommandPass、RegisterListenersPass、FormPass等、各コンポーネントのDI統合パスが列挙されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FrameworkBundle.php | `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php` | build()メソッドでのコンパイラパス登録 |

**主要処理フロー**:
- **行14-80**: useステートメント群 - 統合対象コンポーネントのコンパイラパスをインポート
- build()メソッド: ContainerBuilderに各コンパイラパスを追加

#### Step 3: DI拡張を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DependencyInjection/FrameworkExtension.php | `src/Symfony/Bundle/FrameworkBundle/DependencyInjection/FrameworkExtension.php` | フレームワーク設定の読み込みとサービス定義 |
| 3-2 | DependencyInjection/Configuration.php | `src/Symfony/Bundle/FrameworkBundle/DependencyInjection/Configuration.php` | 設定ツリーノード定義（バリデーション） |

#### Step 4: 標準コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Controller/TemplateController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` | 静的テンプレートのレンダリング |
| 4-2 | Controller/RedirectController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` | リダイレクト処理 |

### プログラム呼び出し階層図

```
Kernel::boot()
    |
    +-- Kernel::initializeBundles()
    |       +-- FrameworkBundle
    |
    +-- Kernel::initializeContainer()
            |
            +-- ContainerBuilder::registerExtension(FrameworkExtension)
            |
            +-- FrameworkBundle::build(ContainerBuilder)
            |       |
            |       +-- addCompilerPass(ProfilerPass)
            |       +-- addCompilerPass(AddConsoleCommandPass)
            |       +-- addCompilerPass(RegisterListenersPass)
            |       +-- addCompilerPass(FormPass)
            |       +-- ... [80+ コンパイラパス]
            |
            +-- FrameworkExtension::load(configs, ContainerBuilder)
            |       +-- [設定ファイルの読み込み]
            |       +-- [サービス定義の登録]
            |
            +-- ContainerBuilder::compile()
            |
            +-- PhpDumper::dump()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

framework.yaml         --->  FrameworkExtension::load()    --->  サービス定義群
config/services.yaml          |
config/bundles.php            v
                     ContainerBuilder::compile()    --->  コンパイル済みContainer
                              |
                              v
                     PhpDumper::dump()               --->  var/cache/Container*.php
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FrameworkBundle.php | `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php` | ソース | バンドルメインクラス |
| DependencyInjection/FrameworkExtension.php | `src/Symfony/Bundle/FrameworkBundle/DependencyInjection/FrameworkExtension.php` | ソース | DI拡張（設定読み込み・サービス登録） |
| DependencyInjection/Configuration.php | `src/Symfony/Bundle/FrameworkBundle/DependencyInjection/Configuration.php` | ソース | 設定ツリー定義 |
| DependencyInjection/Compiler/ | `src/Symfony/Bundle/FrameworkBundle/DependencyInjection/Compiler/` | ソース | コンパイラパス群 |
| Controller/TemplateController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` | ソース | テンプレート表示コントローラー |
| Controller/RedirectController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` | ソース | リダイレクトコントローラー |
| Command/ | `src/Symfony/Bundle/FrameworkBundle/Command/` | ソース | コンソールコマンド群 |
| Console/ | `src/Symfony/Bundle/FrameworkBundle/Console/` | ソース | コンソールアプリケーション |
| DataCollector/ | `src/Symfony/Bundle/FrameworkBundle/DataCollector/` | ソース | データコレクター |
| EventListener/ | `src/Symfony/Bundle/FrameworkBundle/EventListener/` | ソース | イベントリスナー |
| Kernel/ | `src/Symfony/Bundle/FrameworkBundle/Kernel/` | ソース | マイクロカーネル |
| Routing/ | `src/Symfony/Bundle/FrameworkBundle/Routing/` | ソース | ルーティング統合 |
| Secrets/ | `src/Symfony/Bundle/FrameworkBundle/Secrets/` | ソース | シークレット管理 |
| Translation/ | `src/Symfony/Bundle/FrameworkBundle/Translation/` | ソース | 翻訳統合 |
| CacheWarmer/ | `src/Symfony/Bundle/FrameworkBundle/CacheWarmer/` | ソース | キャッシュウォーマー |
| ErrorHandler/ | `src/Symfony/Bundle/FrameworkBundle/ErrorHandler/` | ソース | エラーハンドラー統合 |
| HttpCache/ | `src/Symfony/Bundle/FrameworkBundle/HttpCache/` | ソース | HTTPキャッシュ統合 |
| KernelBrowser.php | `src/Symfony/Bundle/FrameworkBundle/KernelBrowser.php` | ソース | テスト用カーネルブラウザ |
| Test/ | `src/Symfony/Bundle/FrameworkBundle/Test/` | ソース | テストユーティリティ |
| Resources/ | `src/Symfony/Bundle/FrameworkBundle/Resources/` | 設定 | サービス定義XML、設定スキーマ |
