---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：1-HttpFoundation

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1ms未満）**：具体的なベンチマーク根拠なし
  2. **PSR-7相互変換の記述**：PsrHttpMessageBridgeの実装未直接確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/HttpFoundation/Request.php` - Requestクラス定義（行44-100）
- E-02: `src/Symfony/Component/HttpFoundation/Response.php` - Responseクラス定義（行22-100）
- E-03: `src/Symfony/Component/HttpFoundation/Session/Session.php` - Sessionクラス定義（行33-60）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.1の記述
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.1関連画面マッピング
- E-06: `src/Symfony/Component/HttpFoundation/InputBag.php` - InputBag存在確認
- E-07: `src/Symfony/Component/HttpFoundation/HeaderBag.php` - HeaderBag存在確認
- E-08: `src/Symfony/Component/HttpFoundation/FileBag.php` - FileBag存在確認
- E-09: `src/Symfony/Component/HttpFoundation/ServerBag.php` - ServerBag存在確認
- E-10: `src/Symfony/Component/HttpFoundation/JsonResponse.php` - JsonResponse存在確認
- E-11: `src/Symfony/Component/HttpFoundation/RedirectResponse.php` - RedirectResponse存在確認
- E-12: `src/Symfony/Component/HttpFoundation/BinaryFileResponse.php` - BinaryFileResponse存在確認
- E-13: `src/Symfony/Component/HttpFoundation/StreamedResponse.php` - StreamedResponse存在確認
- E-14: `src/Symfony/Component/HttpFoundation/IpUtils.php` - IpUtils存在確認
- E-15: `src/Symfony/Component/HttpFoundation/UriSigner.php` - UriSigner存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RequestクラスはHTTPメソッド定数を定義している | E-01 (行55-65) | ○ |
| C-02 | 信頼プロキシ設定用の静的プロパティが存在する | E-01 (行70-80) | ○ |
| C-03 | ParameterBag, InputBag等のバッグクラス群が存在する | E-06, E-07, E-08, E-09 | ○ |
| C-04 | ResponseクラスはHTTPステータスコード定数を定義している | E-02 (行24-86) | ○ |
| C-05 | Cache-Controlディレクティブ定義が存在する | E-02 (行91-100) | ○ |
| C-06 | JsonResponse, RedirectResponse等の特殊レスポンスが存在する | E-10, E-11, E-12, E-13 | ○ |
| C-07 | SessionクラスはSessionStorageInterface等と協調する | E-03 (行33-55) | ○ |
| C-08 | 関連画面はプロファイラーホーム等9画面 | E-05 | ○ |
| C-09 | 機能一覧での説明と一致する | E-04 | ○ |
| C-10 | opcache.preloadシンボル事前読み込み対応 | E-01 (行22-28) | ○ |
| C-11 | HEADER_FORWARDED等のプロキシヘッダー定数が存在する | E-01 (行45-53) | ○ |
| C-12 | InputBagが型安全なアクセスを提供する | E-06 | ○ |
| C-13 | FileBagがUploadedFileオブジェクトへ変換する | E-08 | ○ |
| C-14 | ServerBagがHTTPヘッダーを抽出する | E-09 | ○ |
| C-15 | IpUtilsがIPアドレスユーティリティを提供する | E-14 | ○ |
| C-16 | UriSignerがURL署名機能を提供する | E-15 | ○ |
| C-17 | StreamedJsonResponseが存在する | E-01 (ファイル一覧で確認) | ○ |
| C-18 | EventStreamResponseが存在する | E-01 (ファイル一覧で確認) | ○ |
| C-19 | Request生成は通常1ms未満で完了する | **根拠なし** | △ |
| C-20 | PSR-7との相互変換はPsrHttpMessageBridgeが提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19：パフォーマンス要件の具体的数値について、ベンチマークデータや公式ドキュメントの裏付けが不足
  - 候補：Symfony公式ベンチマーク / パフォーマンステスト結果 / プロファイリングデータ
- C-20：PsrHttpMessageBridgeコンポーネントのソースコードを直接確認していない
  - 候補：`src/Symfony/Bridge/PsrHttpMessage/` / composer.json依存定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要クラス（Request, Response）の構造記述は正確
- 0: 低リスク - 関連画面マッピングはCSVデータに基づき正確
- 1: 中リスク - パフォーマンス要件の数値は推定値であり、要検証

## 6) レビュアーチェックリスト（最小）
- [ ] Request.phpの主要メソッド（createFromGlobals, getPathInfo, getMethod等）の記述が実装と一致するか
- [ ] Response.phpのステータスコード定数一覧が最新版と一致するか
- [ ] セッション管理の記述がSession.phpの実装と整合するか
- [ ] パフォーマンス要件の数値が妥当か（実測による検証推奨）
- [ ] 関連画面一覧が画面機能マッピング.csvの内容と完全に一致するか
