---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-EventDispatcher 機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **PSR-14準拠の詳細**：PSR-14との互換性の正確な範囲

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/EventDispatcher/EventDispatcher.php`
- E-02: `src/Symfony/Component/EventDispatcher/EventDispatcherInterface.php`
- E-03: `src/Symfony/Component/EventDispatcher/EventSubscriberInterface.php`
- E-04: `src/Symfony/Component/EventDispatcher/GenericEvent.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.12行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.19行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントのディスパッチとリスニングによるコンポーネント間通信を提供 | E-05 | ○ |
| C-02 | PSR-14準拠 | E-02 (14行目: ContractsEventDispatcherInterface) | ○ |
| C-03 | dispatchでeventNameがnullの場合、event::classを使用 | E-01 (47行目) | ○ |
| C-04 | optimized配列による最適化 | E-01 (36, 49-50行目) | ○ |
| C-05 | callListenersでStoppableEvent対応 | E-01 (200-203行目) | ○ |
| C-06 | krsortによる優先度降順ソート | E-01 (215行目) | ○ |
| C-07 | addListenerで優先度付き登録 | E-01 (126-130行目) | ○ |
| C-08 | addSubscriberの3パターン対応 | E-01 (160-173行目), E-03 (27-48行目) | ○ |
| C-09 | Closureベースの遅延解決 | E-01 (220-223, 240-247行目) | ○ |
| C-10 | sorted/optimizedキャッシュの無効化 | E-01 (129行目) | ○ |
| C-11 | GenericEventのArrayAccess/IteratorAggregate実装 | E-04 (26行目) | ○ |
| C-12 | GenericEventのsubject+arguments構造 | E-04 (34-38行目) | ○ |
| C-13 | リスナー実行時に3引数（event, eventName, dispatcher）を渡す | E-01 (206行目) | ○ |
| C-14 | removeListenerでClosure解決しながら比較 | E-01 (132-158行目) | ○ |
| C-15 | イベントパネル（画面No.19）との関連 | E-06 | ○ |
| C-16 | hasListenersで登録チェック | E-01 (111-124行目) | ○ |
| C-17 | コンストラクタでoptimized配列の初期化条件 | E-01 (38-43行目) | ○ |
| C-18 | PSR-14との互換性の正確な範囲 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PSR-14との互換性の正確な範囲について、Contracts側のインターフェース定義の確認が必要
  - 候補：`vendor/symfony/event-dispatcher-contracts/` / PSR-14仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - dispatch処理フローの記述はソースコードと整合
- 0: 低リスク - コードリーディングガイドの行番号はソースコードと一致
- 0: 低リスク - addSubscriberの3パターン対応はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] optimizeListenersのClosure遅延解決ロジックが正確に記述されているか確認
- [ ] StoppableEventInterfaceの伝搬停止タイミングが正確か確認
- [ ] addSubscriberの3パターン（文字列、[文字列,優先度]、[[文字列,優先度]...]）が正確か確認
