---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ExpressionLanguage 機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全主張に根拠あり。軽微な確認のみ。

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/ExpressionLanguage/ExpressionLanguage.php`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.16行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 式のコンパイルと評価が可能なエンジン | E-02 | ○ |
| C-02 | PSR-6キャッシュ対応 | E-01 (14, 27, 39行目) | ○ |
| C-03 | デフォルトでArrayAdapterを使用 | E-01 (39行目) | ○ |
| C-04 | compile()でparse→compile→getSourceのチェーン | E-01 (49-52行目) | ○ |
| C-05 | evaluate()でparse→evaluate | E-01 (57-60行目) | ○ |
| C-06 | parse()のキャッシュキー構築 | E-01 (73-80行目) | ○ |
| C-07 | parse()のキャッシュチェック・保存 | E-01 (82-88行目) | ○ |
| C-08 | register()のparser生成後ガード | E-01 (122-124行目) | ○ |
| C-09 | 組み込み関数: constant, min, max | E-01 (143-146行目) | ○ |
| C-10 | enum関数のUnitEnum制約 | E-01 (148-159行目) | ○ |
| C-11 | addFunction/registerProvider | E-01 (129-139行目) | ○ |
| C-12 | lint()による構文検証 | E-01 (101-108行目) | ○ |
| C-13 | 遅延的なLexer/Parser/Compiler生成 | E-01 (162-177行目) | ○ |
| C-14 | Compiler::reset()でcompile前にリセット | E-01 (176行目) | ○ |
| C-15 | ParsedExpressionのそのまま返却 | E-01 (69-71行目) | ○ |
| C-16 | names配列のソート（キャッシュキー正規化） | E-01 (73行目) | ○ |
| C-17 | ExpressionFunctionProviderInterfaceによるプロバイダーパターン | E-01 (37, 41-43行目) | ○ |
| C-18 | fromPhpによるPHP関数のラップ | E-01 (145行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ExpressionLanguageコンポーネントの主要クラスを網羅的に確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと整合
- 0: 低リスク - 行番号参照もすべて正確

## 6) レビュアーチェックリスト（最小）
- [ ] parse()のキャッシュキー構築ロジックが正確か確認
- [ ] enum関数のevaluatorとcompilerの実装が正確に記述されているか確認
- [ ] Lexer/Parser/Compilerの遅延生成パターンが正確か確認
