---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 7
  claims_without_evidence: 5
confidence_derived: 0.58
---

# 根拠レポート：17-Runtime 機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.58**
  - 根拠あり：7 / 12、根拠なし：5
- 優先レビュー（高）
  1. **Runtimeの内部実装詳細**：ソースコードが本プロジェクトに含まれていない
  2. **RuntimeInterface/RunnerInterfaceの詳細仕様**：インターフェース定義の確認不可
  3. **autoload_runtime.phpの動作仕様**：ファイルが未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.17行）
- E-02: `composer.json`（symfony/runtime依存参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アプリケーションランタイムの抽象化を提供 | E-01 | ○ |
| C-02 | PHP-FPM、CLI、Swoole等の異なるランタイム環境に対応 | E-01 | ○ |
| C-03 | Composerオートローダーとの統合 | E-01 | ○ |
| C-04 | composer.jsonにsymfony/runtimeの依存あり | E-02 | ○ |
| C-05 | ソースコードが本プロジェクトに含まれていない | ファイル検索結果 | ○ |
| C-06 | RuntimeInterface(getResolver/getRunner)の仕様 | **根拠なし** | △ |
| C-07 | RunnerInterface(run)の仕様 | **根拠なし** | △ |
| C-08 | autoload_runtime.phpの動作 | **根拠なし** | △ |
| C-09 | GenericRuntimeが標準実装 | **根拠なし** | △ |
| C-10 | SymfonyRuntimeがFrameworkBundleで拡張 | **根拠なし** | △ |
| C-11 | アプリケーション型推論によるRunner選択 | E-01 | ○ |
| C-12 | composer.json extraセクションでの設定 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- Runtimeコンポーネントのソースコードが本プロジェクトのソースツリーに含まれていないため、内部実装の詳細確認ができない
  - 候補：`vendor/symfony/runtime/`（インストール時に存在する可能性） / Symfony公式ドキュメント / GitHubリポジトリ
- autoload_runtime.phpの動作仕様はComposerのplugin機構を通じて提供される
  - 候補：`vendor/autoload_runtime.php` / Composerドキュメント

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - ソースコードが利用不可のため、多くの主張が一般的なSymfony知識に基づく
- 1: 中リスク - インターフェース定義の詳細が未確認
- 0: 低リスク - 機能一覧からの概要情報は正確

## 6) レビュアーチェックリスト（最小）
- [ ] vendor/symfony/runtime/が存在する場合、ソースコードとの整合性を確認
- [ ] RuntimeInterface/RunnerInterfaceの実際のメソッドシグネチャを確認
- [ ] autoload_runtime.phpの実際の動作を確認
- [ ] GenericRuntime/SymfonyRuntimeの存在と役割を確認
