---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-HttpKernel

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Profilerのストレージバックエンド記述**：具体的なストレージ実装未確認
  2. **SecurityコンポーネントのFirewall連携**：間接的な関係であり、直接のコード参照なし
  3. **handleAllThrowablesのデフォルト値**：コンストラクタの確認で根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/HttpKernel/HttpKernel.php` - HttpKernelクラス（行55-199）
- E-02: `src/Symfony/Component/HttpKernel/KernelEvents.php` - カーネルイベント定数（行28-128）
- E-03: `src/Symfony/Component/HttpKernel/Kernel.php` - Kernel基底クラス（行53-100）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.2
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.2関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | handle()がRequestStackにpush/popする | E-01 (行76, 96) | ○ |
| C-02 | handleRaw()がkernel.requestイベントをディスパッチする | E-01 (行161-162) | ○ |
| C-03 | ControllerResolver::getController()が呼ばれる | E-01 (行169) | ○ |
| C-04 | kernel.controllerイベントがディスパッチされる | E-01 (行175) | ○ |
| C-05 | ArgumentResolver::getArguments()が呼ばれる | E-01 (行179) | ○ |
| C-06 | kernel.controller_argumentsイベントがディスパッチされる | E-01 (行183) | ○ |
| C-07 | コントローラーがResponseを返さない場合kernel.viewがディスパッチされる | E-01 (行191-193) | ○ |
| C-08 | KernelEventsに7つのイベント定数が定義されている | E-02 (行39-111) | ○ |
| C-09 | Kernel.phpのバージョンが8.1.0-DEV | E-03 (行75) | ○ |
| C-10 | handleAllThrowablesがコンストラクタで設定される | E-01 (行66) | ○ |
| C-11 | RequestExceptionInterfaceがBadRequestHttpExceptionにラップされる | E-01 (行85-86) | ○ |
| C-12 | terminateメソッドがkernel.terminateをディスパッチする | E-01 (行113-121) | ○ |
| C-13 | StreamedResponseの遅延実行が実装されている | E-01 (行98-109) | ○ |
| C-14 | NotFoundHttpExceptionがコントローラー未発見時にスローされる | E-01 (行170) | ○ |
| C-15 | 関連画面が14画面ある | E-05 | ○ |
| C-16 | END_OF_MAINTENANCE/END_OF_LIFEが01/2027 | E-03 (行82-83) | ○ |
| C-17 | ALIASESプロパティでイベントクラスからイベント名への逆引きが可能 | E-02 (行118-127) | ○ |
| C-18 | ProfilerのストレージがファイルシステムまたはDBにアクセスする | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18：Profilerのストレージ実装詳細を直接確認していない
  - 候補：`src/Symfony/Component/HttpKernel/Profiler/Profiler.php` / `FileProfilerStorage.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント駆動パイプラインの記述はコードに忠実
- 0: 低リスク - カーネルイベントの順序はKernelEvents.phpとHttpKernel.phpで確認済み
- 1: 中リスク - Profilerストレージの詳細は推定

## 6) レビュアーチェックリスト（最小）
- [ ] HttpKernel::handleRaw()の処理順序がフローチャートと一致するか
- [ ] KernelEventsの定数が最新のソースと一致するか
- [ ] 関連画面一覧が画面機能マッピング.csvと完全一致するか
- [ ] Kernel.phpのバージョン情報が最新か
