---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：23-SecurityBundle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **DI拡張の設定ツリー構造**：SecurityExtensionの詳細な設定パラメータは未検証

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/SecurityBundle/Security.php` - Securityクラス
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `src/Symfony/Bundle/SecurityBundle/SecurityBundle.php` - バンドル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityクラスはAuthorizationCheckerInterfaceとUserAuthorizationCheckerInterfaceを実装 | E-01 (42行目) | ○ |
| C-02 | getUser()でトークンストレージからユーザー取得 | E-01 (50-57行目) | ○ |
| C-03 | isGranted()でauthorization_checkerに委任 | E-01 (62-66行目) | ○ |
| C-04 | isGrantedForUser()でuser_authorization_checkerに委任 | E-01 (81-85行目) | ○ |
| C-05 | login()でファイアウォール特定・認証器取得・authenticateUser | E-01 (114-133行目) | ○ |
| C-06 | logout()でCSRF検証・LogoutEvent・トークン削除 | E-01 (144-178行目) | ○ |
| C-07 | login時にリクエストコンテキストが必要 | E-01 (117-119行目) | ○ |
| C-08 | ファイアウォール配下にない場合LogicException | E-01 (123-125行目) | ○ |
| C-09 | 複数認証器で名前未指定時LogicException | E-01 (194-196行目) | ○ |
| C-10 | CSRFトークン検証失敗時LogoutException | E-01 (168-169行目) | ○ |
| C-11 | 画面No.27セキュリティパネルが主機能として関連 | E-02 (72行目) | ○ |
| C-12 | getAccessDecision()でAccessDecisionオブジェクト返却 | E-01 (68-74行目) | ○ |
| C-13 | getFirewallConfig()でリクエストのファイアウォール設定取得 | E-01 (100-103行目) | ○ |
| C-14 | DI拡張による設定ツリー解析の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SecurityExtension::load()の設定ツリー構造の詳細
  - 候補：`src/Symfony/Bundle/SecurityBundle/DependencyInjection/SecurityExtension.php`

## 5) リスクフラグ（レビュー観点）
- 0: Securityクラスの主要メソッド - コードと整合
- 0: エラーケースの記載 - コードと整合
- 1: DI拡張の詳細 - 追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Security::login()のフローが正確か
- [ ] Security::logout()のCSRF検証ロジックが正確か
- [ ] 画面機能マッピング（画面No.27）が正しいか
- [ ] DI拡張の設定構造の補完が必要か確認
