---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：24-PasswordHasher

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **bcryptのデフォルトコスト値**：PHPバージョンによるデフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/PasswordHasher/PasswordHasherInterface.php` - インターフェース
- E-02: `src/Symfony/Component/PasswordHasher/Hasher/PasswordHasherFactory.php` - ファクトリ
- E-03: `src/Symfony/Component/PasswordHasher/Hasher/UserPasswordHasher.php` - ユーザーハッシャー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PasswordHasherInterfaceはhash, verify, needsRehashの3メソッド | E-01 (32, 37, 42行目) | ○ |
| C-02 | MAX_PASSWORD_LENGTH = 4096 | E-01 (26行目) | ○ |
| C-03 | #[SensitiveParameter]がplainPasswordに付与 | E-01 (32, 37行目) | ○ |
| C-04 | getPasswordHasher()でユーザークラスマッチングとPasswordHasherAwareInterface | E-02 (34-62行目) | ○ |
| C-05 | 'auto'でnative/sodium/pbkdf2のMigratingHasherを構築 | E-02 (111-133行目) | ○ |
| C-06 | migrate_fromオプションで移行元ハッシャーを指定可能 | E-02 (217-237行目) | ○ |
| C-07 | UserPasswordHasherでLegacyPasswordAuthenticatedUserInterfaceのsalt対応 | E-03 (33-36行目) | ○ |
| C-08 | hashPassword()でファクトリからハッシャー取得してhash | E-03 (38-41行目) | ○ |
| C-09 | isPasswordValid()でpasswordがnullの場合false | E-03 (50-51行目) | ○ |
| C-10 | needsRehash()でpasswordがnullの場合false | E-03 (61-62行目) | ○ |
| C-11 | bcrypt設定はnativeアルゴリズムにPASSWORD_BCRYPT定数で変換 | E-02 (157-161行目) | ○ |
| C-12 | SodiumPasswordHasher::isSupported()で利用可否判定 | E-02 (113行目) | ○ |
| C-13 | PlaintextPasswordHasherは平文保存（テスト用） | E-02 (140-144行目) | ○ |
| C-14 | NativePasswordHasher/SodiumPasswordHasher以外はMigratingPasswordHasherに含めない | E-02 (92-94行目) | ○ |
| C-15 | bcryptのデフォルトコスト13 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- bcryptのデフォルトコスト値はNativePasswordHasherの実装内部で確認が必要
  - 候補：`src/Symfony/Component/PasswordHasher/Hasher/NativePasswordHasher.php`

## 5) リスクフラグ（レビュー観点）
- 0: PasswordHasherInterfaceの仕様 - コードと整合
- 0: ファクトリのマッチングロジック - コードと整合
- 1: デフォルトコスト値の正確性 - NativePasswordHasher内部の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] PasswordHasherFactory::getPasswordHasher()のクラスマッチングロジックが正確か
- [ ] 'auto'アルゴリズムの構築フローが正確か
- [ ] UserPasswordHasher::hashPassword()のsalt処理が正確か
- [ ] bcrypt/argon2のデフォルトコスト値を確認
