---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-JsonPath

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **JsonPathTokenizerの内部実装**：トークン化ロジックの詳細は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/JsonPath/JsonCrawler.php` - JsonCrawlerクラス（全1130行を精読）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonCrawlerはJsonCrawlerInterfaceを実装 | E-01 (31行目) | ○ |
| C-02 | コンストラクタでstring/resource入力検証 | E-01 (58-64行目) | ○ |
| C-03 | RFC 9535準拠の5関数（length, count, match, search, value） | E-01 (33-39行目) | ○ |
| C-04 | COMPARISON_OPERATORS（!=, ==, >=, <=, >, <） | E-01 (46-53行目) | ○ |
| C-05 | evaluateTokensOnDecodedDataでRecursive+Bracketの特別処理 | E-01 (163-181行目) | ○ |
| C-06 | evaluateBracketで負インデックスは配列長+インデックスで計算 | E-01 (241-243行目) | ○ |
| C-07 | スライス記法のstep=0は空結果 | E-01 (323-325行目) | ○ |
| C-08 | 先頭ゼロ/整数オーバーフロー/先頭末尾カンマの検出 | E-01 (232, 248, 265, 222-224行目) | ○ |
| C-09 | フィルタ式で論理演算子(||, &&)をfindRightmostLogicalOperatorで評価 | E-01 (568, 627-666行目) | ○ |
| C-10 | evaluateFunction()でlength, count, match, search, valueを実装 | E-01 (785-803行目) | ○ |
| C-11 | SINGULAR_ARGUMENT_FUNCTIONSはlength, match, search | E-01 (41行目) | ○ |
| C-12 | ストリームリソース時にSplitterで最小化を試みる | E-01 (98-123行目) | ○ |
| C-13 | json_decodeの深さ制限512 | E-01 (88, 126行目) | ○ |
| C-14 | transformJsonPathRegexでRFC 9485準拠変換 | E-01 (1068-1090行目) | ○ |
| C-15 | Nothing列挙型で欠損値を表現 | E-01 (838-845行目) | ○ |
| C-16 | normalizeStorage()でstdClass/array正規化 | E-01 (1097-1100行目) | ○ |
| C-17 | JsonPathTokenizerのトークン化ロジック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- JsonPathTokenizer::tokenize()の内部実装
  - 候補：`src/Symfony/Component/JsonPath/Tokenizer/JsonPathTokenizer.php`

## 5) リスクフラグ（レビュー観点）
- 0: JsonCrawlerの処理フロー - コードと整合
- 0: RFC 9535準拠の関数サポート - コードと整合
- 0: エラーハンドリング - コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] evaluateBracket()の各バリエーション（インデックス、スライス、フィルタ等）が網羅されているか
- [ ] RFC 9535準拠の記述が正確か
- [ ] ストリームリソース処理のフォールバック動作が正確か
- [ ] Nothing列挙型の使用箇所が正しく記載されているか
