---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-Routing

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **国際化ルートの詳細動作**：ロケール付きルートの具体的実装未確認
  2. **ExpressionLanguage条件式の動作**：condition属性の評価フロー未詳細確認
  3. **1000+ルートでの性能記述**：パフォーマンスデータの裏付けなし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Routing/Router.php` - Routerクラス（行38-100）
- E-02: `src/Symfony/Component/Routing/Route.php` - Routeクラス（行20-100）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.3
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.3関連画面
- E-05: ファイル一覧（Matcher/, Generator/, Loader/ディレクトリの存在確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RouterはRouterInterfaceとRequestMatcherInterfaceを実装 | E-01 (行38) | ○ |
| C-02 | Route.phpにpath, host, schemes等の属性が定義されている | E-02 (行22-30) | ○ |
| C-03 | Router.phpのsetOptions()でcache_dir, debug等を設定 | E-01 (行84-95) | ○ |
| C-04 | デフォルトのマッチャーがCompiledUrlMatcher | E-01 (行91) | ○ |
| C-05 | デフォルトのジェネレーターがCompiledUrlGenerator | E-01 (行89) | ○ |
| C-06 | ルートは定義順に評価される | E-01 (ルートコレクション順序保証) | ○ |
| C-07 | 条件式はcondition属性で設定される | E-02 (行29) | ○ |
| C-08 | RouteはSerializableを実装 | E-02 (行20) | ○ |
| C-09 | Routerはキャッシュファクトリを使用する | E-01 (行46) | ○ |
| C-10 | ExpressionLanguageProviderをサポート | E-01 (行49-51) | ○ |
| C-11 | 関連画面が6画面ある | E-04 | ○ |
| C-12 | ルートコンパイルで正規表現を生成 | E-05 (RouteCompiler.php存在) | ○ |
| C-13 | CompiledUrlMatcherDumperが存在する | E-05 (ファイル一覧で確認) | ○ |
| C-14 | Alias.phpが存在する | E-05 (ファイル一覧で確認) | ○ |
| C-15 | Requirement/ディレクトリが存在する | E-05 (ファイル一覧で確認) | ○ |
| C-16 | 1000+ルートでも効率的にマッチング可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16：大量ルートでのパフォーマンス特性については、ベンチマークデータを確認していない
  - 候補：Symfony公式ドキュメント / CompiledUrlMatcherDumperの静的プレフィックス最適化コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Router.php、Route.phpの構造記述はコードに忠実
- 0: 低リスク - マッチャー/ジェネレーターの二分構造は正確
- 1: 中リスク - パフォーマンス特性は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] Route.phpの属性一覧が最新版と一致するか
- [ ] Router.phpのsetOptions()のデフォルト値が正確か
- [ ] 関連画面一覧が画面機能マッピング.csvと完全一致するか
- [ ] 国際化ルートの記述が正確か
