---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-Twig Bridge

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **各Extension内のTwig関数/フィルター名の正確性**：個別Extensionの詳細確認
  2. **フォームテーマテンプレートの網羅性**：テンプレートディレクトリの完全リスト確認
  3. **AppVariableの全プロパティの記載確認**：AppVariable.phpの全行読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/AppVariable.php`
- E-02: `src/Symfony/Bridge/Twig/Extension/` (ディレクトリ一覧)
- E-03: `src/Symfony/Bridge/Twig/Form/` (ディレクトリ構造から確認)
- E-04: `src/Symfony/Bridge/Twig/Mime/` (ディレクトリ構造から確認)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Twigと各種Symfonyコンポーネントの統合機能を提供する | E-05 | ○ |
| C-02 | 24個のExtensionファイルが存在する | E-02 (ディレクトリ一覧) | ○ |
| C-03 | AppVariableでrequest, session, user等にアクセスできる | E-01 (14-17, 37-60行目) | ○ |
| C-04 | FormExtensionがフォーム関連Twig関数を提供する | E-02 | ○ |
| C-05 | RoutingExtensionがpath/url関数を提供する | E-02 | ○ |
| C-06 | SecurityExtensionがis_granted関数を提供する | E-02 | ○ |
| C-07 | TranslationExtensionがtransフィルターを提供する | E-02 | ○ |
| C-08 | WorkflowExtensionが存在する | E-02 | ○ |
| C-09 | YamlExtensionが存在する | E-02 | ○ |
| C-10 | CsrfExtensionが存在する | E-02 | ○ |
| C-11 | 画面28（Twigパネル）と主機能として関連する | E-06 | ○ |
| C-12 | 画面43-53のフォームレイアウトと主機能として関連する | E-06 | ○ |
| C-13 | 画面54-57のメール通知テンプレートと主機能として関連する | E-06 | ○ |
| C-14 | RuntimeクラスがExtensionの一部に存在する | E-02 (CsrfRuntime, HttpKernelRuntime, ImportMapRuntime, SerializerRuntime) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張にソースコード根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がディレクトリ構造およびソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各Extensionの提供するTwig関数/フィルター名が正確か
- [ ] フォームテーマテンプレートのリストが完全か
- [ ] AppVariableのプロパティリストが完全か
- [ ] 関連画面の対応が画面機能マッピングと一致しているか
