---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：37-Messenger

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **DoctrineTransport テーブル構造**：実際のマイグレーション定義での確認が必要
  2. **MultiplierRetryStrategy の算出式**：Retryディレクトリの詳細確認
  3. **Worker::run() の全フロー**：Worker.phpの完全読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/MessageBus.php`
- E-02: `src/Symfony/Component/Messenger/Envelope.php`
- E-03: `src/Symfony/Component/Messenger/Worker.php`
- E-04: `src/Symfony/Component/Messenger/Middleware/` (ディレクトリ構造から確認)
- E-05: `src/Symfony/Component/Messenger/Transport/` (ディレクトリ構造から確認)
- E-06: `src/Symfony/Component/Messenger/Stamp/` (ディレクトリ構造から確認)
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージキュー経由でのメッセージ送受信機能を提供する | E-07 | ○ |
| C-02 | MessageBus::dispatch()がEnvelope::wrap()でラップ後にミドルウェアに委譲する | E-01 (54-70行目) | ○ |
| C-03 | ミドルウェアイテレータがrewind/validチェックで初期化される | E-01 (59-64行目) | ○ |
| C-04 | StackMiddlewareでミドルウェアチェーンを構築する | E-01 (67行目) | ○ |
| C-05 | Envelopeがstamps配列をクラス名キーで管理する | E-02 (26, 37行目) | ○ |
| C-06 | Envelope::with()がcloneでイミュータブルに動作する | E-02 (56-65行目) | ○ |
| C-07 | Envelope::last()が指定スタンプの最後の要素を返す | E-02 (102-105行目) | ○ |
| C-08 | Workerがreceivers, bus, eventDispatcher, logger, rateLimiters, clockを受け取る | E-03 (59-66行目) | ○ |
| C-09 | WorkerのデフォルトスリープがOptions sleep=1000000(1秒) | E-03 (78-79行目) | ○ |
| C-10 | 画面32（Messengerパネル）と主機能として関連する | E-08 | ○ |
| C-11 | TraceableMessageBus, RoutableMessageBusが存在する | ディレクトリ構造から確認 | ○ |
| C-12 | HandleTrait.phpが存在する | ディレクトリ構造から確認 | ○ |
| C-13 | DataCollectorが存在する | ディレクトリ構造から確認 | ○ |
| C-14 | Retryディレクトリが存在する | ディレクトリ構造から確認 | ○ |
| C-15 | AMQP, Doctrine, Redis等のトランスポートに対応する | E-07 | ○ |
| C-16 | DoctrineトランスポートのテーブルカラムがID, body, headers, queue_name, created_at, available_at, delivered_at | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16のDoctrineトランスポートテーブル構造は、Transport/Doctrine配下のソースコードでの確認が必要
  - 候補：Transport/Doctrine/Connection.php / マイグレーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアAPI（MessageBus, Envelope）はソースコードで確認済み
- 1: 中リスク - Worker::run()の完全フローは先頭80行のみ確認

## 6) レビュアーチェックリスト（最小）
- [ ] ミドルウェアパイプラインの記述がソースコードと一致しているか
- [ ] Doctrineトランスポートのテーブル構造が正確か
- [ ] リトライ戦略の記述が正確か
- [ ] Worker::run()の全フローが正しく記載されているか
