---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：38-Scheduler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **Symfony 6.3での導入時期**：CHANGELOG.mdでの確認が必要
  2. **Messenger TransportとしてのSchedulerTransport**：Messenger/配下の詳細確認
  3. **MessageGeneratorの詳細処理**：Generator/配下の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Scheduler/Scheduler.php`
- E-02: `src/Symfony/Component/Scheduler/Schedule.php`
- E-03: `src/Symfony/Component/Scheduler/RecurringMessage.php`
- E-04: `src/Symfony/Component/Scheduler/Trigger/` (ディレクトリ構造から確認)
- E-05: `src/Symfony/Component/Scheduler/Generator/` (ディレクトリ構造から確認)
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Symfony Messengerを活用したタスクスケジューリング機能 | E-06 | ○ |
| C-02 | RecurringMessage::every()でPeriodicalTriggerを使う | E-03 (48-50行目) | ○ |
| C-03 | RecurringMessage::cron()でCronExpressionTriggerを使う | E-03 (56-67行目) | ○ |
| C-04 | ハッシュドCronでStringableが必要 | E-03 (62-64行目) | ○ |
| C-05 | withJitter()でJitterTriggerを適用する | E-03 (89-92行目) | ○ |
| C-06 | RecurringMessage IDがcrc32cハッシュで生成される | E-03 (103-108行目) | ○ |
| C-07 | Schedule::add()で重複IDを検出してLogicExceptionをスロー | E-02 (54-56行目) | ○ |
| C-08 | Schedule::lock()でLockInterfaceを設定 | E-02 (100-105行目) | ○ |
| C-09 | Schedule::stateful()でCacheInterfaceを設定 | E-02 (115-120行目) | ○ |
| C-10 | Schedule::processOnlyLastMissedRun()で最終ミスのみ処理設定 | E-02 (130-135行目) | ○ |
| C-11 | Schedule::before/after/onFailureでイベントリスナー登録 | E-02 (158-189行目) | ○ |
| C-12 | Scheduler::run()がgeneratorsをループしメッセージを処理 | E-01 (61-107行目) | ○ |
| C-13 | PreRunEvent/PostRunEvent/FailureEventをディスパッチ | E-01 (78-97行目) | ○ |
| C-14 | スリープ計算で実行時間を差し引く | E-01 (102行目) | ○ |
| C-15 | shouldStopフラグで停止制御 | E-01 (65, 109-112行目) | ○ |
| C-16 | add/remove/clearでsetRestart(true)が呼ばれる | E-02 (46, 70, 94行目) | ○ |
| C-17 | Symfony 6.3で導入された | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17のSymfony 6.3導入時期については、CHANGELOG.mdまたは公式リリースノートでの確認が必要
  - 候補：CHANGELOG.md / composer.json / 公式ブログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアAPI（Scheduler, Schedule, RecurringMessage）はソースコードで詳細に確認済み
- 1: 中リスク - MessageGeneratorの詳細処理は直接読み込んでいない

## 6) レビュアーチェックリスト（最小）
- [ ] Scheduler::run()のフロー記述がソースコードと一致しているか
- [ ] RecurringMessageの各ファクトリメソッドの記述が正確か
- [ ] Scheduleのイベントリスナー登録の記述が正確か
- [ ] 導入バージョン（Symfony 6.3）が正しいかCHANGELOG.mdで確認
