---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-HttpClient

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **RetryableHttpClientのデフォルトリトライ戦略**：具体的なデフォルト値未確認
  2. **Messenger統合の詳細**：Messenger/ディレクトリの内容未詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/HttpClient/HttpClient.php` - ファクトリクラス（行22-78）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.4
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.4関連画面
- E-04: ファイル一覧（コンポーネントディレクトリ）
- E-05: `src/Symfony/Component/HttpClient/HttpClient.php` - create()メソッド（行31-67）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpClient::create()が環境に応じたクライアントを自動選択する | E-05 (行31-67) | ○ |
| C-02 | CurlHttpClient > AmpHttpClient > NativeHttpClientの優先順位 | E-05 (行33-67) | ○ |
| C-03 | maxHostConnectionsのデフォルトが6 | E-05 (行31) | ○ |
| C-04 | maxPendingPushesのデフォルトが50 | E-05 (行31) | ○ |
| C-05 | cURLバージョンチェックが0x073D00で行われる | E-05 (行47) | ○ |
| C-06 | createForBaseUri()がScopingHttpClient::forBaseUri()を利用 | E-05 (行72-77) | ○ |
| C-07 | NoPrivateNetworkHttpClient.phpが存在する | E-04 | ○ |
| C-08 | EventSourceHttpClient.phpが存在する | E-04 | ○ |
| C-09 | UriTemplateHttpClient.phpが存在する | E-04 | ○ |
| C-10 | ThrottlingHttpClient.phpが存在する | E-04 | ○ |
| C-11 | Psr18Client.phpが存在する | E-04 | ○ |
| C-12 | HttplugClient.phpが存在する | E-04 | ○ |
| C-13 | 関連画面が2画面ある | E-03 | ○ |
| C-14 | MockHttpClient.phpが存在する | E-04 | ○ |
| C-15 | RetryableHttpClientのデフォルトリトライ戦略が指数バックオフ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15：RetryableHttpClientの具体的なリトライ戦略のデフォルト値を確認していない
  - 候補：`src/Symfony/Component/HttpClient/Retry/GenericRetryStrategy.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファクトリクラスの自動選択ロジックはコードに忠実
- 0: 低リスク - ファイル一覧はディレクトリ確認で検証済み
- 1: 中リスク - リトライ戦略のデフォルト値は推定

## 6) レビュアーチェックリスト（最小）
- [ ] HttpClient::create()の条件分岐が最新コードと一致するか
- [ ] デコレーターパターンの一覧が網羅的か
- [ ] 関連画面一覧が画面機能マッピング.csvと一致するか
- [ ] RetryableHttpClientのデフォルトリトライ戦略が正確か
