---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：41-Notifier

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：FailoverTransport内部のリトライ動作の詳細が未確認
  2. **全チャネル（Browser、Push、Desktop）の動作詳細**：chat/email/smsのみ詳細確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Notifier/Notifier.php`
- E-02: `src/Symfony/Component/Notifier/NotifierInterface.php`
- E-03: `src/Symfony/Component/Notifier/Notification/Notification.php`
- E-04: `src/Symfony/Component/Notifier/Chatter.php`
- E-05: `src/Symfony/Component/Notifier/Texter.php`
- E-06: `src/Symfony/Component/Notifier/Transport.php`
- E-07: `src/Symfony/Component/Notifier/Channel/ChatChannel.php`
- E-08: `src/Symfony/Component/Notifier/Channel/EmailChannel.php`
- E-09: `src/Symfony/Component/Notifier/Channel/SmsChannel.php`
- E-10: `src/Symfony/Component/Notifier/DataCollector/NotificationDataCollector.php`
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Notifierは複数チャネルを通じた通知送信機能を提供する | E-01, E-11 | ○ |
| C-02 | 重要度に基づくチャネルポリシーで自動振り分けを行う | E-01 (69-81行目) | ○ |
| C-03 | recipient未指定時はNoRecipientが生成される | E-01 (42-44行目) | ○ |
| C-04 | チャネル名/トランスポート名は"/"で分離される | E-01 (85-88行目) | ○ |
| C-05 | SmsChannelでNoRecipientの場合はLogicException | E-01 (94-96行目) | ○ |
| C-06 | ChatChannelはChatNotificationInterfaceを判定する | E-07 (27-29行目) | ○ |
| C-07 | EmailChannelはMailer連携でメール送信する | E-08 (50-86行目) | ○ |
| C-08 | SmsChannelはSmsRecipientInterfaceをsupportsで判定する | E-09 (48-51行目) | ○ |
| C-09 | DSN "||" でFailoverTransportを構成する | E-06 (147-150行目) | ○ |
| C-10 | DSN "&&" でRoundRobinTransportを構成する | E-06 (152-155行目) | ○ |
| C-11 | 80以上のサードパーティサービスに対応 | E-06 (30-111行目) | ○ |
| C-12 | MessageBus設定時は非同期送信される | E-04 (45-53行目), E-05 (45-53行目) | ○ |
| C-13 | DSN文字列は#[\SensitiveParameter]で保護されている | E-06 (113行目) | ○ |
| C-14 | Notification::fromThrowable()で例外から通知を生成できる | E-03 (59-62行目) | ○ |
| C-15 | importanceはurgent/high/medium/lowの4段階 | E-03 (34-37行目) | ○ |
| C-16 | NotificationDataCollectorがプロファイラー用データを収集する | E-10 (30-33行目) | ○ |
| C-17 | ContainerInterfaceまたは配列からチャネルを取得する | E-01 (106-113行目) | ○ |
| C-18 | NullTransportFactoryが常にデフォルトで利用可能 | E-06 (195行目) | ○ |
| C-19 | FailoverTransportのリトライ動作の詳細 | **根拠なし** | △ |
| C-20 | Browser/Push/Desktopチャネルの動作詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FailoverTransportの内部リトライロジックの詳細が未確認
  - 候補：`src/Symfony/Component/Notifier/Transport/FailoverTransport.php`
- BrowserChannel、PushChannel、DesktopChannelの詳細実装が未確認
  - 候補：`src/Symfony/Component/Notifier/Channel/BrowserChannel.php` / `PushChannel.php` / `DesktopChannel.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインの通知フロー（send -> channel -> transport）は十分な根拠あり
- 1: 中リスク - FailoverTransportのリトライ詳細は補完が望ましい
- 0: 低リスク - 80以上のサードパーティ連携はFACTORY_CLASSES定数で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] チャネルポリシーによるチャネル決定ロジックが正確に記述されているか
- [ ] 非同期送信（Messenger統合）の動作が正しく記述されているか
- [ ] Browser/Push/Desktopチャネルの動作詳細を補完する必要があるか確認
- [ ] FailoverTransportのリトライ仕様を補完する必要があるか確認
