---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-Webhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Webhook/Controller/WebhookController.php`
- E-02: `src/Symfony/Component/Webhook/Subscriber.php`
- E-03: `src/Symfony/Component/Webhook/Client/RequestParser.php`
- E-04: `src/Symfony/Component/Webhook/Server/Transport.php`
- E-05: `src/Symfony/Component/RemoteEvent/RemoteEvent.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebhookControllerがHTTPリクエストを受信しパーサーに委譲する | E-01 (36-56行目) | ○ |
| C-02 | type未登録時にHTTP 404を返す | E-01 (38-39行目) | ○ |
| C-03 | パース結果をConsumeRemoteEventMessageとしてMessengerバスにディスパッチする | E-01 (52行目) | ○ |
| C-04 | RequestParserはPOST+JSONのみ受け付ける | E-03 (37-43行目) | ○ |
| C-05 | Webhook-Signature/Event/Idの3ヘッダーが必須 | E-03 (53-57行目) | ○ |
| C-06 | HMAC署名はhash_equals()で検証される | E-03 (74行目) | ○ |
| C-07 | 署名計算式はhash_hmac(algo, event+id+body, secret) | E-03 (74行目) | ○ |
| C-08 | Subscriberのsecretは空文字列不可 | E-02 (22-24行目) | ○ |
| C-09 | Subscriber.secretは#[\SensitiveParameter]で保護 | E-02 (21行目) | ○ |
| C-10 | 送信側TransportはHeaders/Body/Signerの3段階でリクエスト構成する | E-04 (36-38行目) | ○ |
| C-11 | 送信はHTTP POSTメソッドで行われる | E-04 (40行目) | ○ |
| C-12 | RemoteEventはname、id、payloadで構成される | E-05 (19-23行目) | ○ |
| C-13 | 署名不一致時にRejectWebhookException(406)が発生する | E-03 (76行目) | ○ |
| C-14 | ヘッダー不足時にRejectWebhookException(406)が発生する | E-03 (55-56行目) | ○ |
| C-15 | パース結果は配列またはRemoteEventとして扱われる | E-01 (49行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Webhookコンポーネントは比較的シンプルな構造で、すべての主要フローが確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HMAC署名検証ロジックが正確に記述されているか
- [ ] WebhookController -> RequestParser -> MessageBus のフローが正しいか
- [ ] 送信側Transport のリクエスト構成順序が正しいか
