---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-Stopwatch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Stopwatch/Stopwatch.php`
- E-02: `src/Symfony/Component/Stopwatch/StopwatchEvent.php`
- E-03: `src/Symfony/Component/Stopwatch/Section.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Stopwatchは ResetInterfaceを実装する | E-01 (24行目) | ○ |
| C-02 | start()はactiveSectionsの末尾でstartEvent()を呼ぶ | E-01 (99-102行目) | ○ |
| C-03 | stop()はactiveSectionsの末尾でstopEvent()を呼ぶ | E-01 (115-118行目) | ○ |
| C-04 | lap()はstop().start()の連鎖で実装される | E-01 (123-126行目) | ○ |
| C-05 | openSection()で子セクションを作成/再開する | E-01 (62-73行目) | ○ |
| C-06 | stopSection()でセクションにIDを割り当てて保存する | E-01 (84-94行目) | ○ |
| C-07 | start()なしでstop()を呼ぶとLogicException | E-02 (90-92行目) | ○ |
| C-08 | getDuration()は全ピリオドの合計時間を返す | E-02 (178-193行目) | ○ |
| C-09 | getMemory()は全ピリオドの最大メモリを返す | E-02 (199-208行目) | ○ |
| C-10 | Section::startEvent()は既存イベントの再利用に対応 | E-03 (91-98行目) | ○ |
| C-11 | 実行時間はmicrotime(true) * 1000 - originで計算される | E-02 (215行目) | ○ |
| C-12 | formatTime()で小数点1桁に丸める | E-02 (221-224行目) | ○ |
| C-13 | reset()でsections/activeSectionsを初期化する | E-01 (159-162行目) | ○ |
| C-14 | ROOT定数は'__root__' | E-01 (26行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。Stopwatchコンポーネントは4ファイルのみで構成されており、すべて確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ファイルのソースコードが確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 時間計測のロジック（origin、formatTime）が正確に記述されているか
- [ ] セクションのネスト動作が正しく記述されているか
