---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-Lock

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Lock/Lock.php`
- E-02: `src/Symfony/Component/Lock/LockFactory.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LockはSharedLockInterfaceとLoggerAwareInterfaceを実装する | E-01 (27行目) | ○ |
| C-02 | デフォルトTTLは300.0秒 | E-02 (39行目) | ○ |
| C-03 | autoRelease=trueの場合、デストラクタで自動解放 | E-01 (58-65行目) | ○ |
| C-04 | blocking=true時のBlockingStoreInterface判定とwaitAndSave | E-01 (71-83行目) | ○ |
| C-05 | 非BlockingStoreでのブロッキングリトライ（100ms±10ms） | E-01 (73-80行目) | ○ |
| C-06 | blocking=false時のsave直接呼び出し | E-01 (85行目) | ○ |
| C-07 | TTL設定時にrefresh()を呼び出す | E-01 (91-93行目) | ○ |
| C-08 | 期限切れ時にrelease+LockExpiredException | E-01 (95-102行目) | ○ |
| C-09 | acquireRead()でSharedLockStoreInterface非対応時にacquire()フォールバック | E-01 (124-128行目) | ○ |
| C-10 | refresh()でputOffExpiration呼び出し | E-01 (186行目) | ○ |
| C-11 | refresh()時にTTL未設定でInvalidArgumentException | E-01 (181行目) | ○ |
| C-12 | isAcquired()はstore::exists()を呼ぶ | E-01 (211行目) | ○ |
| C-13 | release()はstore::delete()後にexists()で確認 | E-01 (218, 226行目) | ○ |
| C-14 | シリアライズ時にBadMethodCallException | E-01 (46-48行目) | ○ |
| C-15 | LockFactory::createLock()はnew Key + new Lockを生成 | E-02 (39-42行目) | ○ |
| C-16 | LockFactory::createLockFromKey()でLoggerを設定 | E-02 (51-59行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Lock/LockFactoryの主要フローはすべて確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ブロッキングリトライロジックが正確に記述されているか
- [ ] 共有ロックのフォールバック動作が正しいか
- [ ] エラー処理（LockConflictedException等）の分類が適切か
