---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-Semaphore

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Semaphore/Semaphore.php`
- E-02: `src/Symfony/Component/Semaphore/SemaphoreFactory.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SemaphoreはSemaphoreInterfaceとLoggerAwareInterfaceを実装する | E-01 (28行目) | ○ |
| C-02 | デフォルトTTLは300.0秒 | E-01 (37行目), E-02 (37行目) | ○ |
| C-03 | autoRelease=trueの場合、デストラクタで自動解放 | E-01 (55-62行目) | ○ |
| C-04 | acquire()はstore::save()でスロット確保する | E-01 (68行目) | ○ |
| C-05 | acquire()でKey::reduceLifetime()を呼ぶ | E-01 (69行目) | ○ |
| C-06 | SemaphoreAcquiringException時にfalseを返す | E-01 (75-78行目) | ○ |
| C-07 | refresh()はstore::putOffExpiration()を呼ぶ | E-01 (94行目) | ○ |
| C-08 | SemaphoreExpiredException時にdirty=falseにする | E-01 (100-104行目) | ○ |
| C-09 | isAcquired()はstore::exists()を呼ぶ | E-01 (114行目) | ○ |
| C-10 | release()はstore::delete()を呼ぶ | E-01 (120行目) | ○ |
| C-11 | シリアライズ時にBadMethodCallException | E-01 (43-44行目) | ○ |
| C-12 | createSemaphore()はnew Key(resource, limit, weight)を生成 | E-02 (39行目) | ○ |
| C-13 | createSemaphoreFromKey()でLoggerを設定 | E-02 (48-54行目) | ○ |
| C-14 | refresh時にTTL未設定でInvalidArgumentException | E-01 (88-89行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Semaphore/SemaphoreFactoryの主要フローはすべて確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] acquire/releaseのライフサイクルが正確に記述されているか
- [ ] Lockコンポーネントとの違い（排他 vs 並行）が明確に記述されているか
- [ ] Key(resource, limit, weight)のパラメータが正しいか
