---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：51-Translation

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **外部翻訳プロバイダーとの連携詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Translator.php`
- E-02: `src/Symfony/Component/Translation/MessageCatalogue.php`
- E-03: `src/Symfony/Component/Translation/TranslatableMessage.php`
- E-04: `src/Symfony/Component/Translation/LocaleSwitcher.php`
- E-05: `src/Symfony/Component/Translation/Loader/` (ディレクトリ内のローダー群)
- E-06: `src/Symfony/Component/Translation/Dumper/` (ディレクトリ内のダンパー群)
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | trans()メソッドは空IDの場合空文字を返す | E-01 (187-189行目) | ○ |
| C-02 | ロケールバリデーションは正規表現`/^[a-z0-9@_\\.\\-]*$/i`で行う | E-01 (455行目) | ○ |
| C-03 | フォールバックはparent localesとfallback localesの2段階 | E-01 (407-446行目) | ○ |
| C-04 | MessageCatalogueはINTL_DOMAIN_SUFFIX(+intl-icu)でドメインを区別 | E-02 (47-48, 60-64行目) | ○ |
| C-05 | カタログキャッシュはPHPファイルとして保存される | E-01 (310-332行目) | ○ |
| C-06 | TranslatableMessageはTranslatableInterfaceを実装する | E-03 (20行目) | ○ |
| C-07 | LocaleSwitcherはrunWithLocaleで一時的にロケール変更が可能 | E-04 (67-77行目) | ○ |
| C-08 | XLIFF, YAML, PHP, PO, MO, JSON, CSV, INI等の翻訳ファイル形式に対応 | E-05 (ディレクトリ内ファイル一覧) | ○ |
| C-09 | カタログのフォールバック設定で循環参照検出を行う | E-02 (172-178行目) | ○ |
| C-10 | addResource時にフォールバックロケールの場合は全カタログクリア | E-01 (121-125行目) | ○ |
| C-11 | キャッシュパスはxxh128ハッシュのBase64先頭7文字を使用 | E-01 (365行目) | ○ |
| C-12 | opcache.preloadでMessageCatalogueをプリロード | E-01 (29行目) | ○ |
| C-13 | フォールバックロケール変更がない場合はカタログ再生成をスキップ | E-01 (148-151行目) | ○ |
| C-14 | ICU MessageFormat対応はIntlFormatterInterfaceの有無で判定 | E-01 (86, 224-228行目) | ○ |
| C-15 | グローバルパラメータ機能を持つ | E-01 (174-183, 210-221行目) | ○ |
| C-16 | 画面No.26（翻訳パネル）と関連 | E-08 (翻訳パネル行) | ○ |
| C-17 | RuntimeExceptionはローダー未登録時にスロー | E-01 (379-383行目) | ○ |
| C-18 | parents.jsonから親ロケール情報を取得 | E-01 (409行目) | ○ |
| C-19 | setLocaleでLocale::setDefaultも更新する | E-04 (39-41行目) | ○ |
| C-20 | 外部翻訳プロバイダー(Crowdin, Loco, Lokalise)との連携が可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: 外部翻訳プロバイダーとの連携はTranslation Providerディレクトリに実装があると推定されるが、詳細なProvider実装コードは未確認
  - 候補：`src/Symfony/Component/Translation/Provider/` / composer.json の suggest セクション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインの翻訳処理フローは十分なコード根拠あり
- 0: 低リスク - エラー処理の記述はコードと整合
- 1: 中リスク - 外部プロバイダー連携の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] trans()メソッドのフォールバック解決ロジックが正確に記述されているか確認
- [ ] MessageCatalogueのINTL_DOMAIN_SUFFIX処理の説明が適切か確認
- [ ] 外部翻訳プロバイダーとの連携に関する記述を補完する必要があるか判断
